/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.cluster.NodeTypeEventChannel;
import org.apache.jackrabbit.core.cluster.NodeTypeEventListener;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.nodetype.BitsetENTCacheImpl;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeTypeCache;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.NodeDefImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeDefDiff;
import org.apache.jackrabbit.core.nodetype.NodeTypeDefStore;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropDefId;
import org.apache.jackrabbit.core.nodetype.ReferenceConstraint;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;

public class NodeTypeRegistry
implements Dumpable,
NodeTypeEventListener {
    private static Logger log = CommonSLF4JLogger.getLogger(NodeTypeRegistry.class);
    private static final String BUILTIN_NODETYPES_RESOURCE_PATH = "org/apache/jackrabbit/core/nodetype/builtin_nodetypes.xml";
    private static final String CUSTOM_NODETYPES_RESOURCE_NAME = "custom_nodetypes.xml";
    private final FileSystem ntStore;
    private final FileSystemResource customNodeTypesResource;
    private final NodeTypeDefStore builtInNTDefs;
    private final NodeTypeDefStore customNTDefs;
    private EffectiveNodeTypeCache entCache;
    private final ConcurrentReaderHashMap registeredNTDefs;
    private final NodeDef rootNodeDef;
    private final ConcurrentReaderHashMap propDefs;
    private final ConcurrentReaderHashMap nodeDefs;
    private final NamespaceRegistry nsReg;
    private final Map listeners = Collections.synchronizedMap(new ReferenceMap(2, 2));
    private NodeTypeEventChannel eventChannel;

    public static NodeTypeRegistry create(NamespaceRegistry nsReg, FileSystem ntStore) throws RepositoryException {
        NodeTypeRegistry ntMgr = new NodeTypeRegistry(nsReg, ntStore);
        return ntMgr;
    }

    public Name[] getRegisteredNodeTypes() {
        return this.registeredNTDefs.keySet().toArray(new Name[this.registeredNTDefs.size()]);
    }

    public synchronized EffectiveNodeType registerNodeType(NodeTypeDef ntd) throws InvalidNodeTypeDefException, RepositoryException {
        EffectiveNodeType ent = this.internalRegister(ntd);
        this.customNTDefs.add(ntd);
        this.persistCustomNodeTypeDefs(this.customNTDefs);
        if (this.eventChannel != null) {
            HashSet<NodeTypeDef> ntDefs = new HashSet<NodeTypeDef>();
            ntDefs.add(ntd);
            this.eventChannel.registered(ntDefs);
        }
        this.notifyRegistered(ntd.getName());
        return ent;
    }

    public void registerNodeTypes(Collection ntDefs) throws InvalidNodeTypeDefException, RepositoryException {
        this.registerNodeTypes(ntDefs, false);
    }

    private synchronized void registerNodeTypes(Collection ntDefs, boolean external) throws InvalidNodeTypeDefException, RepositoryException {
        this.internalRegister(ntDefs);
        for (NodeTypeDef ntDef : ntDefs) {
            this.customNTDefs.add(ntDef);
        }
        this.persistCustomNodeTypeDefs(this.customNTDefs);
        if (!external && this.eventChannel != null) {
            this.eventChannel.registered(ntDefs);
        }
        for (NodeTypeDef ntDef : ntDefs) {
            this.notifyRegistered(ntDef.getName());
        }
    }

    public void unregisterNodeTypes(Collection ntNames) throws NoSuchNodeTypeException, RepositoryException {
        this.unregisterNodeTypes(ntNames, false);
    }

    private synchronized void unregisterNodeTypes(Collection ntNames, boolean external) throws NoSuchNodeTypeException, RepositoryException {
        for (Name ntName : ntNames) {
            if (!this.registeredNTDefs.containsKey((Object)ntName)) {
                throw new NoSuchNodeTypeException(ntName.toString());
            }
            if (this.builtInNTDefs.contains(ntName)) {
                throw new RepositoryException(ntName.toString() + ": can't unregister built-in node type.");
            }
            Set dependents = this.getDependentNodeTypes(ntName);
            dependents.removeAll(ntNames);
            if (dependents.size() <= 0) continue;
            StringBuffer msg = new StringBuffer();
            msg.append(ntName).append(" can not be removed because the following node types depend on it: ");
            Iterator depIter = dependents.iterator();
            while (depIter.hasNext()) {
                msg.append(depIter.next());
                msg.append(" ");
            }
            throw new RepositoryException(msg.toString());
        }
        for (Name ntName : ntNames) {
            this.checkForReferencesInContent(ntName);
        }
        this.internalUnregister(ntNames);
        if (!external && this.eventChannel != null) {
            this.eventChannel.unregistered(ntNames);
        }
        for (Name ntName : ntNames) {
            this.customNTDefs.remove(ntName);
            this.notifyUnregistered(ntName);
        }
        this.persistCustomNodeTypeDefs(this.customNTDefs);
    }

    public void unregisterNodeType(Name ntName) throws NoSuchNodeTypeException, RepositoryException {
        HashSet<Name> ntNames = new HashSet<Name>();
        ntNames.add(ntName);
        this.unregisterNodeTypes(ntNames);
    }

    public EffectiveNodeType reregisterNodeType(NodeTypeDef ntd) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        return this.reregisterNodeType(ntd, false);
    }

    private synchronized EffectiveNodeType reregisterNodeType(NodeTypeDef ntd, boolean external) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        Name name = ntd.getName();
        if (!this.registeredNTDefs.containsKey((Object)name)) {
            throw new NoSuchNodeTypeException(name.toString());
        }
        if (this.builtInNTDefs.contains(name)) {
            throw new RepositoryException(name.toString() + ": can't reregister built-in node type.");
        }
        NodeTypeRegistry.validateNodeTypeDef(ntd, this.entCache, (Map)this.registeredNTDefs, this.nsReg, false);
        NodeTypeDef ntdOld = (NodeTypeDef)this.registeredNTDefs.get((Object)name);
        NodeTypeDefDiff diff = NodeTypeDefDiff.create(ntdOld, ntd);
        if (!diff.isModified()) {
            return this.getEffectiveNodeType(name);
        }
        if (diff.isTrivial()) {
            this.internalUnregister(name);
            this.customNTDefs.remove(name);
            EffectiveNodeType entNew = this.internalRegister(ntd);
            this.customNTDefs.add(ntd);
            this.persistCustomNodeTypeDefs(this.customNTDefs);
            if (!external && this.eventChannel != null) {
                this.eventChannel.reregistered(ntd);
            }
            this.notifyReRegistered(name);
            return entNew;
        }
        String message = "The following nodetype change contains non-trivial changes.Up until now only trivial changes are supported. (see javadoc for " + NodeTypeDefDiff.class.getName() + "):\n" + diff.toString();
        throw new RepositoryException(message);
    }

    public EffectiveNodeType getEffectiveNodeType(Name ntName) throws NoSuchNodeTypeException {
        return NodeTypeRegistry.getEffectiveNodeType(ntName, this.entCache, (Map)this.registeredNTDefs);
    }

    public EffectiveNodeType getEffectiveNodeType(Name[] ntNames) throws NodeTypeConflictException, NoSuchNodeTypeException {
        return NodeTypeRegistry.getEffectiveNodeType(ntNames, this.entCache, (Map)this.registeredNTDefs);
    }

    public Set getDependentNodeTypes(Name nodeTypeName) throws NoSuchNodeTypeException {
        if (!this.registeredNTDefs.containsKey((Object)nodeTypeName)) {
            throw new NoSuchNodeTypeException(nodeTypeName.toString());
        }
        HashSet<Name> names = new HashSet<Name>();
        for (NodeTypeDef ntd : this.registeredNTDefs.values()) {
            if (!ntd.getDependencies().contains(nodeTypeName)) continue;
            names.add(ntd.getName());
        }
        return names;
    }

    public NodeTypeDef getNodeTypeDef(Name nodeTypeName) throws NoSuchNodeTypeException {
        NodeTypeDef def = (NodeTypeDef)this.registeredNTDefs.get((Object)nodeTypeName);
        if (def == null) {
            throw new NoSuchNodeTypeException(nodeTypeName.toString());
        }
        return (NodeTypeDef)def.clone();
    }

    public boolean isRegistered(Name nodeTypeName) {
        return this.registeredNTDefs.containsKey((Object)nodeTypeName);
    }

    public boolean isBuiltIn(Name nodeTypeName) {
        return this.builtInNTDefs.contains(nodeTypeName);
    }

    public NodeDef getNodeDef(NodeDefId id) {
        return (NodeDef)this.nodeDefs.get((Object)id);
    }

    public PropDef getPropDef(PropDefId id) {
        return (PropDef)this.propDefs.get((Object)id);
    }

    public void addListener(NodeTypeRegistryListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    public void removeListener(NodeTypeRegistryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("NodeTypeRegistry (" + this + ")");
        ps.println();
        ps.println("Registered NodeTypes:");
        ps.println();
        for (NodeTypeDef ntd : this.registeredNTDefs.values()) {
            ps.println(ntd.getName());
            Name[] supertypes = ntd.getSupertypes();
            ps.println("\tSupertypes");
            for (int i = 0; i < supertypes.length; ++i) {
                ps.println("\t\t" + supertypes[i]);
            }
            ps.println("\tMixin\t" + ntd.isMixin());
            ps.println("\tOrderableChildNodes\t" + ntd.hasOrderableChildNodes());
            ps.println("\tPrimaryItemName\t" + (ntd.getPrimaryItemName() == null ? "<null>" : ntd.getPrimaryItemName().toString()));
            PropDef[] pd = ntd.getPropertyDefs();
            for (int i = 0; i < pd.length; ++i) {
                ps.print("\tPropertyDefinition");
                ps.println(" (declared in " + pd[i].getDeclaringNodeType() + ") id=" + pd[i].getId());
                ps.println("\t\tName\t\t" + (pd[i].definesResidual() ? "*" : pd[i].getName().toString()));
                String type = pd[i].getRequiredType() == 0 ? "null" : PropertyType.nameFromValue((int)pd[i].getRequiredType());
                ps.println("\t\tRequiredType\t" + type);
                ValueConstraint[] vca = pd[i].getValueConstraints();
                StringBuffer constraints = new StringBuffer();
                if (vca == null) {
                    constraints.append("<null>");
                } else {
                    for (int n = 0; n < vca.length; ++n) {
                        if (constraints.length() > 0) {
                            constraints.append(", ");
                        }
                        constraints.append(vca[n].getDefinition());
                    }
                }
                ps.println("\t\tValueConstraints\t" + constraints.toString());
                InternalValue[] defVals = pd[i].getDefaultValues();
                StringBuffer defaultValues = new StringBuffer();
                if (defVals == null) {
                    defaultValues.append("<null>");
                } else {
                    for (int n = 0; n < defVals.length; ++n) {
                        if (defaultValues.length() > 0) {
                            defaultValues.append(", ");
                        }
                        defaultValues.append(defVals[n].toString());
                    }
                }
                ps.println("\t\tDefaultValue\t" + defaultValues.toString());
                ps.println("\t\tAutoCreated\t" + pd[i].isAutoCreated());
                ps.println("\t\tMandatory\t" + pd[i].isMandatory());
                ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)pd[i].getOnParentVersion()));
                ps.println("\t\tProtected\t" + pd[i].isProtected());
                ps.println("\t\tMultiple\t" + pd[i].isMultiple());
            }
            NodeDef[] nd = ntd.getChildNodeDefs();
            for (int i = 0; i < nd.length; ++i) {
                Name defPrimaryType;
                ps.print("\tNodeDefinition");
                ps.println(" (declared in " + nd[i].getDeclaringNodeType() + ") id=" + nd[i].getId());
                ps.println("\t\tName\t\t" + (nd[i].definesResidual() ? "*" : nd[i].getName().toString()));
                Name[] reqPrimaryTypes = nd[i].getRequiredPrimaryTypes();
                if (reqPrimaryTypes != null && reqPrimaryTypes.length > 0) {
                    for (int n = 0; n < reqPrimaryTypes.length; ++n) {
                        ps.print("\t\tRequiredPrimaryType\t" + reqPrimaryTypes[n]);
                    }
                }
                if ((defPrimaryType = nd[i].getDefaultPrimaryType()) != null) {
                    ps.print("\n\t\tDefaultPrimaryType\t" + defPrimaryType);
                }
                ps.println("\n\t\tAutoCreated\t" + nd[i].isAutoCreated());
                ps.println("\t\tMandatory\t" + nd[i].isMandatory());
                ps.println("\t\tOnVersion\t" + OnParentVersionAction.nameFromValue((int)nd[i].getOnParentVersion()));
                ps.println("\t\tProtected\t" + nd[i].isProtected());
                ps.println("\t\tAllowsSameNameSiblings\t" + nd[i].allowsSameNameSiblings());
            }
        }
        ps.println();
        this.entCache.dump(ps);
    }

    @Override
    public void externalRegistered(Collection ntDefs) throws RepositoryException, InvalidNodeTypeDefException {
        this.registerNodeTypes(ntDefs, true);
    }

    @Override
    public void externalReregistered(NodeTypeDef ntDef) throws NoSuchNodeTypeException, InvalidNodeTypeDefException, RepositoryException {
        this.reregisterNodeType(ntDef, true);
    }

    @Override
    public void externalUnregistered(Collection ntNames) throws RepositoryException, NoSuchNodeTypeException {
        this.unregisterNodeTypes(ntNames, true);
    }

    protected NodeTypeRegistry(NamespaceRegistry nsReg, FileSystem ntStore) throws RepositoryException {
        this.nsReg = nsReg;
        this.ntStore = ntStore;
        this.customNodeTypesResource = new FileSystemResource(this.ntStore, CUSTOM_NODETYPES_RESOURCE_NAME);
        try {
            if (!this.customNodeTypesResource.exists()) {
                this.customNodeTypesResource.makeParentDirs();
            }
        }
        catch (FileSystemException fse) {
            String error = "internal error: invalid resource: " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)fse);
        }
        this.entCache = new BitsetENTCacheImpl();
        this.registeredNTDefs = new ConcurrentReaderHashMap();
        this.propDefs = new ConcurrentReaderHashMap();
        this.nodeDefs = new ConcurrentReaderHashMap();
        this.rootNodeDef = NodeTypeRegistry.createRootNodeDef();
        this.nodeDefs.put((Object)this.rootNodeDef.getId(), (Object)this.rootNodeDef);
        this.builtInNTDefs = new NodeTypeDefStore();
        try {
            this.loadBuiltInNodeTypeDefs(this.builtInNTDefs);
            this.internalRegister(this.builtInNTDefs.all(), true);
        }
        catch (InvalidNodeTypeDefException intde) {
            String error = "internal error: invalid built-in node type definition stored in org/apache/jackrabbit/core/nodetype/builtin_nodetypes.xml";
            log.debug(error);
            throw new RepositoryException(error, (Throwable)intde);
        }
        this.customNTDefs = new NodeTypeDefStore();
        this.loadCustomNodeTypeDefs(this.customNTDefs);
        try {
            this.internalRegister(this.customNTDefs.all());
        }
        catch (InvalidNodeTypeDefException intde) {
            String error = "internal error: invalid custom node type definition stored in " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)intde);
        }
    }

    protected void loadBuiltInNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        InputStream in = null;
        try {
            in = this.getClass().getClassLoader().getResourceAsStream(BUILTIN_NODETYPES_RESOURCE_PATH);
            store.load(in);
        }
        catch (IOException ioe) {
            String error = "internal error: failed to read built-in node type definitions stored in org/apache/jackrabbit/core/nodetype/builtin_nodetypes.xml";
            log.debug(error);
            throw new RepositoryException(error, (Throwable)ioe);
        }
        catch (InvalidNodeTypeDefException intde) {
            String error = "internal error: invalid built-in node type definition stored in org/apache/jackrabbit/core/nodetype/builtin_nodetypes.xml";
            log.debug(error);
            throw new RepositoryException(error, (Throwable)intde);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void loadCustomNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        InputStream in = null;
        try {
            if (this.customNodeTypesResource.exists()) {
                in = this.customNodeTypesResource.getInputStream();
            }
        }
        catch (FileSystemException fse) {
            String error = "internal error: failed to access custom node type definitions stored in " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)fse);
        }
        if (in == null) {
            log.info("no custom node type definitions found");
        } else {
            try {
                store.load(in);
            }
            catch (IOException ioe) {
                String error = "internal error: failed to read custom node type definitions stored in " + this.customNodeTypesResource.getPath();
                log.debug(error);
                throw new RepositoryException(error, (Throwable)ioe);
            }
            catch (InvalidNodeTypeDefException intde) {
                String error = "internal error: invalid custom node type definition stored in " + this.customNodeTypesResource.getPath();
                log.debug(error);
                throw new RepositoryException(error, (Throwable)intde);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void persistCustomNodeTypeDefs(NodeTypeDefStore store) throws RepositoryException {
        try (OutputStream out = this.customNodeTypesResource.getOutputStream();){
            store.store(out, this.nsReg);
        }
        catch (IOException ioe) {
            String error = "internal error: failed to persist custom node type definitions to " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)ioe);
        }
        catch (FileSystemException fse) {
            String error = "internal error: failed to persist custom node type definitions to " + this.customNodeTypesResource.getPath();
            log.debug(error);
            throw new RepositoryException(error, (Throwable)fse);
        }
    }

    protected void checkForConflictingContent(NodeTypeDef ntd) throws RepositoryException {
        throw new RepositoryException("not yet implemented");
    }

    protected void checkForReferencesInContent(Name nodeTypeName) throws RepositoryException {
        throw new RepositoryException("not yet implemented");
    }

    public NodeDef getRootNodeDef() {
        return this.rootNodeDef;
    }

    public void setEventChannel(NodeTypeEventChannel eventChannel) {
        this.eventChannel = eventChannel;
        eventChannel.setListener(this);
    }

    static EffectiveNodeType getEffectiveNodeType(Name ntName, EffectiveNodeTypeCache entCache, Map ntdCache) throws NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(new Name[]{ntName});
        EffectiveNodeType ent = entCache.get(key);
        if (ent != null) {
            return ent;
        }
        NodeTypeDef ntd = (NodeTypeDef)ntdCache.get(ntName);
        if (ntd == null) {
            throw new NoSuchNodeTypeException(ntName.toString());
        }
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            try {
                ent = EffectiveNodeType.create(ntd, entCache, ntdCache);
                entCache.put(ent);
                return ent;
            }
            catch (NodeTypeConflictException ntce) {
                String msg = "internal error: encountered invalid registered node type " + ntName;
                log.debug(msg);
                throw new NoSuchNodeTypeException(msg, (Throwable)ntce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EffectiveNodeType getEffectiveNodeType(Name[] ntNames, EffectiveNodeTypeCache entCache, Map ntdCache) throws NodeTypeConflictException, NoSuchNodeTypeException {
        EffectiveNodeTypeCache.Key key = entCache.getKey(ntNames);
        if (entCache.contains(key)) {
            return entCache.get(key);
        }
        for (int i = 0; i < ntNames.length; ++i) {
            if (ntdCache.containsKey(ntNames[i])) continue;
            throw new NoSuchNodeTypeException(ntNames[i].toString());
        }
        EffectiveNodeTypeCache.Key requested = key;
        EffectiveNodeType result = null;
        EffectiveNodeTypeCache effectiveNodeTypeCache = entCache;
        synchronized (effectiveNodeTypeCache) {
            while (key.getNames().length > 0) {
                EffectiveNodeTypeCache.Key subKey = entCache.findBest(key);
                if (subKey != null) {
                    EffectiveNodeType ent = entCache.get(subKey);
                    if (result == null) {
                        result = ent;
                    } else {
                        result = result.merge(ent);
                        entCache.put(result);
                    }
                    key = key.subtract(subKey);
                    continue;
                }
                Name[] remainder = key.getNames();
                for (int i = 0; i < remainder.length; ++i) {
                    NodeTypeDef ntd = (NodeTypeDef)ntdCache.get(remainder[i]);
                    EffectiveNodeType ent = EffectiveNodeType.create(ntd, entCache, ntdCache);
                    entCache.put(ent);
                    if (result == null) {
                        result = ent;
                        continue;
                    }
                    result = result.merge(ent);
                    entCache.put(result);
                }
            }
        }
        if (!entCache.contains(requested)) {
            entCache.put(requested, result);
        }
        return result;
    }

    static void checkForCircularInheritance(Name[] supertypes, Stack inheritanceChain, Map ntDefCache) throws InvalidNodeTypeDefException, RepositoryException {
        for (int i = 0; i < supertypes.length; ++i) {
            Name nt = supertypes[i];
            int pos = inheritanceChain.lastIndexOf(nt);
            if (pos >= 0) {
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < inheritanceChain.size(); ++j) {
                    if (j == pos) {
                        buf.append("--> ");
                    }
                    buf.append(inheritanceChain.get(j));
                    buf.append(" extends ");
                }
                buf.append("--> ");
                buf.append(nt);
                throw new InvalidNodeTypeDefException("circular inheritance detected: " + buf.toString());
            }
            try {
                NodeTypeDef ntd = (NodeTypeDef)ntDefCache.get(nt);
                Name[] sta = ntd.getSupertypes();
                if (sta.length <= 0) continue;
                inheritanceChain.push(nt);
                NodeTypeRegistry.checkForCircularInheritance(sta, inheritanceChain, ntDefCache);
                inheritanceChain.pop();
                continue;
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg = "unknown supertype: " + nt;
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg, nsnte);
            }
        }
    }

    static void checkForCircularNodeAutoCreation(EffectiveNodeType childNodeENT, Stack definingParentNTs, EffectiveNodeTypeCache anEntCache, Map ntDefCache) throws InvalidNodeTypeDefException {
        Name[] childNodeNTs = childNodeENT.getAllNodeTypes();
        for (int i = 0; i < childNodeNTs.length; ++i) {
            Name nt = childNodeNTs[i];
            int pos = definingParentNTs.lastIndexOf(nt);
            if (pos < 0) continue;
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < definingParentNTs.size(); ++j) {
                if (j == pos) {
                    buf.append("--> ");
                }
                buf.append("node type ");
                buf.append(definingParentNTs.get(j));
                buf.append(" defines auto-created child node with default ");
            }
            buf.append("--> ");
            buf.append("node type ");
            buf.append(nt);
            throw new InvalidNodeTypeDefException("circular node auto-creation detected: " + buf.toString());
        }
        NodeDef[] nodeDefs = childNodeENT.getAutoCreateNodeDefs();
        for (int i = 0; i < nodeDefs.length; ++i) {
            Name dnt = nodeDefs[i].getDefaultPrimaryType();
            Name definingNT = nodeDefs[i].getDeclaringNodeType();
            try {
                if (dnt == null) continue;
                definingParentNTs.push(definingNT);
                NodeTypeRegistry.checkForCircularNodeAutoCreation(NodeTypeRegistry.getEffectiveNodeType(dnt, anEntCache, ntDefCache), definingParentNTs, anEntCache, ntDefCache);
                definingParentNTs.pop();
                continue;
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg = definingNT + " defines invalid default node type for child node " + nodeDefs[i].getName();
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg, nsnte);
            }
        }
    }

    private EffectiveNodeType internalRegister(NodeTypeDef ntd) throws InvalidNodeTypeDefException, RepositoryException {
        Name name = ntd.getName();
        if (name != null && this.registeredNTDefs.containsKey((Object)name)) {
            String msg = name + " already exists";
            log.debug(msg);
            throw new InvalidNodeTypeDefException(msg);
        }
        EffectiveNodeType ent = NodeTypeRegistry.validateNodeTypeDef(ntd, this.entCache, (Map)this.registeredNTDefs, this.nsReg, false);
        this.entCache.put(ent);
        ntd = (NodeTypeDef)ntd.clone();
        this.registeredNTDefs.put((Object)name, (Object)ntd);
        PropDef[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            this.propDefs.put((Object)pda[i].getId(), (Object)pda[i]);
        }
        NodeDef[] nda = ntd.getChildNodeDefs();
        for (int i = 0; i < nda.length; ++i) {
            this.nodeDefs.put((Object)nda[i].getId(), (Object)nda[i]);
        }
        return ent;
    }

    private void internalRegister(Collection ntDefs) throws InvalidNodeTypeDefException, RepositoryException {
        this.internalRegister(ntDefs, false);
    }

    private void internalRegister(Collection ntDefs, boolean lenient) throws InvalidNodeTypeDefException, RepositoryException {
        EffectiveNodeTypeCache tmpENTCache = (EffectiveNodeTypeCache)this.entCache.clone();
        HashMap<Name, NodeTypeDef> tmpNTDefCache = new HashMap<Name, NodeTypeDef>((Map<Name, NodeTypeDef>)this.registeredNTDefs);
        for (NodeTypeDef ntd : ntDefs) {
            Name name = ntd.getName();
            if (name != null && this.registeredNTDefs.containsKey((Object)name)) {
                String msg = name + " already exists";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            tmpNTDefCache.put(ntd.getName(), ntd);
        }
        for (NodeTypeDef ntd : ntDefs) {
            EffectiveNodeType ent = NodeTypeRegistry.validateNodeTypeDef(ntd, tmpENTCache, tmpNTDefCache, this.nsReg, lenient);
            tmpENTCache.put(ent);
        }
        for (NodeTypeDef ntd : ntDefs) {
            ntd = (NodeTypeDef)ntd.clone();
            this.registeredNTDefs.put((Object)ntd.getName(), (Object)ntd);
            PropDef[] pda = ntd.getPropertyDefs();
            for (int i = 0; i < pda.length; ++i) {
                this.propDefs.put((Object)pda[i].getId(), (Object)pda[i]);
            }
            NodeDef[] nda = ntd.getChildNodeDefs();
            for (int i = 0; i < nda.length; ++i) {
                this.nodeDefs.put((Object)nda[i].getId(), (Object)nda[i]);
            }
        }
        this.entCache = tmpENTCache;
    }

    private void internalUnregister(Name name) throws NoSuchNodeTypeException {
        NodeTypeDef ntd = (NodeTypeDef)this.registeredNTDefs.get((Object)name);
        if (ntd == null) {
            throw new NoSuchNodeTypeException(name.toString());
        }
        this.registeredNTDefs.remove((Object)name);
        this.entCache.invalidate(name);
        PropDef[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            this.propDefs.remove((Object)pda[i].getId());
        }
        NodeDef[] nda = ntd.getChildNodeDefs();
        for (int i = 0; i < nda.length; ++i) {
            this.nodeDefs.remove((Object)nda[i].getId());
        }
    }

    private void internalUnregister(Collection ntNames) throws NoSuchNodeTypeException {
        for (Name name : ntNames) {
            this.internalUnregister(name);
        }
    }

    private static void checkNamespace(Name name, NamespaceRegistry nsReg) throws RepositoryException {
        if (name != null) {
            nsReg.getPrefix(name.getNamespaceURI());
        }
    }

    private static EffectiveNodeType validateNodeTypeDef(NodeTypeDef ntd, EffectiveNodeTypeCache entCache, Map ntdCache, NamespaceRegistry nsReg, boolean lenient) throws InvalidNodeTypeDefException, RepositoryException {
        String msg;
        String msg2;
        EffectiveNodeType ent = null;
        Name name = ntd.getName();
        if (name == null) {
            String msg3 = "no name specified";
            log.debug(msg3);
            throw new InvalidNodeTypeDefException(msg3);
        }
        NodeTypeRegistry.checkNamespace(name, nsReg);
        Name[] supertypes = ntd.getSupertypes();
        if (supertypes.length > 0) {
            for (int i = 0; i < supertypes.length; ++i) {
                NodeTypeRegistry.checkNamespace(supertypes[i], nsReg);
                if (name.equals(supertypes[i])) {
                    String msg4 = "[" + name + "] invalid supertype: " + supertypes[i] + " (infinite recursion))";
                    log.debug(msg4);
                    throw new InvalidNodeTypeDefException(msg4);
                }
                if (ntdCache.containsKey(supertypes[i])) continue;
                String msg5 = "[" + name + "] invalid supertype: " + supertypes[i];
                log.debug(msg5);
                throw new InvalidNodeTypeDefException(msg5);
            }
            Stack<Name> inheritanceChain = new Stack<Name>();
            inheritanceChain.push(name);
            NodeTypeRegistry.checkForCircularInheritance(supertypes, inheritanceChain, ntdCache);
        }
        if (supertypes.length > 0) {
            try {
                EffectiveNodeType est = NodeTypeRegistry.getEffectiveNodeType(supertypes, entCache, ntdCache);
                if (!(ntd.isMixin() || NameConstants.NT_BASE.equals(ntd.getName()) || est.includesNodeType(NameConstants.NT_BASE))) {
                    String msg6 = "[" + name + "] all primary node types except nt:base itself must be (directly or indirectly) derived from nt:base";
                    log.debug(msg6);
                    throw new InvalidNodeTypeDefException(msg6);
                }
            }
            catch (NodeTypeConflictException ntce) {
                String msg7 = "[" + name + "] failed to validate supertypes";
                log.debug(msg7);
                throw new InvalidNodeTypeDefException(msg7, ntce);
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg8 = "[" + name + "] failed to validate supertypes";
                log.debug(msg8);
                throw new InvalidNodeTypeDefException(msg8, nsnte);
            }
        }
        NodeTypeRegistry.checkNamespace(ntd.getPrimaryItemName(), nsReg);
        PropDef[] pda = ntd.getPropertyDefs();
        for (int i = 0; i < pda.length; ++i) {
            ValueConstraint[] constraints;
            int j;
            PropDef pd = pda[i];
            if (!name.equals(pd.getDeclaringNodeType())) {
                msg2 = "[" + name + "#" + pd.getName() + "] invalid declaring node type specified";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2);
            }
            NodeTypeRegistry.checkNamespace(pd.getName(), nsReg);
            if (pd.definesResidual() && pd.isAutoCreated()) {
                msg2 = "[" + name + "#" + pd.getName() + "] auto-created properties must specify a name";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2);
            }
            if (pd.getRequiredType() == 0 && pd.isAutoCreated()) {
                msg2 = "[" + name + "#" + pd.getName() + "] auto-created properties must specify a type";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2);
            }
            InternalValue[] defVals = pd.getDefaultValues();
            if (defVals != null && defVals.length != 0) {
                int reqType = pd.getRequiredType();
                for (j = 0; j < defVals.length; ++j) {
                    if (reqType == 0) {
                        reqType = defVals[j].getType();
                        continue;
                    }
                    if (defVals[j].getType() == reqType) continue;
                    String msg9 = "[" + name + "#" + pd.getName() + "] type of default value(s) is not consistent with required property type";
                    log.debug(msg9);
                    throw new InvalidNodeTypeDefException(msg9);
                }
            } else if (!lenient && pd.isAutoCreated()) {
                msg = "[" + name + "#" + pd.getName() + "] auto-created property must have a default value";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            if ((constraints = pd.getValueConstraints()) == null || constraints.length <= 0) continue;
            if (defVals != null && defVals.length > 0) {
                for (j = 0; j < defVals.length; ++j) {
                    boolean satisfied = false;
                    ConstraintViolationException cve = null;
                    for (int k = 0; k < constraints.length; ++k) {
                        try {
                            constraints[k].check(defVals[j]);
                            satisfied = true;
                            break;
                        }
                        catch (ConstraintViolationException e) {
                            cve = e;
                            continue;
                        }
                    }
                    if (satisfied) continue;
                    String msg10 = "[" + name + "#" + pd.getName() + "] default value does not satisfy value constraint";
                    log.debug(msg10);
                    throw new InvalidNodeTypeDefException(msg10, cve);
                }
            }
            if (pd.getRequiredType() != 9) continue;
            for (j = 0; j < constraints.length; ++j) {
                ReferenceConstraint rc = (ReferenceConstraint)constraints[j];
                Name ntName = rc.getNodeTypeName();
                if (name.equals(ntName) || ntdCache.containsKey(ntName)) continue;
                String msg11 = "[" + name + "#" + pd.getName() + "] invalid REFERENCE value constraint '" + ntName + "' (unknown node type)";
                log.debug(msg11);
                throw new InvalidNodeTypeDefException(msg11);
            }
        }
        NodeDef[] cnda = ntd.getChildNodeDefs();
        for (int i = 0; i < cnda.length; ++i) {
            Name[] reqTypes;
            NodeDef cnd = cnda[i];
            if (!name.equals(cnd.getDeclaringNodeType())) {
                msg = "[" + name + "#" + cnd.getName() + "] invalid declaring node type specified";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            NodeTypeRegistry.checkNamespace(cnd.getName(), nsReg);
            if (cnd.definesResidual() && cnd.isAutoCreated()) {
                msg = "[" + name + "#" + cnd.getName() + "] auto-created child-nodes must specify a name";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            if (cnd.getDefaultPrimaryType() == null && cnd.isAutoCreated()) {
                msg = "[" + name + "#" + cnd.getName() + "] auto-created child-nodes must specify a default primary type";
                log.debug(msg);
                throw new InvalidNodeTypeDefException(msg);
            }
            Name dpt = cnd.getDefaultPrimaryType();
            NodeTypeRegistry.checkNamespace(dpt, nsReg);
            boolean referenceToSelf = false;
            EffectiveNodeType defaultENT = null;
            if (dpt != null) {
                if (name.equals(dpt)) {
                    referenceToSelf = true;
                }
                if (!name.equals(dpt) && !ntdCache.containsKey(dpt)) {
                    String msg12 = "[" + name + "#" + cnd.getName() + "] invalid default primary type '" + dpt + "'";
                    log.debug(msg12);
                    throw new InvalidNodeTypeDefException(msg12);
                }
                try {
                    defaultENT = !referenceToSelf ? NodeTypeRegistry.getEffectiveNodeType(dpt, entCache, ntdCache) : (ent = EffectiveNodeType.create(ntd, entCache, ntdCache));
                    if (cnd.isAutoCreated()) {
                        Stack<Name> definingNTs = new Stack<Name>();
                        definingNTs.push(name);
                        NodeTypeRegistry.checkForCircularNodeAutoCreation(defaultENT, definingNTs, entCache, ntdCache);
                    }
                }
                catch (NodeTypeConflictException ntce) {
                    String msg13 = "[" + name + "#" + cnd.getName() + "] failed to validate default primary type";
                    log.debug(msg13);
                    throw new InvalidNodeTypeDefException(msg13, ntce);
                }
                catch (NoSuchNodeTypeException nsnte) {
                    String msg14 = "[" + name + "#" + cnd.getName() + "] failed to validate default primary type";
                    log.debug(msg14);
                    throw new InvalidNodeTypeDefException(msg14, nsnte);
                }
            }
            if ((reqTypes = cnd.getRequiredPrimaryTypes()) == null || reqTypes.length <= 0) continue;
            for (int n = 0; n < reqTypes.length; ++n) {
                Name rpt = reqTypes[n];
                NodeTypeRegistry.checkNamespace(rpt, nsReg);
                referenceToSelf = false;
                if (name.equals(rpt)) {
                    referenceToSelf = true;
                }
                if (!name.equals(rpt) && !ntdCache.containsKey(rpt)) {
                    String msg15 = "[" + name + "#" + cnd.getName() + "] invalid required primary type: " + rpt;
                    log.debug(msg15);
                    throw new InvalidNodeTypeDefException(msg15);
                }
                if (defaultENT != null && !defaultENT.includesNodeType(rpt)) {
                    String msg16 = "[" + name + "#" + cnd.getName() + "] default primary type does not satisfy required primary type constraint " + rpt;
                    log.debug(msg16);
                    throw new InvalidNodeTypeDefException(msg16);
                }
                try {
                    if (!referenceToSelf) {
                        NodeTypeRegistry.getEffectiveNodeType(rpt, entCache, ntdCache);
                        continue;
                    }
                    if (ent != null) continue;
                    ent = EffectiveNodeType.create(ntd, entCache, ntdCache);
                    continue;
                }
                catch (NodeTypeConflictException ntce) {
                    String msg17 = "[" + name + "#" + cnd.getName() + "] failed to validate required primary type constraint";
                    log.debug(msg17);
                    throw new InvalidNodeTypeDefException(msg17, ntce);
                }
                catch (NoSuchNodeTypeException nsnte) {
                    String msg18 = "[" + name + "#" + cnd.getName() + "] failed to validate required primary type constraint";
                    log.debug(msg18);
                    throw new InvalidNodeTypeDefException(msg18, nsnte);
                }
            }
        }
        if (ent == null) {
            try {
                ent = EffectiveNodeType.create(ntd, entCache, ntdCache);
            }
            catch (NodeTypeConflictException ntce) {
                msg2 = "[" + name + "] failed to resolve node type definition";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2, ntce);
            }
            catch (NoSuchNodeTypeException nsnte) {
                msg2 = "[" + name + "] failed to resolve node type definition";
                log.debug(msg2);
                throw new InvalidNodeTypeDefException(msg2, nsnte);
            }
        }
        return ent;
    }

    private static NodeDef createRootNodeDef() {
        NodeDefImpl def = new NodeDefImpl();
        def.setDeclaringNodeType(NameConstants.REP_ROOT);
        def.setRequiredPrimaryTypes(new Name[]{NameConstants.REP_ROOT});
        def.setDefaultPrimaryType(NameConstants.REP_ROOT);
        def.setMandatory(true);
        def.setProtected(false);
        def.setOnParentVersion(2);
        def.setAllowsSameNameSiblings(false);
        def.setAutoCreated(true);
        return def;
    }

    private void notifyRegistered(Name ntName) {
        NodeTypeRegistryListener[] la = this.listeners.values().toArray(new NodeTypeRegistryListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeRegistered(ntName);
        }
    }

    private void notifyReRegistered(Name ntName) {
        NodeTypeRegistryListener[] la = this.listeners.values().toArray(new NodeTypeRegistryListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeReRegistered(ntName);
        }
    }

    private void notifyUnregistered(Name ntName) {
        NodeTypeRegistryListener[] la = this.listeners.values().toArray(new NodeTypeRegistryListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeUnregistered(ntName);
        }
    }
}

