/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import com.kingdee.bos.ctrl.lucene.document.Document;
import com.kingdee.bos.ctrl.lucene.index.FilterIndexReader;
import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import java.io.IOException;
import java.util.BitSet;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.SingleTermDocs;
import org.slf4j.Logger;

class CachingIndexReader
extends FilterIndexReader {
    private static final Logger log = CommonSLF4JLogger.getLogger(CachingIndexReader.class);
    private static long currentTick;
    private final DocId[] parents;
    private final long creationTick = CachingIndexReader.getNextCreationTick();
    private final DocNumberCache cache;
    static final TermDocs EMPTY;

    CachingIndexReader(IndexReader delegatee, DocNumberCache cache) {
        super(delegatee);
        this.cache = cache;
        this.parents = new DocId[delegatee.maxDoc()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocId getParent(int n, BitSet deleted) throws IOException {
        boolean existing = false;
        DocId parent = this.parents[n];
        if (parent != null) {
            existing = true;
            if (!parent.isValid(deleted)) {
                if (log.isDebugEnabled()) {
                    log.debug(parent + " not valid anymore.");
                }
                parent = null;
            }
        }
        if (parent == null) {
            Document doc = this.document(n);
            String parentUUID = doc.get(FieldNames.PARENT);
            if (parentUUID == null || parentUUID.length() == 0) {
                parent = DocId.NULL;
            } else {
                if (!existing) {
                    Term id = new Term(FieldNames.UUID, parentUUID);
                    try (TermDocs docs = this.termDocs(id);){
                        while (docs.next()) {
                            if (deleted.get(docs.doc())) continue;
                            parent = DocId.create(docs.doc());
                            break;
                        }
                    }
                }
                if (parent == null) {
                    parent = DocId.create(parentUUID);
                }
            }
            this.parents[n] = parent;
        }
        return parent;
    }

    public long getCreationTick() {
        return this.creationTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TermDocs termDocs(Term term) throws IOException {
        if (term.field() == FieldNames.UUID && this.cache != null) {
            DocNumberCache.Entry e = this.cache.get(term.text());
            if (e != null && e.creationTick == this.creationTick && !this.isDeleted(e.doc)) {
                return new SingleTermDocs(e.doc);
            }
            try (TermDocs docs = this.in.termDocs(term);){
                if (docs.next()) {
                    this.cache.put(term.text(), this, docs.doc());
                    SingleTermDocs singleTermDocs = new SingleTermDocs(docs.doc());
                    return singleTermDocs;
                }
                TermDocs termDocs = EMPTY;
                return termDocs;
            }
        }
        return super.termDocs(term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextCreationTick() {
        Class<CachingIndexReader> clazz = CachingIndexReader.class;
        synchronized (CachingIndexReader.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentTick++;
        }
    }

    static {
        EMPTY = new TermDocs(){

            @Override
            public void seek(Term term) {
            }

            @Override
            public void seek(TermEnum termEnum) {
            }

            @Override
            public int doc() {
                return -1;
            }

            @Override
            public int freq() {
                return -1;
            }

            @Override
            public boolean next() {
                return false;
            }

            @Override
            public int read(int[] docs, int[] freqs) {
                return 0;
            }

            @Override
            public boolean skipTo(int target) {
                return false;
            }

            @Override
            public void close() {
            }
        };
    }
}

