/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.RandomAccessOutputStream;
import org.slf4j.Logger;

class IndexingQueueStore {
    private static final Logger log = CommonSLF4JLogger.getLogger(IndexingQueueStore.class);
    private static final String ENCODING = "UTF-8";
    private static final String ADD = "ADD";
    private static final String REMOVE = "REMOVE";
    private final Set pending = new HashSet();
    private final FileSystem fs;
    private final String fileName;
    private Writer out;

    IndexingQueueStore(FileSystem fs, String fileName) throws FileSystemException {
        this.fs = fs;
        this.fileName = fileName;
        this.readStore();
    }

    public String[] getPending() {
        return this.pending.toArray(new String[this.pending.size()]);
    }

    public void addUUID(String uuid) throws IOException {
        IndexingQueueStore.writeEntry(ADD, uuid, this.getLog());
        this.pending.add(uuid);
    }

    public void removeUUID(String uuid) throws IOException {
        IndexingQueueStore.writeEntry(REMOVE, uuid, this.getLog());
        this.pending.remove(uuid);
    }

    public void commit() throws IOException {
        if (this.out != null) {
            this.out.flush();
            if (this.pending.size() == 0) {
                this.out.close();
                this.out = null;
                try {
                    this.fs.getOutputStream(this.fileName).close();
                }
                catch (FileSystemException fileSystemException) {
                    // empty catch block
                }
            }
        }
    }

    public void close() throws IOException {
        this.commit();
        if (this.out != null) {
            this.out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStore() throws FileSystemException {
        if (this.fs.exists(this.fileName)) {
            try {
                InputStream in = this.fs.getInputStream(this.fileName);
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, ENCODING));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        int idx = line.indexOf(32);
                        if (idx == -1) {
                            log.warn("invalid line in {}: {}", (Object)this.fileName, (Object)line);
                            continue;
                        }
                        String cmd = line.substring(0, idx);
                        String uuid = line.substring(idx + 1, line.length());
                        if (ADD.equals(cmd)) {
                            this.pending.add(uuid);
                            continue;
                        }
                        if (REMOVE.equals(cmd)) {
                            this.pending.remove(uuid);
                            continue;
                        }
                        log.warn("invalid line in {}: {}", (Object)this.fileName, (Object)line);
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage(), e);
            }
        }
    }

    private static void writeEntry(String op, String uuid, Writer writer) throws IOException {
        StringBuffer buf = new StringBuffer(op);
        buf.append(' ').append(uuid).append('\n');
        writer.write(buf.toString());
    }

    private Writer getLog() throws IOException {
        if (this.out == null) {
            try {
                long len = 0L;
                if (this.fs.exists(this.fileName)) {
                    len = this.fs.length(this.fileName);
                }
                RandomAccessOutputStream raos = this.fs.getRandomAccessOutputStream(this.fileName);
                raos.seek(len);
                this.out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(raos, 1024), ENCODING);
            }
            catch (FileSystemException e) {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
                IOException ex = new IOException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }
        return this.out;
    }
}

