/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import com.kingdee.bos.ctrl.lucene.search.Explanation;
import com.kingdee.bos.ctrl.lucene.search.HitCollector;
import com.kingdee.bos.ctrl.lucene.search.Scorer;
import com.kingdee.bos.ctrl.lucene.search.Similarity;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;

class MatchAllScorer
extends Scorer {
    private int nextDoc = -1;
    private IndexReader reader;
    private String field;
    private BitSet docFilter;
    private final Explanation matchExpl;

    MatchAllScorer(IndexReader reader, String field) throws IOException {
        super(Similarity.getDefault());
        this.reader = reader;
        this.field = field;
        this.matchExpl = new Explanation(Similarity.getDefault().idf(reader.maxDoc(), reader.maxDoc()), "matchAll");
        this.calculateDocFilter();
    }

    @Override
    public void score(HitCollector hc) throws IOException {
        while (this.next()) {
            hc.collect(this.doc(), this.score());
        }
    }

    @Override
    public boolean next() throws IOException {
        this.nextDoc = this.docFilter.nextSetBit(this.nextDoc + 1);
        return this.nextDoc > -1;
    }

    @Override
    public int doc() {
        return this.nextDoc;
    }

    @Override
    public float score() throws IOException {
        return 1.0f;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        this.nextDoc = target - 1;
        return this.next();
    }

    @Override
    public Explanation explain(int doc) {
        return this.matchExpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateDocFilter() throws IOException {
        PerQueryCache cache = PerQueryCache.getInstance();
        HashMap<String, BitSet> readerCache = (HashMap<String, BitSet>)cache.get(MatchAllScorer.class, this.reader);
        if (readerCache == null) {
            readerCache = new HashMap<String, BitSet>();
            cache.put(MatchAllScorer.class, this.reader, readerCache);
        }
        this.docFilter = (BitSet)readerCache.get(this.field);
        if (this.docFilter != null) {
            return;
        }
        this.docFilter = new BitSet(this.reader.maxDoc());
        String namedValue = FieldNames.createNamedValue(this.field, "");
        try (TermEnum terms = this.reader.terms(new Term(FieldNames.PROPERTIES, namedValue));
             TermDocs docs = this.reader.termDocs();){
            while (terms.term() != null && terms.term().field() == FieldNames.PROPERTIES && terms.term().text().startsWith(namedValue)) {
                docs.seek(terms);
                while (docs.next()) {
                    this.docFilter.set(docs.doc());
                }
                terms.next();
            }
        }
        readerCache.put(this.field, this.docFilter);
    }
}

