/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import javax.jcr.NamespaceException;
import org.apache.jackrabbit.core.NamespaceRegistryImpl;
import org.apache.jackrabbit.core.query.lucene.NamePathResolverImpl;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.namespace.AbstractNamespaceResolver;

public class NSRegistryBasedNamespaceMappings
extends AbstractNamespaceResolver
implements NamespaceMappings {
    private final NamespaceRegistryImpl nsReg;
    private final NameResolver nameResolver;

    NSRegistryBasedNamespaceMappings(NamespaceRegistryImpl nsReg) {
        this.nsReg = nsReg;
        this.nameResolver = NamePathResolverImpl.create(this);
    }

    @Override
    public String getURI(String prefix) throws NamespaceException {
        try {
            int index = Integer.parseInt(prefix);
            return this.nsReg.getURI(index);
        }
        catch (NumberFormatException e) {
            throw new NamespaceException("Unknown prefix: " + prefix);
        }
    }

    @Override
    public String getPrefix(String uri) throws NamespaceException {
        return String.valueOf(this.nsReg.getURIIndex(uri));
    }

    @Override
    public String translatePropertyName(Name qName) throws IllegalNameException {
        try {
            return this.nameResolver.getJCRName(qName);
        }
        catch (NamespaceException e) {
            throw new IllegalNameException("Internal error.", e);
        }
    }
}

