/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.kingdee.bos.ctrl.lucene.index.FilterIndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.index.TermPositions;
import java.io.IOException;
import java.util.BitSet;
import org.apache.jackrabbit.core.query.lucene.CachingIndexReader;
import org.apache.jackrabbit.core.query.lucene.CommittableIndexReader;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.SharedIndexReader;

class ReadOnlyIndexReader
extends FilterIndexReader {
    private final SharedIndexReader reader;
    private final BitSet deleted;
    private long deletedDocsVersion;
    private int refCount = 1;

    public ReadOnlyIndexReader(SharedIndexReader reader, BitSet deleted, long deletedDocsVersion) {
        super(reader);
        this.reader = reader;
        this.deleted = deleted;
        this.deletedDocsVersion = deletedDocsVersion;
        reader.addClient(this);
    }

    synchronized void incrementRefCount() {
        ++this.refCount;
    }

    synchronized int getRefCount() {
        return this.refCount;
    }

    long getDeletedDocsVersion() {
        return this.deletedDocsVersion;
    }

    long getCreationTick() {
        return this.reader.getCreationTick();
    }

    void updateDeletedDocs(CommittableIndexReader reader) {
        int maxDoc = reader.maxDoc();
        for (int i = 0; i < maxDoc; ++i) {
            if (!reader.isDeleted(i)) continue;
            this.deleted.set(i);
        }
        this.deletedDocsVersion = reader.getModificationCount();
    }

    public DocId getParent(int n) throws IOException {
        return this.getBase().getParent(n, this.deleted);
    }

    public SharedIndexReader getBase() {
        return (SharedIndexReader)this.in;
    }

    @Override
    public boolean isDeleted(int n) {
        return this.deleted.get(n);
    }

    @Override
    public boolean hasDeletions() {
        return !this.deleted.isEmpty();
    }

    @Override
    public int numDocs() {
        return this.maxDoc() - this.deleted.cardinality();
    }

    @Override
    protected final void doDelete(int docNum) {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    @Override
    protected final void doUndeleteAll() {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    @Override
    protected final void doCommit() {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws IOException {
        ReadOnlyIndexReader readOnlyIndexReader = this;
        synchronized (readOnlyIndexReader) {
            if (--this.refCount == 0) {
                this.reader.removeClient(this);
            }
        }
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        TermDocs td = this.reader.termDocs(term);
        if (td != CachingIndexReader.EMPTY) {
            td = new FilteredTermDocs(td);
        }
        return td;
    }

    @Override
    public TermDocs termDocs() throws IOException {
        return new FilteredTermDocs(super.termDocs());
    }

    @Override
    public TermPositions termPositions() throws IOException {
        return new FilteredTermPositions(super.termPositions());
    }

    private final class FilteredTermPositions
    extends FilteredTermDocs
    implements TermPositions {
        public FilteredTermPositions(TermPositions in) {
            super(in);
        }

        @Override
        public int nextPosition() throws IOException {
            return ((TermPositions)this.in).nextPosition();
        }

        @Override
        public int getPayloadLength() {
            return ((TermPositions)this.in).getPayloadLength();
        }

        @Override
        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return ((TermPositions)this.in).getPayload(data, offset);
        }

        @Override
        public boolean isPayloadAvailable() {
            return ((TermPositions)this.in).isPayloadAvailable();
        }
    }

    private class FilteredTermDocs
    extends FilterIndexReader.FilterTermDocs {
        public FilteredTermDocs(TermDocs in) {
            super(in);
        }

        @Override
        public boolean next() throws IOException {
            boolean hasNext = super.next();
            while (hasNext && ReadOnlyIndexReader.this.deleted.get(super.doc())) {
                hasNext = super.next();
            }
            return hasNext;
        }

        @Override
        public int read(int[] docs, int[] freqs) throws IOException {
            int count;
            for (count = 0; count < docs.length && this.next(); ++count) {
                docs[count] = this.doc();
                freqs[count] = this.freq();
            }
            return count;
        }

        @Override
        public boolean skipTo(int i) throws IOException {
            boolean exists = super.skipTo(i);
            while (exists && ReadOnlyIndexReader.this.deleted.get(this.doc())) {
                exists = this.next();
            }
            return exists;
        }
    }
}

