/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.state.Cache;
import org.apache.jackrabbit.core.state.CacheAccessListener;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCache;
import org.slf4j.Logger;

public class MLRUItemStateCache
implements ItemStateCache,
Cache {
    private static Logger log = CommonSLF4JLogger.getLogger(MLRUItemStateCache.class);
    public static final int DEFAULT_MAX_MEM = 0x400000;
    private long totalMem;
    private long maxMem;
    private long numWrites = 0L;
    private long accessCount = 0L;
    private CacheAccessListener accessListener;
    private final LinkedMap cache = new LinkedMap();

    public MLRUItemStateCache() {
        this(0x400000);
    }

    private MLRUItemStateCache(int maxMem) {
        this.maxMem = maxMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCached(ItemId id) {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            return this.cache.containsKey((Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemState retrieve(ItemId id) {
        this.touch();
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            Entry entry = (Entry)this.cache.remove((Object)id);
            if (entry != null) {
                this.cache.put((Object)id, (Object)entry);
                return entry.state;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemState[] retrieveAll() {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            return this.cache.values().toArray(new ItemState[this.cache.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ItemId id) {
        this.touch();
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            Entry entry = (Entry)this.cache.get((Object)id);
            if (entry != null) {
                this.totalMem -= entry.size;
                entry.recalc();
                this.totalMem += entry.size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cache(ItemState state) {
        this.touch();
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            ItemId id = state.getId();
            if (this.cache.containsKey((Object)id)) {
                log.warn("overwriting cached entry " + id);
                this.evict(id);
            }
            Entry entry = new Entry(state);
            this.cache.put((Object)id, (Object)entry);
            this.totalMem += entry.size;
            this.shrinkIfRequired();
            if (this.numWrites++ % 10000L == 0L && log.isDebugEnabled()) {
                log.debug(this + " size=" + this.cache.size() + ", " + this.totalMem + "/" + this.maxMem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shrinkIfRequired() {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            while (this.totalMem > this.maxMem) {
                ItemId id = (ItemId)this.cache.firstKey();
                Entry entry = (Entry)this.cache.remove((Object)id);
                this.totalMem -= entry.size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict(ItemId id) {
        this.touch();
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            Entry entry = (Entry)this.cache.remove((Object)id);
            if (entry != null) {
                this.totalMem -= entry.size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictAll() {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            this.cache.clear();
            this.totalMem = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            return this.cache.isEmpty();
        }
    }

    private void touch() {
        ++this.accessCount;
        if (this.accessCount % 127L == 0L && this.accessListener != null) {
            this.accessListener.cacheAccessed();
        }
    }

    @Override
    public long getAccessCount() {
        return this.accessCount;
    }

    @Override
    public long getMaxMemorySize() {
        return this.maxMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMemoryUsed() {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            this.totalMem = 0L;
            for (Entry entry : this.cache.values()) {
                entry.recalc();
                this.totalMem += entry.size;
            }
        }
        return this.totalMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetAccessCount() {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            this.accessCount = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxMemorySize(long size) {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            this.maxMem = size;
            this.shrinkIfRequired();
        }
    }

    @Override
    public void setAccessListener(CacheAccessListener listener) {
        this.accessListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        LinkedMap linkedMap = this.cache;
        synchronized (linkedMap) {
            if (this.accessListener != null) {
                this.accessListener.disposeCache(this);
            }
        }
    }

    private static class Entry {
        private final ItemState state;
        private long size;

        public Entry(ItemState state) {
            this.state = state;
            this.size = 64L + state.calculateMemoryFootprint();
        }

        public void recalc() {
            this.size = 64L + this.state.calculateMemoryFootprint();
        }
    }
}

