/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.util.Calendar;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.core.ItemLifeCycleListener;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.version.InternalFrozenNode;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.slf4j.Logger;

public class VersionImpl
extends NodeImpl
implements Version {
    private static Logger log = CommonSLF4JLogger.getLogger(VersionImpl.class);

    public VersionImpl(ItemManager itemMgr, SessionImpl session, NodeId id, NodeState state, NodeDefinition definition, ItemLifeCycleListener[] listeners) {
        super(itemMgr, session, id, state, definition, listeners);
    }

    protected InternalVersion getInternalVersion() throws RepositoryException {
        InternalVersion version = this.session.getVersionManager().getVersion((NodeId)this.id);
        if (version == null) {
            throw new InvalidItemStateException(this.id + ": the item does not exist anymore");
        }
        return version;
    }

    public Calendar getCreated() throws RepositoryException {
        return this.getInternalVersion().getCreated();
    }

    public Version[] getSuccessors() throws RepositoryException {
        InternalVersion[] suc = this.getInternalVersion().getSuccessors();
        Version[] ret = new Version[suc.length];
        for (int i = 0; i < suc.length; ++i) {
            ret[i] = (Version)this.session.getNodeById(suc[i].getId());
        }
        return ret;
    }

    public Version[] getPredecessors() throws RepositoryException {
        InternalVersion[] pred = this.getInternalVersion().getPredecessors();
        Version[] ret = new Version[pred.length];
        for (int i = 0; i < pred.length; ++i) {
            ret[i] = (Version)this.session.getNodeById(pred[i].getId());
        }
        return ret;
    }

    public VersionHistory getContainingHistory() throws RepositoryException {
        return (VersionHistory)this.getParent();
    }

    public InternalFrozenNode getFrozenNode() throws RepositoryException {
        return this.getInternalVersion().getFrozenNode();
    }

    @Override
    public boolean isSame(Item otherItem) {
        if (otherItem instanceof VersionImpl) {
            try {
                InternalVersion other = ((VersionImpl)otherItem).getInternalVersion();
                return other.getId().equals(this.getInternalVersion().getId());
            }
            catch (RepositoryException e) {
                log.warn("Unable to retrieve internal version objects: " + e.getMessage());
                log.debug("Stack dump:", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isMoreRecent(VersionImpl v) throws RepositoryException {
        return this.getInternalVersion().isMoreRecent(v.getInternalVersion());
    }

    public boolean isRootVersion() throws RepositoryException {
        return this.getInternalVersion().isRootVersion();
    }

    @Override
    public void update(String srcWorkspaceName) throws ConstraintViolationException {
        String msg = "update operation not allowed on a version node: " + this.safeGetJCRPath();
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }

    @Override
    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws ConstraintViolationException {
        String msg = "merge operation not allowed on a version node: " + this.safeGetJCRPath();
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }
}

