/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.util.Iterator;
import javax.jcr.ReferentialIntegrityException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.slf4j.Logger;

public class VersionItemStateManager
extends SharedItemStateManager {
    private static final Logger log = CommonSLF4JLogger.getLogger(VersionItemStateManager.class);
    private final PersistenceManager pMgr;

    public VersionItemStateManager(PersistenceManager persistMgr, NodeId rootNodeId, NodeTypeRegistry ntReg, ItemStateCacheFactory cacheFactory, ISMLocking locking) throws ItemStateException {
        super(persistMgr, rootNodeId, ntReg, false, cacheFactory, locking);
        this.pMgr = persistMgr;
    }

    public boolean setNodeReferences(NodeReferences references) {
        try {
            NodeReferences refs = new NodeReferences(references.getId());
            for (PropertyId id : references.getReferences()) {
                if (this.hasItemState(id.getParentId())) continue;
                refs.addReference(id);
            }
            ChangeLog log = new ChangeLog();
            log.modified(refs);
            this.pMgr.store(log);
            return true;
        }
        catch (ItemStateException e) {
            log.error("Error while setting references: " + e.toString());
            return false;
        }
    }

    @Override
    protected void checkReferentialIntegrity(ChangeLog changes) throws ReferentialIntegrityException, ItemStateException {
        Iterator iter = changes.modifiedRefs();
        while (iter.hasNext()) {
            NodeReferences refs = (NodeReferences)iter.next();
            NodeId id = refs.getTargetId();
            if (!refs.hasReferences() || changes.has(id) || this.hasItemState(id)) continue;
            iter.remove();
        }
    }
}

