/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.IOException;
import java.io.Writer;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.xml.AbstractSAXEventGenerator;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingNameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.value.ValueHelper;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SysViewSAXEventGenerator
extends AbstractSAXEventGenerator {
    public static final String CDATA_TYPE = "CDATA";
    public static final String ENUMERATION_TYPE = "ENUMERATION";
    private static final String NS_XMLSCHEMA_INSTANCE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String NS_XMLSCHEMA_INSTANCE_PREFIX = "xsi";
    private static final String NS_XMLSCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    private static final String NS_XMLSCHEMA_PREFIX = "xs";
    private static final Attributes ATTRS_EMPTY = new AttributesImpl();
    private static final Attributes ATTRS_BINARY_ENCODED_VALUE;
    private final NameResolver resolver;

    public SysViewSAXEventGenerator(Node node, boolean noRecurse, boolean skipBinary, ContentHandler contentHandler) throws RepositoryException {
        super(node, noRecurse, skipBinary, contentHandler);
        this.resolver = new ParsingNameResolver(NameFactoryImpl.getInstance(), this.nsResolver);
    }

    @Override
    protected void entering(Node node, int level) throws RepositoryException, SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addNamespacePrefixes(level, attrs);
        String nodeName = node.getDepth() == 0 ? this.jcrRoot : node.getName();
        this.addAttribute(attrs, NameConstants.SV_NAME, CDATA_TYPE, nodeName);
        this.startElement(NameConstants.SV_NODE, attrs);
    }

    @Override
    protected void enteringProperties(Node node, int level) throws RepositoryException, SAXException {
    }

    @Override
    protected void leavingProperties(Node node, int level) throws RepositoryException, SAXException {
    }

    @Override
    protected void leaving(Node node, int level) throws RepositoryException, SAXException {
        this.endElement(NameConstants.SV_NODE);
    }

    @Override
    protected void entering(Property prop, int level) throws RepositoryException, SAXException {
        AttributesImpl attrs = new AttributesImpl();
        this.addAttribute(attrs, NameConstants.SV_NAME, CDATA_TYPE, prop.getName());
        try {
            String typeName = PropertyType.nameFromValue((int)prop.getType());
            this.addAttribute(attrs, NameConstants.SV_TYPE, ENUMERATION_TYPE, typeName);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException("unexpected property-type ordinal: " + prop.getType(), (Throwable)e);
        }
        this.startElement(NameConstants.SV_PROPERTY, attrs);
        if (prop.getType() == 2 && this.skipBinary) {
            this.startElement(NameConstants.SV_VALUE, new AttributesImpl());
            this.endElement(NameConstants.SV_VALUE);
        } else {
            boolean multiValued = prop.getDefinition().isMultiple();
            Value[] vals = multiValued ? prop.getValues() : new Value[]{prop.getValue()};
            for (int i = 0; i < vals.length; ++i) {
                Value val = vals[i];
                Attributes attributes = ATTRS_EMPTY;
                boolean mustSendBinary = false;
                if (val.getType() != 2) {
                    String ser = val.getString();
                    for (int ci = 0; ci < ser.length() && !mustSendBinary; ++ci) {
                        char c = ser.charAt(ci);
                        if (c < '\u0000' || c >= ' ' || c == '\r' || c == '\n' || c == '\t') continue;
                        mustSendBinary = true;
                    }
                    if (mustSendBinary) {
                        this.contentHandler.startPrefixMapping(NS_XMLSCHEMA_INSTANCE_PREFIX, NS_XMLSCHEMA_INSTANCE_URI);
                        this.contentHandler.startPrefixMapping(NS_XMLSCHEMA_PREFIX, NS_XMLSCHEMA_URI);
                        attributes = ATTRS_BINARY_ENCODED_VALUE;
                    }
                }
                this.startElement(NameConstants.SV_VALUE, attributes);
                Writer writer = new Writer(){

                    @Override
                    public void close() {
                    }

                    @Override
                    public void flush() {
                    }

                    @Override
                    public void write(char[] cbuf, int off, int len) throws IOException {
                        try {
                            SysViewSAXEventGenerator.this.contentHandler.characters(cbuf, off, len);
                        }
                        catch (SAXException se) {
                            throw new IOException(se.toString());
                        }
                    }
                };
                try {
                    ValueHelper.serialize(val, false, mustSendBinary, writer);
                }
                catch (IOException ioe) {
                    Throwable t = ioe.getCause();
                    if (t != null && t instanceof SAXException) {
                        throw (SAXException)t;
                    }
                    throw new SAXException(ioe);
                }
                this.endElement(NameConstants.SV_VALUE);
                if (!mustSendBinary) continue;
                this.contentHandler.endPrefixMapping(NS_XMLSCHEMA_INSTANCE_PREFIX);
                this.contentHandler.endPrefixMapping(NS_XMLSCHEMA_PREFIX);
            }
        }
    }

    @Override
    protected void leaving(Property prop, int level) throws RepositoryException, SAXException {
        this.endElement(NameConstants.SV_PROPERTY);
    }

    private void addAttribute(AttributesImpl attributes, Name name, String type, String value) throws NamespaceException {
        attributes.addAttribute(name.getNamespaceURI(), name.getLocalName(), this.resolver.getJCRName(name), type, value);
    }

    private void startElement(Name name, Attributes attributes) throws NamespaceException, SAXException {
        this.contentHandler.startElement(name.getNamespaceURI(), name.getLocalName(), this.resolver.getJCRName(name), attributes);
    }

    private void endElement(Name name) throws NamespaceException, SAXException {
        this.contentHandler.endElement(name.getNamespaceURI(), name.getLocalName(), this.resolver.getJCRName(name));
    }

    static {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("http://www.w3.org/2000/xmlns/", NS_XMLSCHEMA_INSTANCE_PREFIX, "xmlns:xsi", CDATA_TYPE, NS_XMLSCHEMA_INSTANCE_URI);
        attrs.addAttribute("http://www.w3.org/2000/xmlns/", NS_XMLSCHEMA_PREFIX, "xmlns:xs", CDATA_TYPE, NS_XMLSCHEMA_URI);
        attrs.addAttribute(NS_XMLSCHEMA_INSTANCE_URI, "type", "xsi:type", CDATA_TYPE, "xs:base64Binary");
        ATTRS_BINARY_ENCODED_VALUE = attrs;
    }
}

