/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.impl;

import com.kingdee.bos.ctrl.kdf.data.DataSetVisitor;
import com.kingdee.bos.ctrl.kdf.data.config.DBInfo;
import com.kingdee.bos.ctrl.kdf.data.exception.DataSetWrapperException;
import com.kingdee.bos.ctrl.kdf.data.impl.DBConnection;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public final class JDBCDataSetVisitor
implements DataSetVisitor {
    private static final byte[] NULL_BYTE_ARRAY = new byte[0];
    private PreparedStatement preps;
    private ResultSet rs = null;
    private String[] fields;
    private int[] colTypes;
    private boolean validRow;
    private Connection conn;
    private String connectionID;
    private DBInfo[] extraInfo;

    public JDBCDataSetVisitor(String connectionID) {
        this.connectionID = connectionID;
    }

    public void setExtraDBInfo(DBInfo[] info) {
        this.extraInfo = info;
    }

    @Override
    public boolean execute(String name, String query) throws DataSetWrapperException {
        try {
            DBConnection.instance().setExtraInfo(this.extraInfo);
            this.conn = DBConnection.instance().getConnection(this.connectionID);
            this.preps = this.conn.prepareStatement(query);
            this.rs = this.preps.executeQuery();
            ResultSetMetaData rsma = this.rs.getMetaData();
            int size = rsma.getColumnCount();
            this.fields = new String[size];
            this.colTypes = new int[size];
            for (int i = 0; i < size; ++i) {
                this.fields[i] = rsma.getColumnName(i + 1);
                this.colTypes[i] = rsma.getColumnType(i + 1);
            }
            return true;
        }
        catch (SQLException sqle) {
            throw new DataSetWrapperException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getRecord(ArrayList row) throws SQLException, IOException {
        String tmp = "";
        byte[] binarys = null;
        InputStream is = null;
        ByteArrayOutputStream baos = null;
        byte[] c = new byte[1024];
        char[] chrText = new char[1024];
        int len = 0;
        int i = 0;
        while (i < this.colTypes.length) {
            Variant var = (Variant)row.get(i);
            int index = i + 1;
            switch (this.colTypes[i]) {
                case -1: 
                case 12: 
                case 2005: {
                    Reader reader = this.rs.getCharacterStream(index);
                    try {
                        if (reader == null) {
                            var.setObject(null, 11);
                        } else {
                            StringBuilder sb = new StringBuilder();
                            while ((len = reader.read(chrText, 0, chrText.length)) != -1) {
                                sb.append(chrText, 0, len);
                            }
                            var.setObject((Object)sb.toString(), 11);
                            sb = null;
                        }
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{reader});
                        throw throwable;
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{reader});
                    break;
                }
                case 8: {
                    var.setDouble(this.rs.getDouble(index));
                    break;
                }
                case 6: {
                    var.setFloat(this.rs.getFloat(index));
                    break;
                }
                case 4: {
                    var.setInt(this.rs.getInt(index));
                    break;
                }
                case 1: {
                    tmp = this.rs.getString(index);
                    if (tmp == null) {
                        tmp = "";
                    }
                    var.setObject((Object)tmp, 11);
                    break;
                }
                case -7: {
                    var.setByte(this.rs.getByte(index));
                    break;
                }
                case 91: {
                    Date date = this.rs.getDate(index);
                    var.setObject((Object)date, 12);
                    break;
                }
                case 3: {
                    var.setObject((Object)this.rs.getBigDecimal(index), 10);
                    break;
                }
                case 16: {
                    var.setBoolean(this.rs.getBoolean(index));
                    break;
                }
                case 92: {
                    var.setObject((Object)this.rs.getString(index), 11);
                    break;
                }
                case 93: {
                    var.setObject((Object)this.rs.getString(index), 11);
                    break;
                }
                case 5: {
                    var.setInt(this.rs.getInt(index));
                    break;
                }
                case -6: {
                    var.setInt(this.rs.getInt(index));
                    break;
                }
                case -5: {
                    var.setLong(this.rs.getLong(index));
                    break;
                }
                case 2: {
                    var.setObject((Object)this.rs.getBigDecimal(index), 10);
                    break;
                }
                case -2: {
                    byte binary = this.rs.getByte(index);
                    var.setByte(binary);
                    break;
                }
                case -4: 
                case -3: 
                case 2004: {
                    is = this.rs.getBinaryStream(index);
                    if (is != null) {
                        try {
                            baos = new ByteArrayOutputStream();
                            while ((len = is.read(c, 0, c.length)) != -1) {
                                baos.write(c, 0, len);
                            }
                            binarys = baos.toByteArray();
                        }
                        catch (Throwable throwable) {
                            CloseUtil.close((Closeable[])new Closeable[]{baos, is});
                            throw throwable;
                        }
                        CloseUtil.close((Closeable[])new Closeable[]{baos, is});
                        baos = null;
                    } else {
                        binarys = NULL_BYTE_ARRAY;
                    }
                    var.setObject((Object)binarys, 512);
                    binarys = null;
                    is = null;
                    break;
                }
                case 70: {
                    break;
                }
                case 2001: {
                    break;
                }
                case 2000: {
                    var.setObject(this.rs.getObject(index));
                    break;
                }
                case 0: {
                    break;
                }
                case 1111: {
                    break;
                }
                case 7: {
                    var.setDouble(this.rs.getDouble(index));
                    break;
                }
                case 2006: {
                    break;
                }
                case 2002: {
                    break;
                }
                case 2003: {
                    var.setObject((Object)this.rs.getArray(index), 512);
                    break;
                }
            }
            ++i;
        }
        return;
    }

    @Override
    public boolean next(ArrayList avOut) throws DataSetWrapperException {
        try {
            this.validRow = this.rs.next();
            if (!this.validRow) {
                return false;
            }
            this.getRecord(avOut);
        }
        catch (SQLException sqle) {
            throw new DataSetWrapperException(sqle);
        }
        catch (IOException ioe) {
            throw new DataSetWrapperException(ioe);
        }
        return this.validRow;
    }

    @Override
    public boolean isValidRow() throws DataSetWrapperException {
        return this.validRow;
    }

    @Override
    public int getRecordCount() {
        if (this.rs != null) {
            try {
                return this.rs.getFetchSize();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public int getFieldCount() {
        return this.fields.length;
    }

    @Override
    public String[] getAllFieldName() {
        if (null == this.rs) {
            return new String[0];
        }
        String[] result = new String[this.fields.length];
        System.arraycopy(this.fields, 0, result, 0, this.fields.length);
        return result;
    }
}

