/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.upgrade;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.io.Kdm2Meta;
import com.kingdee.bos.ctrl.data.modal.CommonQuery;
import com.kingdee.bos.ctrl.data.modal.Outputs;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.Condition;
import com.kingdee.bos.ctrl.data.modal.query.IColumnList;
import com.kingdee.bos.ctrl.data.modal.query.IJoinList;
import com.kingdee.bos.ctrl.data.modal.query.IOrderList;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.ITableList;
import com.kingdee.bos.ctrl.data.modal.query.Join;
import com.kingdee.bos.ctrl.data.modal.query.JoinType;
import com.kingdee.bos.ctrl.data.modal.query.Order;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.modal.query.Table;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedFilter;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedFilterList;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedJoin;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedTable;
import com.kingdee.bos.ctrl.data.modal.query.framework.bmd.query.BmdQueryQuery;
import com.kingdee.bos.ctrl.data.modal.query.framework.ksql.KsqlQuery;
import com.kingdee.bos.ctrl.data.modal.types.rows.QueryColumns2Fields;
import com.kingdee.bos.ctrl.kdf.data.datasource.DataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.DataSourceXmlTrans;
import com.kingdee.bos.ctrl.kdf.data.datasource.JDBCDataSource;
import com.kingdee.bos.ctrl.kdf.data.query.KDQuery;
import com.kingdee.bos.ctrl.kdf.data.query.QueryColumn;
import com.kingdee.bos.ctrl.kdf.data.query.QueryFilter;
import com.kingdee.bos.ctrl.kdf.data.query.QueryGroup;
import com.kingdee.bos.ctrl.kdf.data.query.QueryJoin;
import com.kingdee.bos.ctrl.kdf.data.query.QueryParam;
import com.kingdee.bos.ctrl.kdf.data.query.QuerySort;
import com.kingdee.bos.ctrl.kdf.data.query.QueryTable;
import com.kingdee.bos.ctrl.kdf.data.wizard.QueryXmlTranser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class KdfDataSource2CommonQuery {
    public static CommonQuery[] done(Element eleDSs, Namespace namespace) {
        KdfDataSource2CommonQuery tool = new KdfDataSource2CommonQuery();
        return tool.translate(eleDSs, namespace);
    }

    private CommonQuery[] translate(Element eleDSs, Namespace namespace) {
        KDQuery oldQuery;
        HashMap<String, KDQuery> mapQuery = new HashMap<String, KDQuery>();
        HashMap<String, DataSource> mapDS = new HashMap<String, DataSource>();
        QueryXmlTranser oldQueryTool = new QueryXmlTranser();
        for (Element eleDS : eleDSs.getChildren("DataSource", namespace)) {
            DataSourceXmlTrans ds2XML = new DataSourceXmlTrans();
            Object objDS = ds2XML.readFromNode(eleDS, null);
            DataSource ds = (DataSource)objDS;
            mapDS.put(ds.getID(), ds);
            Element nodeQuery = (Element)ds.getUserObject();
            if (nodeQuery == null) continue;
            oldQuery = (KDQuery)oldQueryTool.parseQuery(nodeQuery, objDS);
            mapQuery.put(ds.getID(), oldQuery);
        }
        oldQueryTool.manageDoNotFindElement();
        ArrayList<CommonQuery> listCq = new ArrayList<CommonQuery>();
        for (String key : mapQuery.keySet()) {
            DataSource oldDS = (DataSource)mapDS.get(key);
            CommonQuery cq = this.ds2Cq(oldDS, oldQuery = (KDQuery)mapQuery.get(key));
            if (cq == null) continue;
            listCq.add(cq);
        }
        return listCq.toArray(new CommonQuery[0]);
    }

    private CommonQuery ds2Cq(DataSource oldDS, KDQuery oldQuery) {
        BmdQueryQuery newQuery;
        HashMap tableNamesMap = null;
        CommonQuery scm = new CommonQuery();
        int type = oldQuery.getQueryType();
        switch (type) {
            case 0: {
                tableNamesMap = new HashMap();
                newQuery = new BmdQueryQuery();
                this.transTable2BmdPk(oldQuery.getSubQueryList(), (IQuery)newQuery, tableNamesMap);
                break;
            }
            case 1: {
                newQuery = new KsqlQuery(!oldQuery.isSelfDefine());
                newQuery.setContent(((JDBCDataSource)oldDS).getSource());
                this.transTable(oldQuery.getSubQueryList(), newQuery.getTables());
                this.transJoin(oldQuery.getJoinList(), newQuery.getJoins());
                break;
            }
            default: {
                return null;
            }
        }
        scm.setQuery((IQuery)newQuery);
        scm.setName(oldQuery.getID());
        scm.setAlias(oldQuery.getName());
        this.transColumn(oldQuery.getColumnList(), newQuery.getColumns());
        if (type == 0) {
            this.transBosColumnExpr(newQuery.getColumns(), tableNamesMap);
        }
        Outputs ops = new Outputs();
        ops.add((Object)QueryColumns2Fields.toOutputColumns((IColumnList)newQuery.getColumns()));
        scm.setOutputs(ops);
        Condition filter = QueryType.BOS_QUERY.equals(newQuery.getQueryType()) ? null : newQuery.getFilter();
        this.transParam(oldQuery.getParamList(), scm, filter);
        this.transFilter(oldQuery.getFilterList(), (IQuery)newQuery);
        IOrderList newOrderList = newQuery.getOrders();
        this.transGroup(oldQuery.getGroupList(), newOrderList);
        this.transSort(oldQuery.getSortList(), newOrderList);
        return scm;
    }

    private void transTable2BmdPk(LinkedList oldTableList, IQuery newQuery, HashMap tableNamesMap) {
        if (oldTableList.size() > 0) {
            QueryTable oldTable = (QueryTable)oldTableList.get(0);
            String tableID = this.parseSubQueryID(oldTable.getSubQueryID()) + "." + DataDefType.BOS_QUERY.getName();
            tableNamesMap.put(oldTable.getName(), tableID);
            newQuery.setContent(tableID);
        }
    }

    private void transTable(LinkedList oldTableList, ITableList newTableList) {
        int x = 1;
        for (QueryTable oldTable : oldTableList) {
            Table newTable = new Table();
            newTableList.add((Object)newTable);
            String tableID = this.parseSubQueryID(oldTable.getSubQueryID());
            newTable.setName(oldTable.getName());
            newTable.setAlias(oldTable.getName());
            newTable.setExpr(tableID);
            DesignedTable dt = new DesignedTable();
            dt.setX(x);
            dt.setY(10);
            dt.setWidth(90);
            dt.setHeight(150);
            newTable.setExtObj((Object)dt);
            x += 120;
        }
    }

    private void transColumn(LinkedList oldColumnList, IColumnList newColList) {
        for (QueryColumn oldCol : oldColumnList) {
            Column newCol = new Column();
            newColList.add((Object)newCol);
            newCol.setName(oldCol.getProgramID());
            newCol.setAlias(oldCol.getName());
            newCol.setExpr(oldCol.getFormula4Sql());
            newCol.setDataType(Kdm2Meta.toDataType((String)oldCol.getType().getName()));
        }
    }

    private void transBosColumnExpr(IColumnList newColList, HashMap tableNamesMap) {
        for (Column newCol : newColList) {
            String expr = newCol.getExpr();
            expr = this.replaceColumnExpr(expr, tableNamesMap);
            newCol.setExpr(expr);
        }
    }

    private void transJoin(LinkedList oldJoinList, IJoinList newJoinList) {
        int joinIndex = 1;
        for (QueryJoin oldJoin : oldJoinList) {
            if (!oldJoin.isActive()) continue;
            Join newJoin = new Join();
            newJoinList.add((Object)newJoin);
            newJoin.setLeftTable(oldJoin.getFirstTable().getName());
            newJoin.setRightTable(oldJoin.getSecondTable().getName());
            int joinType = oldJoin.getType();
            switch (joinType) {
                case 0: {
                    newJoin.setJoinType(JoinType.INNER);
                    break;
                }
                case 1: {
                    newJoin.setJoinType(JoinType.LEFT);
                    break;
                }
                case 2: {
                    newJoin.setJoinType(JoinType.RIGHT);
                    break;
                }
            }
            DesignedJoin designedJoin = new DesignedJoin();
            designedJoin.setFromField(this.parseFirstFieldID(oldJoin.getFormula4Sql()));
            designedJoin.setToField(this.parseSecondFieldID(oldJoin.getFormula4Sql()));
            designedJoin.setRelation(this.paresRelation(oldJoin.getFormula4Sql()));
            designedJoin.setIndex(joinIndex++);
            Condition joinCondition = new Condition();
            joinCondition.setExpr(oldJoin.getFormula4Sql());
            joinCondition.setExtObj((Object)designedJoin);
            newJoin.setCondition(joinCondition);
        }
    }

    private void transFilter(LinkedList oldFilterList, IQuery newQuery) {
        Condition newFilter = newQuery.getFilter();
        if (newFilter == null) {
            return;
        }
        StringBuffer expr = new StringBuffer();
        if (newFilter.getExpr() != null) {
            expr.append(newFilter.getExpr());
        }
        for (QueryFilter oldFilter : oldFilterList) {
            if (!oldFilter.isActive() || StringUtil.isEmptyString((String)oldFilter.getFormula4Sql())) continue;
            if (expr.length() > 0) {
                expr.append(" and ");
            }
            expr.append("(");
            expr.append(oldFilter.getFormula4Sql());
            expr.append(")");
        }
        if (expr.length() > 0) {
            DesignedFilterList designedFilterList = new DesignedFilterList();
            this.transFilterDesignedInfo(expr.toString(), designedFilterList);
            newFilter.setExpr(expr.toString());
            newFilter.setExtObj((Object)designedFilterList);
        }
    }

    private void transFilterDesignedInfo(String formula, DesignedFilterList designedFilterList) {
        ArrayList<DesignedFilter> subConditions = new ArrayList<DesignedFilter>();
        String[] splitAnd = formula.split("(a|A)(n|N)(d|D)");
        for (int i = 0; i < splitAnd.length; ++i) {
            String[] splitOr = splitAnd[i].split("(o|O)(r|R)");
            for (int j = 0; j < splitOr.length; ++j) {
                DesignedFilter designedFilter = this.transSubCondition(splitOr[j]);
                designedFilterList.getFilterList().add(designedFilter);
                if (j != splitOr.length - 1) {
                    designedFilter.setLogic("or");
                } else if (i != splitAnd.length - 1) {
                    designedFilter.setLogic("and");
                }
                subConditions.add(designedFilter);
            }
        }
    }

    private DesignedFilter transSubCondition(String subCondition) {
        boolean end;
        String leftBracket = "";
        String rightBracket = "";
        DesignedFilter designedFilter = new DesignedFilter();
        do {
            subCondition = subCondition.trim();
            end = true;
            if (subCondition.startsWith("(")) {
                end = false;
                leftBracket = leftBracket + "(";
                subCondition = subCondition.substring(1);
            }
            if (!subCondition.endsWith(")")) continue;
            end = false;
            rightBracket = rightBracket + ")";
            subCondition = subCondition.substring(0, subCondition.length() - 1);
        } while (!end);
        designedFilter.setLeftBracket(leftBracket);
        designedFilter.setRightBracket(rightBracket);
        if (this.transSubConditionInner(subCondition, "<>", designedFilter)) {
            return designedFilter;
        }
        if (this.transSubConditionInner(subCondition, "LIKE", designedFilter)) {
            return designedFilter;
        }
        if (this.transSubConditionInner(subCondition, "IS NOT", designedFilter)) {
            return designedFilter;
        }
        if (this.transSubConditionInner(subCondition, "IS", designedFilter)) {
            return designedFilter;
        }
        if (this.transSubConditionInner(subCondition, ">=", designedFilter)) {
            return designedFilter;
        }
        if (this.transSubConditionInner(subCondition, ">", designedFilter)) {
            return designedFilter;
        }
        if (this.transSubConditionInner(subCondition, "<=", designedFilter)) {
            return designedFilter;
        }
        if (this.transSubConditionInner(subCondition, "<", designedFilter)) {
            return designedFilter;
        }
        this.transSubConditionInner(subCondition, "=", designedFilter);
        return designedFilter;
    }

    private boolean transSubConditionInner(String str, String opr, DesignedFilter designedFilter) {
        int lenOpr = opr.length();
        int idxOpr = str.toLowerCase().indexOf(opr.toLowerCase());
        if (idxOpr != -1) {
            designedFilter.setOperator(opr);
            designedFilter.setExpression(str.substring(0, idxOpr));
            designedFilter.setValue(str.substring(idxOpr + lenOpr));
            return true;
        }
        return false;
    }

    private void transGroup(LinkedList oldGroupList, IOrderList newOrderList) {
        for (QueryGroup.GroupItem oldGroupItem : oldGroupList) {
            Order newOrder = new Order();
            newOrderList.add((Object)newOrder);
            newOrder.setAscending(!oldGroupItem.isDesc());
            newOrder.setExpr(oldGroupItem.getColumn().getProgramID());
        }
    }

    private void transSort(LinkedList oldSortList, IOrderList newOrderList) {
        for (QuerySort oldSort : oldSortList) {
            if (!oldSort.isActive()) continue;
            for (QuerySort.SortItem oldSortItem : oldSort.getItemList()) {
                Order newOrder = new Order();
                newOrderList.add((Object)newOrder);
                newOrder.setAscending(!oldSortItem.isDesc());
                newOrder.setExpr(oldSortItem.getColumn().getFormula4Sql());
            }
        }
    }

    private void transParam(List oldParamList, CommonQuery cq, Condition newFilter) {
        ArrayList<Parameter> newParameters = null;
        for (QueryParam oldParam : oldParamList) {
            if (!oldParam.isActive()) continue;
            if (newParameters == null) {
                newParameters = new ArrayList<Parameter>();
                cq.setParameters(newParameters);
            }
            Parameter newParam = new Parameter();
            newParameters.add(newParam);
            newParam.setName(oldParam.getName());
            if ("String".equalsIgnoreCase(oldParam.getTypeName())) {
                newParam.setDataType(DataType.STRING);
            } else {
                newParam.setDataType(DataType.DECIMAL);
            }
            StringBuffer sbParamValue = new StringBuffer("[");
            sbParamValue.append(oldParam.getSourceQuery().getBasicQuery().getName());
            sbParamValue.append("].[");
            sbParamValue.append(oldParam.getSourceColumn().getProgramID());
            sbParamValue.append("]");
            newParam.setDefaultValue(sbParamValue.toString());
            if (newFilter == null) break;
            StringBuffer sbFilter = new StringBuffer();
            sbFilter.append(oldParam.getColumn().getFormula4Sql());
            sbFilter.append("=@");
            sbFilter.append(oldParam.getName());
            newFilter.setExpr(sbFilter.toString());
            break;
        }
    }

    private String parseSubQueryID(String subQueryID) {
        int idx = subQueryID.indexOf("/");
        return subQueryID.substring(idx + 1);
    }

    private String replaceColumnExpr(String formula4Sql, HashMap tableNames) {
        String strTarget = formula4Sql;
        String strResult = formula4Sql;
        while (true) {
            int idx1 = strTarget.indexOf("[");
            int idx2 = strTarget.indexOf("].[", idx1);
            int idx3 = strTarget.indexOf("]", idx2 + 1);
            if (idx1 == -1 || idx2 == -1 || idx3 == -1) break;
            String alias = strTarget.substring(idx1 + 1, idx2);
            String name = (String)tableNames.get(alias);
            if (name != null) {
                strResult = strResult.replaceFirst(alias, name);
            }
            strTarget = strTarget.substring(idx3);
        }
        return strResult;
    }

    private String parseFirstFieldID(String formula4Sql) {
        int idx2;
        int idx1 = formula4Sql.indexOf("].[");
        if (idx1 > 0 && (idx2 = formula4Sql.indexOf("]", idx1 + 1)) > 0) {
            return formula4Sql.substring(idx1 + 3, idx2);
        }
        return null;
    }

    private String parseSecondFieldID(String formula4Sql) {
        int idx2;
        int idx1 = formula4Sql.lastIndexOf("]");
        if (idx1 > 0 && (idx2 = formula4Sql.lastIndexOf("].[")) > 0 && idx2 < idx1) {
            return formula4Sql.substring(idx2 + 3, idx1);
        }
        return null;
    }

    private int paresRelation(String joinFormaula4Sql) {
        int idx = joinFormaula4Sql.indexOf("=");
        if (idx != -1) {
            return 16;
        }
        idx = joinFormaula4Sql.indexOf("<>");
        if (idx != -1) {
            return 32;
        }
        idx = joinFormaula4Sql.indexOf(">=");
        if (idx != -1) {
            return 96;
        }
        idx = joinFormaula4Sql.indexOf(">");
        if (idx != -1) {
            return 80;
        }
        idx = joinFormaula4Sql.indexOf("<");
        if (idx != -1) {
            return 48;
        }
        idx = joinFormaula4Sql.indexOf("<=");
        if (idx != -1) {
            return 64;
        }
        return 16;
    }
}

