/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.wizard;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.kdf.data.query.KDQuery;
import com.kingdee.bos.ctrl.kdf.data.wizard.ContentSuperPanel;
import com.kingdee.bos.ctrl.kdf.data.wizard.KDDataWizard;
import com.kingdee.bos.ctrl.kdf.data.wizard.KDDataWizardTreeNode;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public final class ContentEntitySource
extends ContentSuperPanel
implements ActionListener {
    private static final long serialVersionUID = -6690807436392088266L;
    private KDLabel lblFilePath;
    private KDLabel lblContent;
    private KDCheckBox chkLinked;
    private KDTextField txtFilePath;
    private KDTextArea txtContent;
    private KDWorkButton btnSelect;
    private KDQuery kdqry;
    private JFileChooser chooser;
    private static final FileFilter csvFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return ContentEntitySource.getFileExtName(file).equalsIgnoreCase("csv");
        }

        @Override
        public String getDescription() {
            return "CSV File (*.csv)";
        }
    };
    private static final FileFilter xmlFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return ContentEntitySource.getFileExtName(file).equalsIgnoreCase("xml");
        }

        @Override
        public String getDescription() {
            return "XML Document (*.xml)";
        }
    };

    public ContentEntitySource(int iTreeNodeType, KDDataWizardTreeNode note, KDDataWizard parent) {
        super(0, iTreeNodeType, note, parent);
        this.kdqry = (KDQuery)((KDDataWizardTreeNode)((Object)note.getParent())).getUserObject();
        this.initComponent();
        this.initEvent();
    }

    private void initComponent() {
        Dimension dimension = new Dimension(26, 19);
        this.lblFilePath = new KDLabel();
        this.lblContent = new KDLabel();
        this.lblFilePath.setText(LanguageManager.getLangMessage((String)"filePath", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u6570\u636e\u6e90\u6587\u4ef6\u8def\u5f84"));
        this.lblContent.setText(LanguageManager.getLangMessage((String)"content", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u6570\u636e\u5185\u5bb9"));
        this.chkLinked = new KDCheckBox(LanguageManager.getLangMessage((String)"isLinked", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u4f7f\u7528\u6587\u4ef6\u94fe\u63a5"));
        this.chkLinked.setSelected(this.kdqry.isLinked());
        this.chkLinked.setActionCommand("chkLinked");
        this.chkLinked.addActionListener((ActionListener)this);
        this.btnSelect = new KDWorkButton((Icon)ContentSuperPanel.IMG_IMPORT);
        this.btnSelect.setActionCommand("btnSelect");
        this.btnSelect.setToolTipText(LanguageManager.getLangMessage((String)"select", (String)"com.kingdee.bos.ctrl.kdf.data.wizard.wizard", (String)"\u9009\u62e9\u6587\u4ef6"));
        this.btnSelect.setMaximumSize(dimension);
        this.btnSelect.setPreferredSize(dimension);
        this.btnSelect.setMinimumSize(dimension);
        this.txtFilePath = new KDTextField();
        this.txtFilePath.setEditable(false);
        this.txtFilePath.setBackground(KDDataWizard.DEFAULT_TEXTAREA_BACKCOLOR);
        this.txtContent = new KDTextArea();
        this.txtContent.setLineWrap(false);
        this.txtContent.setEditable(!this.chkLinked.isSelected());
        if (this.chkLinked.isSelected()) {
            this.txtContent.setBackground(KDDataWizard.DEFAULT_TEXTAREA_BACKCOLOR);
        } else {
            this.txtContent.setBackground(Color.WHITE);
        }
        KDScrollPane sp = new KDScrollPane((Component)this.txtContent);
        sp.setVerticalScrollBarPolicy(22);
        sp.setHorizontalScrollBarPolicy(30);
        if (this.kdqry.isLinked()) {
            this.txtFilePath.setText(this.kdqry.getSource());
            File file = new File(this.kdqry.getSource());
            this.syncTxtContent(file);
        } else {
            this.txtContent.setText(this.kdqry.getSource());
        }
        TableLayout lay = TableLayout.splitRow((int)4);
        lay.rowStyle(0).setHeight(20);
        lay.rowStyle(1).setHeight(20);
        lay.rowStyle(2).setHeight(20);
        lay.rowStyle(3).setPriY(1);
        lay.rowStyle(1).setMarginTop(3);
        lay.rowStyle(2).setMarginTop(8);
        lay.rowStyle(3).setMarginTop(3);
        Table tab0 = lay.cell(0).splitCol(2);
        Table tab1 = lay.cell(1).splitCol(2);
        tab1.colStyle(0).setPriX(1);
        tab1.colStyle(0).setWidth(-100);
        tab1.colStyle(0).setMinWidth(0);
        tab1.colStyle(0).setMarginRight(3);
        Table tab2 = lay.cell(2).splitCol(2);
        tab2.colStyle(0).setPriX(1);
        tab2.colStyle(1).setWidth(26);
        this.getPanSelected().setLayout((LayoutManager)lay);
        this.getPanSelected().add((Component)this.lblFilePath, (Object)tab0.cell(0));
        this.getPanSelected().add((Component)this.chkLinked, (Object)tab0.cell(1));
        this.getPanSelected().add((Component)this.txtFilePath, (Object)tab1.cell(0));
        this.getPanSelected().add((Component)this.btnSelect, (Object)tab1.cell(1));
        this.getPanSelected().add((Component)this.lblContent, (Object)tab2.cell(0));
        this.getPanSelected().add((Component)sp, (Object)lay.cell(3));
        this.chooser = new JFileChooser();
        if (this.kdqry.getQueryType() == 2) {
            this.chooser.setFileFilter(csvFilter);
        } else {
            this.chooser.setFileFilter(xmlFilter);
        }
    }

    private static String getFileExtName(File file) {
        String sFileName = file.getName();
        int index = sFileName.lastIndexOf(46);
        if (index > 0 && index < sFileName.length() - 1) {
            return sFileName.substring(index + 1).toLowerCase();
        }
        return "";
    }

    private void initEvent() {
        this.btnSelect.addActionListener((ActionListener)this);
        this.txtContent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!ContentEntitySource.this.kdqry.isLinked()) {
                    ContentEntitySource.this.kdqry.setSource(ContentEntitySource.this.txtContent.getText());
                }
            }
        });
    }

    private static char[] trimTail(char[] src) {
        int t = src.length - 1;
        for (int i = src.length - 1; i >= 0; --i) {
            if (src[i] == '\u0000') continue;
            t = i;
            break;
        }
        if (t == src.length - 1) {
            return src;
        }
        char[] des = new char[t + 1];
        System.arraycopy(src, 0, des, 0, t + 1);
        return des;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void syncTxtContent(File file) {
        if (file.exists()) {
            FileReader fr = null;
            try {
                fr = new FileReader(file);
                this.txtContent.setText(null);
                char[] buf = new char[1024];
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while ((i = fr.read(buf, 0, 1024)) != -1) {
                    if (i != 1024) {
                        sb.append(String.valueOf(ContentEntitySource.trimTail(buf)));
                    } else {
                        sb.append(String.valueOf(buf));
                    }
                    Arrays.fill(buf, '\u0000');
                }
                this.txtContent.setText(sb.toString());
                fr.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                CloseUtil.close((Closeable[])new Closeable[]{fr});
            }
            catch (IOException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{fr});
                        throw throwable;
                    }
                }
                CloseUtil.close((Closeable[])new Closeable[]{fr});
            }
            CloseUtil.close((Closeable[])new Closeable[]{fr});
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getActionCommand().equals("btnSelect")) {
                File file;
                if (this.chooser.showOpenDialog((Component)((Object)this.parentObj)) == 0 && (file = this.chooser.getSelectedFile()).exists()) {
                    this.txtFilePath.setText(file.getAbsolutePath());
                    this.syncTxtContent(file);
                    if (this.chkLinked.isSelected()) {
                        this.kdqry.setSource(file.getAbsolutePath());
                    } else {
                        this.kdqry.setSource(this.txtContent.getText());
                    }
                }
            } else if (e.getActionCommand().equals("btnSave")) {
                if (!this.chkLinked.isSelected()) {
                    this.kdqry.setSource(this.txtContent.getText());
                }
            } else if (e.getActionCommand().equals("chkLinked")) {
                this.kdqry.setLinked(this.chkLinked.isSelected());
                this.txtContent.setEditable(!this.chkLinked.isSelected());
                if (this.chkLinked.isSelected()) {
                    this.txtContent.setBackground(KDDataWizard.DEFAULT_TEXTAREA_BACKCOLOR);
                    this.kdqry.setSource("");
                } else {
                    this.txtContent.setBackground(Color.WHITE);
                    this.kdqry.setSource(this.txtContent.getText());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

