/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.form;

import com.kingdee.bos.ctrl.kdf.expr.MacroHelperListener;
import com.kingdee.bos.ctrl.kdf.expr.Parser;
import com.kingdee.bos.ctrl.kdf.expr.RelationsListener;
import com.kingdee.bos.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.form.BaseGroup;
import com.kingdee.bos.ctrl.kdf.form.Container;
import com.kingdee.bos.ctrl.kdf.form.ContainerCollection;
import com.kingdee.bos.ctrl.kdf.form.Form;
import com.kingdee.bos.ctrl.kdf.form.Group;
import com.kingdee.bos.ctrl.kdf.form.NameHelper;
import com.kingdee.bos.ctrl.kdf.form.PaginationInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class Page
extends Container
implements MacroHelperListener,
Serializable {
    private static final long serialVersionUID = 3138833113085610965L;
    private ContainerCollection children;
    private BaseGroup bgrp;
    private int repeat;
    private transient PaginationInfo pinfo;
    private HashMap idTable;
    private int index;
    private Form form;
    private transient int unsureCount = 0;

    public Page() {
        this(1);
    }

    public Page(String id) {
        this(1);
        this.setId(id);
    }

    public Page(int repeat) {
        this.repeat = repeat;
        this.pinfo = new PaginationInfo();
        this.bgrp = new BaseGroup();
        this.children = new ContainerCollection();
        this.idTable = new HashMap();
    }

    public Page(String id, int repeat) {
        this(repeat);
        this.setId(id);
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    @Override
    public boolean addChild(Container child) {
        return this.children.add(child);
    }

    @Override
    public boolean deleteChild(Container child) {
        return this.children.remove(child);
    }

    @Override
    public Iterator iterator() {
        return this.children.iterator();
    }

    @Override
    public Group group() {
        return this.bgrp;
    }

    @Override
    public void setParent(Container val) {
        super.setParent(val);
        this.parent = null;
    }

    public Container getObjectByName(String name) {
        if (name != null) {
            if (name.indexOf(".") < 0) {
                if (this.idTable.containsKey(name)) {
                    return (Container)this.idTable.get(name);
                }
            } else {
                String pName = name.substring(0, name.indexOf("."));
                String cName = name.substring(name.indexOf(".") + 1);
                if (pName.equals(this.getId()) && this.idTable.containsKey(cName)) {
                    return (Container)this.idTable.get(cName);
                }
            }
        }
        return null;
    }

    protected Container getObjectByNameDirect(String name) {
        if (this.idTable.containsKey(name)) {
            return (Container)this.idTable.get(name);
        }
        return null;
    }

    public PaginationInfo getPaginationInfo() {
        return this.pinfo;
    }

    public HashMap getIdTable() {
        return this.idTable;
    }

    @Override
    public Container nextCopy() {
        return null;
    }

    @Override
    public Container copy(boolean copyEdge) {
        Page pg = new Page();
        pg.setId(NameHelper.getUniqueName());
        pg.setUserAlias(this.getUserAlias());
        pg.setForm(this.form);
        pg.setRepeat(this.getRepeat());
        pg.setLayer(this.getLayer());
        pg.setAnchor(this.getAnchor());
        pg.setHint(this.getHint());
        pg.setSource(this.getSource());
        pg.setStyles(this.getStyles());
        pg.copyCustomStyles(this.getCustomStyles());
        pg.copyProperties(this.getProperties());
        pg.setVisibility(this.getVisibility());
        pg.setPreSteps(this.getPreSteps());
        pg.setPostSteps(this.getPostSteps());
        pg.group().copy(this.group());
        pg.children = this.children.copyTo(pg, copyEdge);
        Form.updateIdTable(true, pg, pg);
        return pg;
    }

    @Override
    public Container copyTo(Container parent, boolean copyEdge) {
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public static String getUsableLeft(Container cont) {
        while (cont != null) {
            if (cont.getLeft().getString() != null) {
                return cont.getLeft().getString();
            }
            cont = cont.getParent();
        }
        return "0";
    }

    public static String getUsableRight(Container cont) {
        if (cont.getRight().getString() != null) {
            return cont.getRight().getString();
        }
        return Page.getUsableLeft(cont);
    }

    public static String getUsableTop(Container cont) {
        while (cont != null) {
            if (cont.getTop().getString() != null) {
                return cont.getTop().getString();
            }
            cont = cont.getParent();
        }
        return "0";
    }

    public static String getUsableBottom(Container cont) {
        if (cont.getBottom().getString() != null) {
            return cont.getBottom().getString();
        }
        return Page.getUsableTop(cont);
    }

    public boolean externalMethod(Parser psr, String funcName, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
        return false;
    }

    public boolean queryVariable(Parser psr, String variableName, Variant varFormula, Variant rvarResult) throws SyntaxErrorException {
        if (variableName != null) {
            int i = variableName.indexOf(".");
            if (i > 0) {
                String objName = variableName.substring(0, i);
                String valName = variableName.substring(i + 1);
                Container cont = this.getObjectByNameDirect(objName);
                if (cont != null) {
                    if (valName.equalsIgnoreCase("left")) {
                        varFormula.setObject((Object)Page.getUsableLeft(cont), 11);
                        return true;
                    }
                    if (valName.equalsIgnoreCase("right")) {
                        varFormula.setObject((Object)Page.getUsableRight(cont), 11);
                        return true;
                    }
                    if (valName.equalsIgnoreCase("top")) {
                        varFormula.setObject((Object)Page.getUsableTop(cont), 11);
                        return true;
                    }
                    if (valName.equalsIgnoreCase("bottom")) {
                        varFormula.setObject((Object)Page.getUsableBottom(cont), 11);
                        return true;
                    }
                }
            }
            return this.getForm().queryVariable(psr, variableName, varFormula, rvarResult);
        }
        return false;
    }

    public boolean queryObjectInstance(Parser psr, String objectName, Variant varInstance) {
        Container cont = this.getObjectByName(objectName);
        if (cont != null) {
            varInstance.setObject((Object)cont, 17);
            return true;
        }
        return this.getForm().queryObjectInstance(psr, objectName, varInstance);
    }

    public boolean queryCell(Parser psr, RelationsListener listener, int row, int col, Variant rvarResult) throws SyntaxErrorException {
        return false;
    }

    public String getMethodName(String methodName) {
        return methodName;
    }

    public Form getForm() {
        return this.form;
    }

    public void setForm(Form form) {
        this.form = form;
    }

    @Override
    protected ArrayList innerList() {
        return this.children.innerList();
    }

    @Override
    public String toString() {
        return "Page " + super.toString();
    }

    public boolean isUnsure() {
        return this.unsureCount > 0;
    }

    public void unsureIncrease() {
        ++this.unsureCount;
    }

    public void unsureReduce() {
        --this.unsureCount;
    }
}

