/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.gui;

import com.kingdee.bos.ctrl.kdf.formbrowser2.ClientForm;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ClientCore;
import com.kingdee.bos.ctrl.kdf.formbrowser2.gui.IPreviewWindow;
import com.kingdee.bos.ctrl.kdf.formbrowser2.resources.Resources;
import com.kingdee.bos.ctrl.kdf.printprovider.gui.BaseComponent;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class DefaultPreviewDialog
extends KDDialog
implements IPreviewWindow {
    private static final long serialVersionUID = 7706239129967530305L;
    BaseComponent baseComp;
    ClientForm clientform;
    boolean fExitOnClose;
    boolean isClosed = false;

    public DefaultPreviewDialog(boolean fExitOnClose, ClientForm clientform, JFrame parent) {
        super((Frame)(parent == null ? new KDFrame() : parent), true);
        this.init(fExitOnClose, clientform);
    }

    public DefaultPreviewDialog(boolean fExitOnClose, ClientForm clientform, Dialog parent) {
        super(parent, true);
        this.init(fExitOnClose, clientform);
    }

    private void init(boolean fExitOnClose, ClientForm clientform) {
        this.fExitOnClose = fExitOnClose;
        this.clientform = clientform;
        ClientCore clientCore = clientform.getClientCore();
        clientCore.setMainFrame(this);
        this.baseComp = clientCore.getInitializedBaseComponent();
        clientCore.getUiDelegate().setAvailableUI(this.baseComp);
        this.setContentPane(this.baseComp);
        this.repaint();
        this.setTitle(Resources.theRes.getString("titleName"));
        clientCore.getPrintService().setActionInitializer(clientform.getToolbarBuilder());
        this.setSize(new Dimension(640, 720));
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - this.getWidth()) / 2, 10);
        if (fExitOnClose) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(2);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DefaultPreviewDialog.this.onClose();
            }
        });
    }

    @Override
    public void showModalFrame() {
        this.isClosed = false;
        this.setModal(true);
        this.show();
    }

    protected void onClose() {
        Thread worker = this.clientform.getWorker();
        if (this.clientform.getClientCore().getConfManager().getConf().isStopRetriveAtClose()) {
            if (worker != null) {
                this.clientform.getRawpages().cancelJob(worker);
            }
        } else if (this.fExitOnClose && worker != null) {
            this.clientform.getRawpages().cancelJob(worker);
        }
        this.clientform.getClientCore().getContextOfBrowser().closeDocument();
        this.isClosed = true;
    }

    @Override
    public void closeModalFrame() {
        this.dispose();
        this.onClose();
    }
}

