/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.headfootdesigner;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.ExtendButtonAction;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootDesignerPane;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootPreviewPane;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class HeadFootDesigner
extends KDDialog {
    private static final long serialVersionUID = -2037916309847346027L;
    private boolean isHeadChanged = false;
    private boolean isFootChanged = false;
    private HeadFootModel headModel;
    private HeadFootModel footModel;
    private HeadFootModel headModelForModify;
    private HeadFootModel footModelForModify;
    private KDButton btnOK = new KDButton(this.getMLS("ok", "OK"));
    private KDButton btnCancel = new KDButton(this.getMLS("cancel", "Cancel"));
    private KDButton btnPreview = new KDButton(this.getMLS("preview", "Preview"));
    private HeadFootDesignerPane headPane = new HeadFootDesignerPane();
    private HeadFootDesignerPane footPane = new HeadFootDesignerPane();
    private PreviewDialog preview;
    private int currentPageForPreview = 0;
    private int totalPageForPreview = 999;

    public HeadFootDesigner(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.installListener();
    }

    private void initComponents() {
        this.setResizable(false);
        this.getContentPane().setBackground(new Color(0xD9D9D0));
        this.headPane.setBackground(new Color(15000799));
        this.footPane.setBackground(new Color(15000799));
        KDSeparator separator = new KDSeparator();
        KDTabbedPane tabPane = new KDTabbedPane();
        tabPane.addTab(this.getMLS("head", "\u9875\u7709"), (Component)this.headPane);
        tabPane.addTab(this.getMLS("foot", "\u9875\u811a"), (Component)this.footPane);
        this.getContentPane().add((Component)tabPane);
        this.getContentPane().add((Component)separator);
        this.getContentPane().add((Component)this.btnOK);
        this.getContentPane().add((Component)this.btnCancel);
        this.getContentPane().add((Component)this.btnPreview);
        this.getContentPane().setLayout((LayoutManager)new KDLayout());
        ((JComponent)this.getContentPane()).putClientProperty("OriginalBounds", new Rectangle(0, 0, 450, 340));
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 10, 430, 278);
        cons.anchor = 15;
        tabPane.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(0, 299, 500, 2);
        cons.anchor = 14;
        separator.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(291, 310, 73, 21);
        cons.anchor = 10;
        this.btnOK.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(367, 310, 73, 21);
        cons.anchor = 10;
        this.btnCancel.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(215, 310, 73, 21);
        cons.anchor = 10;
        this.btnPreview.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
    }

    private void installListener() {
        ActionHandler actionHandler = new ActionHandler();
        this.btnOK.addActionListener((ActionListener)actionHandler);
        this.btnCancel.addActionListener((ActionListener)actionHandler);
        this.btnPreview.addActionListener((ActionListener)actionHandler);
    }

    public HeadFootModel getHeadModel() {
        return this.headModel;
    }

    public void setHeadModel(HeadFootModel model) {
        this.headModel = model;
        this.headModelForModify = (HeadFootModel)model.clone();
        this.headPane.setModel(this.headModelForModify);
    }

    public HeadFootModel getFootModel() {
        return this.footModel;
    }

    public void setFootModel(HeadFootModel model) {
        this.footModel = model;
        this.footModelForModify = (HeadFootModel)model.clone();
        this.footPane.setModel(this.footModelForModify);
    }

    public void show() {
        this.isHeadChanged = false;
        this.isFootChanged = false;
        super.show();
    }

    private void closeDialog() {
        this.isHeadChanged = false;
        this.isFootChanged = false;
        this.setVisible(false);
        this.dispose();
    }

    public boolean isHeadChanged() {
        return this.isHeadChanged;
    }

    public boolean isFootChanged() {
        return this.isFootChanged;
    }

    private String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootDesigner", (String)defaultValue);
    }

    public void addExtendButton(ExtendButtonAction action) {
        this.headPane.addExtendButton(action);
        this.footPane.addExtendButton(action);
    }

    public void setVarProv(ExtVarProvider provider) {
    }

    public void setCurrentPageForPreview(int currentPage) {
        this.currentPageForPreview = currentPage;
    }

    public void setTotalPageForPreview(int totalPage) {
        this.totalPageForPreview = totalPage;
    }

    private class PreviewDialog
    extends KDDialog {
        private static final long serialVersionUID = 8785918147079718672L;
        private HeadFootPreviewPane previewPane;
        private KDButton btnBack;

        public PreviewDialog(Dialog owner, boolean modal) {
            super(owner, modal);
            this.previewPane = new HeadFootPreviewPane();
            this.btnBack = new KDButton(HeadFootDesigner.this.getMLS("ok", "\u786e\u5b9a"));
            this.installComponents();
            this.installListener();
        }

        private void installComponents() {
            KDSeparator separator = new KDSeparator();
            this.setSize(new Dimension(626, 310));
            this.getContentPane().setBackground(new Color(0xD9D9D0));
            this.getContentPane().add((Component)((Object)this.previewPane));
            this.getContentPane().add((Component)separator);
            this.getContentPane().add((Component)this.btnBack);
            this.getContentPane().setLayout((LayoutManager)new KDLayout());
            ((JComponent)this.getContentPane()).putClientProperty("OriginalBounds", new Rectangle(0, 0, 620, 290));
            KDLayout.Constraints cons = new KDLayout.Constraints();
            cons.originalBounds = new Rectangle(0, 0, 620, 240);
            cons.anchor = 15;
            this.previewPane.putClientProperty("KDLayoutConstraints", cons);
            cons = new KDLayout.Constraints();
            cons.originalBounds = new Rectangle(0, 249, 800, 2);
            cons.anchor = 14;
            separator.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
            cons = new KDLayout.Constraints();
            cons.originalBounds = new Rectangle(538, 260, 73, 21);
            cons.anchor = 10;
            this.btnBack.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        }

        private void installListener() {
            this.btnBack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreviewDialog.this.dispose();
                }
            });
        }

        public HeadFootPreviewPane getPreviewPane() {
            return this.previewPane;
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source.equals(HeadFootDesigner.this.btnOK)) {
                HeadFootDesigner.this.closeDialog();
                if (!HeadFootDesigner.this.headModel.equals((Object)HeadFootDesigner.this.headModelForModify)) {
                    HeadFootDesigner.this.headModel = (HeadFootModel)HeadFootDesigner.this.headModelForModify.clone();
                    HeadFootDesigner.this.isHeadChanged = true;
                }
                if (!HeadFootDesigner.this.footModel.equals((Object)HeadFootDesigner.this.footModelForModify)) {
                    HeadFootDesigner.this.footModel = (HeadFootModel)HeadFootDesigner.this.footModelForModify.clone();
                    HeadFootDesigner.this.isFootChanged = true;
                }
            } else if (source.equals(HeadFootDesigner.this.btnCancel)) {
                HeadFootDesigner.this.closeDialog();
            } else if (source.equals(HeadFootDesigner.this.btnPreview)) {
                if (HeadFootDesigner.this.preview == null) {
                    HeadFootDesigner.this.preview = new PreviewDialog((Dialog)((Object)HeadFootDesigner.this), true);
                    HeadFootDesigner.this.preview.setTitle(HeadFootDesigner.this.getMLS("title", "\u9875\u7709\u9875\u811a\u8bbe\u8ba1\u5668") + " - " + HeadFootDesigner.this.getMLS("preview", "\u9884\u89c8"));
                    HeadFootDesigner.this.preview.setResizable(false);
                }
                HeadFootDesigner.this.preview.getPreviewPane().setHeadModel(HeadFootDesigner.this.headModelForModify);
                HeadFootDesigner.this.preview.getPreviewPane().setFootModel(HeadFootDesigner.this.footModelForModify);
                HeadFootDesigner.this.preview.setLocationRelativeTo(null);
                HeadFootDesigner.this.preview.getPreviewPane().setCurrentPage(HeadFootDesigner.this.currentPageForPreview);
                HeadFootDesigner.this.preview.getPreviewPane().setTotalPage(HeadFootDesigner.this.totalPageForPreview);
                HeadFootDesigner.this.preview.show();
            }
        }
    }
}

