/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.file;

import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlException;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public final class KDFXmlWriter
extends KDFXmlReader {
    private Writer writer;
    private File file;
    public static final String XML_ENCODING = "UTF-8";

    public KDFXmlWriter() {
    }

    public KDFXmlWriter(String fileName) throws KDFXmlException {
        super(fileName);
    }

    public KDFXmlWriter(Reader reader) {
        super(reader);
    }

    public KDFXmlWriter(InputStream stream) {
        super(stream);
    }

    public KDFXmlWriter(KDFXmlReader reader) throws KDFException {
        this.doc = reader.getDoc();
        this.root = reader.getRoot();
        this.styleNodeBuf = reader.getStyleNodeBuf();
    }

    public void addStyleNode(Element styleNode) {
        Element nodeStyles = this.getStylesNode();
        nodeStyles.addContent((Content)styleNode);
        this.styleNodeBuf.put(styleNode.getAttributeValue("id"), styleNode);
    }

    public void addDataSourceNode(Element datasourceNode) {
        this.getDataSourcesNode().addContent((Content)datasourceNode);
    }

    public void addDBConnectionNode(Element dbconnNode) {
        this.getDBConnectionsNode().addContent((Content)dbconnNode);
    }

    public void addParamNode(Element paramNode) {
        this.getParamsNode().addContent((Content)paramNode);
    }

    public void addHeaderNode(Element headerNode) {
        this.getHeadersNode().addContent((Content)headerNode);
    }

    public void addFooterNode(Element footerNode) {
        this.getFootersNode().addContent((Content)footerNode);
    }

    public void addFormNode(Element formNode) {
        this.getRoot().addContent((Content)formNode);
    }

    public void addTableNode(Element tableNode) {
        this.getRoot().addContent((Content)tableNode);
    }

    public void addTablePrintSetNode(Element tableNode) {
        this.getRoot().addContent((Content)tableNode);
    }

    public void addAuthor(String author) {
        Element nodeDocInfo = this.getDocInfoNode();
        Element nodeAuthor = new Element("Author", KDFXmlReader.NS_COMMON);
        nodeAuthor.setText(author);
        nodeDocInfo.addContent((Content)nodeAuthor);
    }

    public void addAuthors(String[] authors) {
        for (int i = 0; i < authors.length; ++i) {
            this.addAuthor(authors[i]);
        }
    }

    public void setAuthors(String[] authors) {
        this.getDocInfoNode().removeChildren("Author", KDFXmlReader.NS_COMMON);
        this.addAuthors(authors);
    }

    public void setCompany(String company) {
        Element nodeDocInfo;
        Element nodeCT;
        if (company == null) {
            company = "";
        }
        if (null == (nodeCT = (nodeDocInfo = this.getDocInfoNode()).getChild("Company", KDFXmlReader.NS_COMMON))) {
            nodeCT = new Element("Company", KDFXmlReader.NS_COMMON);
            nodeDocInfo.addContent((Content)nodeCT);
        }
        nodeCT.setText(company.trim());
    }

    public void setVersion(String version) {
        this.getRoot().setAttribute("version", version);
    }

    public void setCreatedTime(Date time) {
        this.setCreateTime(time.toString());
    }

    public void setCreateTime(String strTime) {
        Element nodeDocInfo = this.getDocInfoNode();
        Element nodeCT = nodeDocInfo.getChild("Created", KDFXmlReader.NS_COMMON);
        if (null == nodeCT) {
            nodeCT = new Element("Created", KDFXmlReader.NS_COMMON);
            nodeDocInfo.addContent((Content)nodeCT);
        }
        nodeCT.setText(strTime);
    }

    public void setLastModified(Date time) {
        this.setLastModified(time.toString());
    }

    public void setLastModified(String strTime) {
        Element nodeDocInfo = this.getDocInfoNode();
        Element nodeCT = nodeDocInfo.getChild("LastModified", KDFXmlReader.NS_COMMON);
        if (null == nodeCT) {
            nodeCT = new Element("LastModified", KDFXmlReader.NS_COMMON);
            nodeDocInfo.addContent((Content)nodeCT);
        }
        nodeCT.setText(strTime);
    }

    public void setPrintInfo(Element printInfoNode) {
        this.getRoot().removeChild("PrintInfo", this.getRoot().getNamespace());
        this.getRoot().addContent((Content)printInfoNode);
    }

    public void removeAllFormNodes() {
        this.getRoot().removeChildren("Form", this.getRoot().getNamespace());
    }

    public void removeAllTableNodes() {
        this.getRoot().removeChildren("Table", this.getRoot().getNamespace());
    }

    public void removeAllTableSet() {
        this.getRoot().removeChildren("TablePrintSets", this.getRoot().getNamespace());
    }

    public void removeAllStyleNodes() {
        this.getStylesNode().removeChildren("Style", KDFXmlReader.NS_COMMON);
    }

    public void removeAllDataSourceNodes() {
        this.getDataSourcesNode().removeChildren("DataSource", KDFXmlReader.NS_COMMON);
    }

    public void removeAllDBConnectionNodes() {
        this.getDBConnectionsNode().removeChildren("DBConnection", KDFXmlReader.NS_COMMON);
    }

    public void removeAllParamNodes() {
        this.getParamsNode().removeChildren("Param", KDFXmlReader.NS_COMMON);
    }

    public void removeAllHeaderNodes() {
        this.getHeadersNode().removeChildren("Header", KDFXmlReader.NS_COMMON);
    }

    public void removeAllFooterNodes() {
        this.getFootersNode().removeChildren("Footer", KDFXmlReader.NS_COMMON);
    }

    public Element removeFormNodeByID(String formID) {
        Element formNode = this.getFormNodeByID(formID);
        this.getRoot().removeContent((Content)formNode);
        return formNode;
    }

    public Element removeTableNodeByID(String tableID) {
        Element tableNode = this.getTableNodeByID(tableID);
        this.getRoot().removeContent((Content)tableNode);
        return tableNode;
    }

    /*
     * Exception decompiling
     */
    public void save(String fileName) throws KDFException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void save(OutputStream os) {
        try {
            Format format = Format.getPrettyFormat();
            format.setEncoding(XML_ENCODING);
            format.setIndent("    ");
            format.setOmitEncoding(false);
            format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
            XMLOutputter outter = new XMLOutputter(format);
            outter.output(this.getDoc(), os);
            os.close();
        }
        catch (IOException err) {
            throw new RuntimeException("Write stream error: " + err.getMessage());
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void save(Writer writer) {
        try {
            Format format = Format.getPrettyFormat();
            format.setEncoding(XML_ENCODING);
            format.setIndent("    ");
            format.setOmitEncoding(false);
            format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
            XMLOutputter outter = new XMLOutputter(format);
            outter.output(this.getDoc(), writer);
            writer.close();
        }
        catch (IOException err) {
            throw new RuntimeException("Write file error: " + err.getMessage());
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public Writer getWriter() {
        if (this.writer != null) {
            return this.writer;
        }
        try {
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), XML_ENCODING);
        }
        catch (IOException err) {
            throw new RuntimeException("Write file [" + this.getFileName() + "] error, can not create FileWriter");
        }
        return this.writer;
    }

    public String getFileName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return null;
    }

    public void setUserObjects(Element userObjectsNode) {
        this.getRoot().removeChild("UserObjects", this.getRoot().getNamespace());
        this.getRoot().addContent((Content)userObjectsNode);
    }

    public void addDataObjectNode(Element dataObjNode) {
        this.getDataObjectsNode().addContent((Content)dataObjNode);
    }

    public void removeAllDataObjectNodes() {
        this.getDataObjectsNode().getChildren().clear();
    }

    public void addElement(Element e) {
        if (e == null) {
            return;
        }
        this.getRoot().removeChild(e.getName(), this.getRoot().getNamespace());
        e.setNamespace(this.getRoot().getNamespace());
        this.getRoot().addContent((Content)e);
    }
}

