/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.print;

import com.kingdee.bos.ctrl.kdf.util.Tools;
import com.kingdee.bos.ctrl.kdf.util.print.BasicGridAreaPainter;
import com.kingdee.bos.ctrl.kdf.util.print.IAreaPainter;
import com.kingdee.bos.ctrl.kdf.util.print.IAreaSect;
import com.kingdee.bos.ctrl.kdf.util.print.IContentGrid;
import com.kingdee.bos.ctrl.kdf.util.print.IGridPageArea;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public final class BasicGridPageArea
implements IGridPageArea {
    protected ArrayList sects;
    protected int sectSpace = 0;
    protected Rectangle2D area;
    protected IAreaPainter painter;
    private byte sectsAlign = 0;

    public BasicGridPageArea() {
    }

    public BasicGridPageArea(int sectSpace) {
        this.sectSpace = sectSpace;
    }

    @Override
    public List getSects() {
        if (this.sects == null) {
            this.sects = new ArrayList(1);
        }
        return this.sects;
    }

    @Override
    public int getSectSpace() {
        return this.sectSpace;
    }

    public void addSect(PageSect sect) {
        this.getSects().add(sect);
    }

    public void removeSect(int index) {
        this.getSects().remove(index);
    }

    public boolean contains(IContentGrid grid, int row, int col) {
        for (int i = this.getSects().size() - 1; i >= 0; --i) {
            PageSect sect = (PageSect)this.getSects().get(i);
            if (!sect.contains(grid, row, col)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Rectangle2D getArea() {
        return this.area;
    }

    @Override
    public void paint(Graphics g, Rectangle2D pagePrintableArea) {
        this.getPainter().paintPageArea(this, g, pagePrintableArea);
    }

    @Override
    public void setArea(Rectangle2D area) {
        this.area = area;
    }

    public IAreaPainter getPainter() {
        if (this.painter == null) {
            this.painter = new BasicGridAreaPainter();
        }
        return this.painter;
    }

    public void setPainter(IAreaPainter painter) {
        this.painter = painter;
    }

    public void setSectsAlign(byte vertical2) {
        this.sectsAlign = vertical2;
    }

    @Override
    public byte getSectsAlign() {
        return this.sectsAlign;
    }

    public static final class PageSect
    implements IAreaSect {
        private IContentGrid grid;
        private int top;
        private int right;
        private int left;
        private int bottom;

        public PageSect() {
        }

        public PageSect(IContentGrid grid, int top, int bottom, int left, int right) {
            this.grid = grid;
            this.top = top;
            this.right = right;
            this.left = left;
            this.bottom = bottom;
        }

        @Override
        public int getBottom() {
            return this.bottom > this.top ? this.bottom : this.top;
        }

        public boolean contains(IContentGrid grid, int row, int col) {
            if (this.getGrid() == null || !this.getGrid().equals(grid)) {
                return false;
            }
            if (row < this.getTop()) {
                return false;
            }
            if (row >= this.getBottom()) {
                return false;
            }
            if (col < this.getLeft()) {
                return false;
            }
            return col < this.getRight();
        }

        @Override
        public IContentGrid getContentGrid() {
            return this.grid;
        }

        @Override
        public int getLeft() {
            return this.left > this.right ? this.right : this.left;
        }

        @Override
        public int getRight() {
            return this.right > this.left ? this.right : this.left;
        }

        @Override
        public int getTop() {
            return this.top > this.bottom ? this.bottom : this.top;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof PageSect) {
                PageSect sect = (PageSect)obj;
                if (!(this.grid != null ? this.getGrid().equals(sect.getGrid()) : sect.getGrid() == null)) {
                    return false;
                }
                if (this.left != sect.getLeft()) {
                    return false;
                }
                if (this.right != sect.getRight()) {
                    return false;
                }
                if (this.top != sect.getTop()) {
                    return false;
                }
                return this.bottom == sect.getBottom();
            }
            return false;
        }

        public int hashCode() {
            int[] seeds = new int[]{super.hashCode(), this.grid == null ? 0 : this.grid.hashCode(), this.getTop(), this.getBottom(), this.getLeft(), this.getRight()};
            return Tools.hashCalculate((int[])seeds);
        }

        public String toString() {
            return super.toString();
        }

        public IContentGrid getGrid() {
            return this.grid;
        }

        public void setGrid(IContentGrid grid) {
            this.grid = grid;
        }

        public void setBottom(int bottom) {
            this.bottom = bottom;
        }

        public void setLeft(int left) {
            this.left = left;
        }

        public void setRight(int right) {
            this.right = right;
        }

        public void setTop(int top) {
            this.top = top;
        }
    }
}

