/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.exec;

import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSetFactory;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.excel.expans.model.data.IExtDataSetFactory;
import com.kingdee.bos.ctrl.excel.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import java.util.HashMap;
import java.util.Map;

public class ExecutionContext {
    private Sheet _sheet;
    private Map _params;
    private Map _cacheObj;

    public ExecutionContext(Sheet sheet) {
        this._sheet = sheet;
    }

    void registerDataSetFactories(Map factories) {
        ExtDataSetManager datasetManager = this._sheet.getDataSetManager();
        ExtDataSetFactory sheetDataFactory = datasetManager.getExtDataSetFactory();
        for (ExtDataSetType type : factories.keySet()) {
            sheetDataFactory.registerFactory(type, (IExtDataSetFactory)factories.get(type));
        }
    }

    void attachDataSetParameters(Map parameters) {
        this._params = parameters;
    }

    public Map getDataSetParameters() {
        return this._params;
    }

    public IParameter getDataSetParameter(String pName) {
        if (this._params == null) {
            return null;
        }
        return (IParameter)this._params.get(pName);
    }

    public void copyFrom(ExecutionContext ctx) {
        this._params = ctx._params;
        this._cacheObj = ctx._cacheObj;
    }

    public Object getDataSetCacheObject(Object key) {
        if (this._cacheObj == null) {
            return null;
        }
        return this._cacheObj.get(key);
    }

    public void registerDataSetCacheObject(Object key, Object cacheObj) {
        if (this._cacheObj == null) {
            this._cacheObj = new HashMap();
        }
        this._cacheObj.put(key, cacheObj);
    }
}

