/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kml;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.io.kml.BasicElement;
import com.kingdee.bos.ctrl.excel.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.excel.io.kml.KmlUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class DiagonalHeaderElement
extends BasicElement {
    DiagonalHeaderElement() {
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return "DiagonalHeader".equals(KmlUtil.getLocalName(qName));
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        Cell cell;
        DiagonalHeader dh;
        String qqname = KmlUtil.getLocalName(qName);
        if ("DiagonalHeader".equals(qqname)) {
            Cell cell2 = dataCache.getCurCell();
            DiagonalHeader dh2 = new DiagonalHeader();
            dh2.setSheet(cell2.getSheet());
            int row = Integer.parseInt(attributes.getValue("Row"));
            int col = Integer.parseInt(attributes.getValue("Col"));
            int row2 = Integer.parseInt(attributes.getValue("Row2"));
            int col2 = Integer.parseInt(attributes.getValue("Col2"));
            int pos = Integer.parseInt(attributes.getValue("Position"));
            String srowOffs = attributes.getValue("RowOffers");
            int[] rowOffs = null;
            if (!StringUtil.isEmptyString((String)srowOffs)) {
                String[] strs = srowOffs.split(",");
                rowOffs = new int[strs.length];
                for (int i = strs.length - 1; i >= 0; --i) {
                    rowOffs[i] = Integer.parseInt(strs[i]);
                }
            }
            String scolOffs = attributes.getValue("ColOffers");
            int[] colOffs = null;
            if (!StringUtil.isEmptyString((String)scolOffs)) {
                String[] strs = scolOffs.split(",");
                colOffs = new int[strs.length];
                for (int i = strs.length - 1; i >= 0; --i) {
                    colOffs[i] = Integer.parseInt(strs[i]);
                }
            }
            dh2.setRowCol(row, col, row2, col2);
            dh2.setSplitInfo(new Integer(pos), rowOffs, colOffs);
            cell2.setDiagonalHeader(dh2);
        } else if ("Triangle".equals(qqname) && (dh = (cell = dataCache.getCurCell()).getDiagonalHeader()) != null) {
            int index = Integer.parseInt(attributes.getValue("Index"));
            String text = attributes.getValue("String");
            if (text != null) {
                text = KmlUtil.toBookString(text);
            }
            boolean lean = new Boolean(attributes.getValue("Lean"));
            boolean zoom = new Boolean(attributes.getValue("Zoom"));
            boolean drawBack = new Boolean(attributes.getValue("DrawBack"));
            dh.setAutoZoom(zoom, index);
            dh.setLean(lean, index);
            dh.setDrawBackground(drawBack, index);
            dh.setText(text, index);
            if (ktb.touchModeFlag(FLAG_STYLE)) {
                String styleID = attributes.getValue("StyleID");
                ShareStyleAttributes ssa = (ShareStyleAttributes)dataCache.getStyles().get(styleID);
                if (ssa != null) {
                    dh.setStyle(Styles.getStyle((ShareStyleAttributes)ssa), index);
                }
            }
            return;
        }
    }
}

