/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_AttributeSpan;
import com.kingdee.bos.ctrl.excel.model.util.ObjectCache;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.printjob.table.SheetPlugablePaginationAdvice;
import java.awt.Color;
import java.util.HashMap;

public abstract class CellPropAction {
    private static final HashMap _keysMap = new HashMap();
    private int _intKey;
    private String _strKey;

    public static CellPropAction getAction(String strKey) {
        return (CellPropAction)_keysMap.get(strKey);
    }

    protected CellPropAction(int intKey, String strKey) {
        this._intKey = intKey;
        this._strKey = strKey;
        _keysMap.put(strKey, this);
    }

    public int getIntKey() {
        return this._intKey;
    }

    public String getStringKey() {
        return this._strKey;
    }

    public abstract void action(Cell var1, Variant var2);

    protected void fontName(Cell cll, Variant value) {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
        sa.setFontName(value.toString());
        cll.setSSA(Styles.getSSA((StyleAttributes)sa));
    }

    protected void fontSize(Cell cll, Variant value) {
        if (value.isNumeric(value)) {
            try {
                int size = value.intValue();
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
                sa.setFontSize(size);
                cll.setSSA(Styles.getSSA((StyleAttributes)sa));
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
    }

    protected void fontColor(Cell cll, Variant value) {
        if (value.isNumeric(value)) {
            try {
                int color = value.intValue();
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
                sa.setFontColor(new Color(color));
                cll.setSSA(Styles.getSSA((StyleAttributes)sa));
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
    }

    protected void bkGround(Cell cll, Variant value) {
        if (value.isNumeric(value)) {
            try {
                int color = value.intValue();
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
                sa.setBackground(new Color(color));
                cll.setSSA(Styles.getSSA((StyleAttributes)sa));
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
    }

    protected void fontBold(Cell cll, Variant value) {
        try {
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
            sa.setBold(value.booleanValue());
            cll.setSSA(Styles.getSSA((StyleAttributes)sa));
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
    }

    protected void fontItalic(Cell cll, Variant value) {
        try {
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
            sa.setItalic(value.booleanValue());
            cll.setSSA(Styles.getSSA((StyleAttributes)sa));
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
    }

    protected void fontUnderline(Cell cll, Variant value) {
        try {
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
            sa.setUnderline(value.booleanValue());
            cll.setSSA(Styles.getSSA((StyleAttributes)sa));
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
    }

    protected void fontStrike(Cell cll, Variant value) {
        try {
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
            sa.setStrikeThrough(value.booleanValue());
            cll.setSSA(Styles.getSSA((StyleAttributes)sa));
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
    }

    protected void wrapText(Cell cll, Variant value) {
        try {
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
            sa.setWrapText(value.booleanValue());
            cll.setSSA(Styles.getSSA((StyleAttributes)sa));
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
    }

    protected void horzAlign(Cell cll, Variant value) {
        if (value.isNumeric(value)) {
            try {
                int align = value.intValue();
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
                sa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((int)align));
                cll.setSSA(Styles.getSSA((StyleAttributes)sa));
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
    }

    protected void vertAlign(Cell cll, Variant value) {
        if (value.isNumeric(value)) {
            try {
                int align = value.intValue();
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
                sa.setVerticalAlign(Styles.VerticalAlignment.getAlignment((int)align));
                cll.setSSA(Styles.getSSA((StyleAttributes)sa));
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
    }

    protected void breakRowCol(Cell cll, Variant value, boolean isRow) {
        try {
            int v;
            if (value.getVt() == 8) {
                if (!value.booleanValue()) {
                    return;
                }
                v = isRow ? cll.getRow() : cll.getCol();
            } else {
                v = value.intValue();
            }
            SheetPlugablePaginationAdvice ppa = (SheetPlugablePaginationAdvice)cll.getSheet().getPlugablePaginationAdvice(true);
            if (isRow) {
                ppa.getRowShrinkedBreakObjectArray().insert((Object)ObjectCache.getInteger((int)v));
            } else {
                ppa.getColShrinkedBreakObjectArray().insert((Object)ObjectCache.getInteger((int)v));
            }
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
    }

    protected void dispValue(Cell cll, Variant value) {
        cll.format(value, cll.getStyle().getNumberFormat());
        cll.setFlag(2, true);
    }

    protected void dispFormat(Cell cll, Variant value) {
        cll.format(cll.getValue(), value.toString());
        cll.setFlag(2, true);
    }

    protected void hyperLink(Cell cll, Variant value) {
        cll.getSheet().getRange(cll).setHyperLink((HyperLink)value.getValue());
    }

    protected void hideRowCol(Cell cll, Variant value, boolean bRow) {
        try {
            CellBlock cb;
            boolean hide = value.booleanValue();
            if (bRow) {
                int row = cll.getRow();
                cb = CellBlock.getNewCellBlock(row, 0, row, 16383);
            } else {
                int col = cll.getCol();
                cb = CellBlock.getNewCellBlock(0, col, 1048575, col);
            }
            Sheet sheet = cll.getSheet();
            SheetAction_AttributeSpan saa = new SheetAction_AttributeSpan(sheet.getRange(cb), null, null, hide, null, null, bRow);
            saa.actionBlock(null, sheet, cb);
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
    }
}

