/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.validate;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.Validate;
import com.kingdee.bos.ctrl.excel.model.util.IntArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import java.util.ArrayList;

public final class ValidationList {
    private static final SortedCellBlockArray compResult = new SortedCellBlockArray();
    private static final SortedCellBlockArray remainResult = new SortedCellBlockArray();
    private ArrayList _validations = new ArrayList();

    public ValidationList getClippedCopy(int left, int top, int right, int bottom) {
        ArrayList<Validation> clippedValidations = new ArrayList<Validation>();
        for (int i = 0; i < this._validations.size(); ++i) {
            Validation val = ((Validation)this._validations.get(i)).getClippedCopy(left, top, right, bottom);
            if (val == null) continue;
            clippedValidations.add(val);
        }
        if (clippedValidations.size() == 0) {
            return null;
        }
        ValidationList vl = new ValidationList();
        vl._validations = clippedValidations;
        return vl;
    }

    public ValidationList applyOffset(ValidationList clippedCopy, int offsetY, int offsetX) {
        if (clippedCopy == null) {
            return null;
        }
        ValidationList result = new ValidationList();
        ArrayList clippedValidations = clippedCopy._validations;
        for (int i = 0; i < clippedValidations.size(); ++i) {
            Validation validation = (Validation)clippedValidations.get(i);
            SortedCellBlockArray scba = validation.getBlocks();
            CellBlock cb = null;
            SortedCellBlockArray scba1 = new SortedCellBlockArray();
            for (int j = 0; j < scba.size(); ++j) {
                cb = (CellBlock)scba.getBlock(j).clone();
                cb.offset(offsetY, offsetX);
                scba1.insert(CellBlock.getNewCellBlock(cb));
            }
            result.insertValidation(validation.getMessagedValidate(), scba1);
        }
        return result;
    }

    public void merge(ValidationList clippedCopy, int offsetY, int offsetX) {
        if (clippedCopy == null) {
            return;
        }
        ArrayList clippedValidations = clippedCopy._validations;
        for (int i = 0; i < clippedValidations.size(); ++i) {
            Validation validation = (Validation)clippedValidations.get(i);
            SortedCellBlockArray scba = validation.getBlocks();
            CellBlock cb = null;
            SortedCellBlockArray scba1 = new SortedCellBlockArray();
            for (int j = 0; j < scba.size(); ++j) {
                cb = (CellBlock)scba.getBlock(j).clone();
                cb.offset(offsetY, offsetX);
                scba1.insert(CellBlock.getNewCellBlock(cb));
            }
            this.insertValidation(validation.getMessagedValidate(), scba1);
        }
    }

    public void remove(int top, int left) {
        for (int i = this._validations.size() - 1; i >= 0; --i) {
            SortedCellBlockArray scba = ((Validation)this._validations.get(i)).getBlocks();
            scba.trimToSize();
            for (int j = scba.size() - 1; j >= 0; --j) {
                CellBlock block = scba.getBlock(j);
                if (!block.isIntersect(top, left, top, left)) continue;
                SortedCellBlockArray result = new SortedCellBlockArray();
                CellBlock.getNewCellBlock(top, left, top, left).split(block, result);
                scba.remove(block);
                scba.addAll(result);
                scba.mergeSelf();
            }
        }
    }

    public int size() {
        return this._validations == null ? 0 : this._validations.size();
    }

    public Validation getValidation(int index) {
        return (Validation)this._validations.get(index);
    }

    public void clearAll() {
        this._validations.clear();
        compResult.clear();
        remainResult.clear();
    }

    public MessagedValidate getValidate(int row, int col) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Validation dv = this.getValidation(i);
            SortedCellBlockArray sa = dv.getBlocks();
            int vIndex = sa.searchBlockIndex(row, col);
            if (vIndex < 0) continue;
            MessagedValidate validate = dv.getMessagedValidate();
            validate.setOffsetMax(null);
            validate.setOffsetMin(null);
            return dv.getMessagedValidate();
        }
        return null;
    }

    public MessagedValidate getValidate(Sheet sheet, int row, int col) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Validation dv = this.getValidation(i);
            SortedCellBlockArray sa = dv.getBlocks();
            int vIndex = sa.searchBlockIndex(row, col);
            if (vIndex < 0) continue;
            MessagedValidate validate = dv.getMessagedValidate();
            SortedCellBlockArray blockArray = dv.getBlocks();
            CellBlock block = blockArray.getBlock(0);
            int offsetX = col - block.getCol();
            int offsetY = row - block.getRow();
            validate.setOffsetMin(SheetBaseMath.getShiftFormula(validate.getMin(), sheet, offsetX, offsetY));
            validate.setOffsetMax(SheetBaseMath.getShiftFormula(validate.getMax(), sheet, offsetX, offsetY));
            return validate;
        }
        return null;
    }

    public boolean isValided(Sheet sheet, int row, int col, String formula) {
        MessagedValidate mv = this.getValidate(sheet, row, col);
        if (mv == null) {
            return true;
        }
        return mv.isValidated(sheet, formula);
    }

    public void addValidation(Validation val) {
        this._validations.add(val);
    }

    private void insertValidation(MessagedValidate vm, SortedCellBlockArray sa, IntArray intersects) {
        int size = intersects.size();
        for (int i = 0; i < size; ++i) {
            Validation dv = this.getValidation(intersects.get(i));
            SortedCellBlockArray thisBlocks = dv.getBlocks();
            remainResult.clear();
            sa.split(thisBlocks, remainResult);
            thisBlocks.copyFrom(remainResult);
        }
        if (vm != null) {
            boolean insert = false;
            int size2 = this.size();
            for (int i = 0; i < size2; ++i) {
                Validation dv = this.getValidation(i);
                if (!vm.equals(dv.getMessagedValidate())) continue;
                SortedCellBlockArray thisBlocks = dv.getBlocks();
                thisBlocks.addAll(sa);
                insert = true;
            }
            if (!insert) {
                if (this._validations == null) {
                    this._validations = new ArrayList();
                }
                Validation dv = new Validation();
                dv.setBlocks(sa);
                dv.setMessagedValidate(vm);
                this._validations.add(dv);
            }
        }
        this.reduceImpl();
    }

    public void reduce() {
        this.reduceImpl();
    }

    private void reduceImpl() {
        for (int i = this.size() - 1; i >= 0; --i) {
            Validation dv = this.getValidation(i);
            SortedCellBlockArray thisBlocks = dv.getBlocks();
            if (thisBlocks.isEmpty()) {
                this._validations.remove(i);
                continue;
            }
            if (dv.getMessagedValidate() == null) {
                this._validations.remove(i);
                continue;
            }
            if (!this.isDefaultValue(dv.getMessagedValidate())) continue;
            this._validations.remove(i);
        }
    }

    private boolean isDefaultValue(MessagedValidate mv) {
        if (mv == null) {
            return true;
        }
        return !mv.isErrorHide() && StringUtil.isEmptyString((String)mv.getErrorMessage()) && StringUtil.isEmptyString((String)mv.getErrorTitle()) && !mv.isInputHide() && StringUtil.isEmptyString((String)mv.getInputMessage()) && StringUtil.isEmptyString((String)mv.getInputTitle()) && Validate.Type_ANY.equalsIgnoreCase(mv.getType());
    }

    public void insertValidation(MessagedValidate vm, SortedCellBlockArray sa) {
        IntArray intersects = new IntArray();
        this.calcIntersects(sa, intersects);
        this.insertValidation(vm, sa, intersects);
    }

    public boolean calcIntersects(SortedCellBlockArray sa, IntArray intersects) {
        int size = this.size();
        if (size <= 0) {
            return false;
        }
        compResult.copyFrom(sa);
        for (int i = 0; i < size; ++i) {
            Validation dv = this.getValidation(i);
            SortedCellBlockArray thisBlocks = dv.getBlocks();
            remainResult.clear();
            boolean split = thisBlocks.split(compResult, remainResult);
            if (split) {
                intersects.add(i);
            }
            if (remainResult.isEmpty()) {
                return true;
            }
            compResult.copyFrom(remainResult);
        }
        return false;
    }
}

