/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.border;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.border.Border;

public class ShadowPopupFactory
extends PopupFactory {
    private static Robot robot;
    static double[] gray_grade;
    static double[][] gray_matrix;
    private boolean shadowed;

    public ShadowPopupFactory(boolean shadowed) {
        this.shadowed = shadowed;
    }

    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        if (!this.shadowed) {
            return super.getPopup(owner, contents, x, y);
        }
        Dimension dim = contents.getPreferredSize();
        Rectangle bound = new Rectangle(x, y, dim.width + 4, dim.height + 4);
        BufferedImage backgroundImage = robot.createScreenCapture(bound);
        ShadowFrame frame = new ShadowFrame(contents, backgroundImage);
        return super.getPopup(owner, frame, x, y);
    }

    static {
        try {
            robot = new Robot();
        }
        catch (Exception exception) {
            // empty catch block
        }
        gray_grade = new double[]{0.5647058823529412, 0.6745098039215687, 0.8313725490196079, 0.9450980392156862};
        gray_matrix = new double[][]{{0.6078431372549019, 0.7058823529411765, 0.8509803921568627, 0.9490196078431372}, {0.7058823529411765, 0.7803921568627451, 0.8901960784313725, 0.9607843137254902}, {0.8509803921568627, 0.8901960784313725, 0.9450980392156862, 0.9803921568627451}, {0.9490196078431372, 0.9607843137254902, 0.9803921568627451, 0.9921568627450981}};
    }

    static interface Filter {
        public double filter(int var1, int var2, int var3);
    }

    class ShadowBorder
    implements Border {
        private BufferedImage rightImage;
        private BufferedImage bottomImage;
        private BufferedImage rightBottomImage;

        ShadowBorder(BufferedImage backgroundImage) {
            this.generateRightImage(backgroundImage);
            this.generateBottomImage(backgroundImage);
            this.generateRightBottomImage(backgroundImage);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.drawImage(this.rightImage, x + width - 4, y, c);
            g.drawImage(this.bottomImage, x, y + height - 4, c);
            g.drawImage(this.rightBottomImage, x + width - 4, y + height - 4, c);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 4, 4);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        private void generateBottomImage(BufferedImage backgroundImage) {
            int w = backgroundImage.getWidth();
            int h = backgroundImage.getHeight();
            this.bottomImage = backgroundImage.getSubimage(0, h - 4, w - 4, 4);
            this.shadowBottom();
        }

        private void generateRightBottomImage(BufferedImage backgroundImage) {
            int w = backgroundImage.getWidth();
            int h = backgroundImage.getHeight();
            this.rightBottomImage = backgroundImage.getSubimage(w - 4, h - 4, 4, 4);
            this.shadowRightBottom();
        }

        private void generateRightImage(BufferedImage backgroundImage) {
            int w = backgroundImage.getWidth();
            int h = backgroundImage.getHeight();
            this.rightImage = backgroundImage.getSubimage(w - 4, 0, 4, h - 4);
            this.shadowRight();
        }

        private void shadowBottom() {
            this.filterImage(this.bottomImage, new Filter(){

                @Override
                public double filter(int x, int y, int rgb) {
                    if (x < 4) {
                        return 1.0;
                    }
                    if (x < 8) {
                        return gray_matrix[7 - x][y];
                    }
                    return gray_grade[y];
                }
            });
        }

        private void shadowRight() {
            this.filterImage(this.rightImage, new Filter(){

                @Override
                public double filter(int x, int y, int rgb) {
                    if (y < 4) {
                        return 1.0;
                    }
                    if (y < 8) {
                        return gray_matrix[x][7 - y];
                    }
                    return gray_grade[x];
                }
            });
        }

        private void shadowRightBottom() {
            this.filterImage(this.rightBottomImage, new Filter(){

                @Override
                public double filter(int x, int y, int rgb) {
                    return gray_matrix[x][y];
                }
            });
        }

        private int gradeRGB(int rgb, double grade) {
            int a = rgb & 0xFF000000;
            int r = (rgb & 0xFF0000) >> 16;
            int g = (rgb & 0xFF00) >> 8;
            int b = rgb & 0xFF;
            r = (int)(grade * (double)r) << 16;
            g = (int)(grade * (double)g) << 8;
            b = (int)(grade * (double)b);
            return a | r | g | b;
        }

        private void filterImage(BufferedImage image, Filter filter) {
            int w = image.getWidth();
            int h = image.getHeight();
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int rgb = image.getRGB(x, y);
                    double grade = filter.filter(x, y, rgb);
                    rgb = this.gradeRGB(rgb, grade);
                    image.setRGB(x, y, rgb);
                }
            }
        }
    }

    class ShadowFrame
    extends JComponent {
        public ShadowFrame(Component content, BufferedImage backgroundImage) {
            this.setLayout(new BorderLayout());
            this.add(content, "Center");
            ShadowBorder border = new ShadowBorder(backgroundImage);
            this.setBorder(border);
        }
    }
}

