/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.eas.common.PrintConfigFacadeFactory;
import com.kingdee.eas.common.client.SysContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;

public class NoteUserConfig {
    private static Logger log = LogUtil.getPackageLogger(NoteUserConfig.class);
    private static final String FILENAME = "NoteUserConfig.xml";
    private static final String TAG_ROOT = "UserConfig";
    private static final String TAG_USER = "User";
    private static final String TAG_DEFAULT = "DefaultTemplate";
    private static final String ATT_NAME = "name";
    private static final String ATT_ORGFILTER = "orgFilter";
    private HashMap _mapDefaultTemplate;
    private boolean _isDirty = false;

    public NoteUserConfig(Element root, String dirPathText) {
        this.fromXml(root, dirPathText);
    }

    private void fromXml(Element root, String dirPathText) {
        this._mapDefaultTemplate = new HashMap();
        LinkedHashMap<String, Boolean> isOrgFilters = new LinkedHashMap<String, Boolean>();
        if (root != null) {
            try {
                for (Element userNode : root.getChildren(TAG_USER)) {
                    String orgUser = userNode.getAttributeValue(ATT_NAME);
                    if (StringUtil.isEmptyString((String)orgUser)) continue;
                    String strOrgFilter = userNode.getAttributeValue(ATT_ORGFILTER);
                    boolean isOrgFilter = Boolean.parseBoolean(strOrgFilter);
                    isOrgFilters.put(orgUser, isOrgFilter);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            String orgUser = NoteUtil.getCurrentOrgUnitId() + " " + NoteUtil.getUser();
            String defaultTemplate = PrintConfigFacadeFactory.getRemoteInstance().getDefaultTemplate(orgUser, dirPathText);
            if (!StringUtil.isEmptyString((String)defaultTemplate)) {
                Info info = new Info();
                info.defaultTemplate = defaultTemplate;
                info.isOrgFilter = isOrgFilters.get(orgUser) == null ? false : (Boolean)isOrgFilters.get(orgUser);
                this._mapDefaultTemplate.put(orgUser, info);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private Element toXml() {
        Element root = new Element(TAG_ROOT);
        for (String key : this._mapDefaultTemplate.keySet()) {
            Element nodeUser = new Element(TAG_USER);
            nodeUser.setAttribute(ATT_NAME, key);
            Info info = (Info)this._mapDefaultTemplate.get(key);
            if (info.isOrgFilter) {
                nodeUser.setAttribute(ATT_ORGFILTER, "true");
            }
            Element nodeDef = new Element(TAG_DEFAULT);
            nodeDef.addContent(info.defaultTemplate);
            nodeUser.addContent((Content)nodeDef);
            root.addContent((Content)nodeUser);
        }
        return root;
    }

    private Info getInfo(String user) {
        return (Info)this._mapDefaultTemplate.get(user);
    }

    private Info getNotNullInfo(String user) {
        Info info = this.getInfo(user);
        if (info == null) {
            info = new Info();
            this._mapDefaultTemplate.put(user, info);
        }
        return info;
    }

    private void syncExistable(String user) {
        Info info = this.getInfo(user);
        if (info == null) {
            return;
        }
        if (!StringUtil.isEmptyString((String)info.defaultTemplate)) {
            return;
        }
        if (info.isOrgFilter) {
            this._mapDefaultTemplate.remove(user);
            return;
        }
        this._mapDefaultTemplate.remove(user);
    }

    public String getDefaultTemplateName(String user) {
        Info info = this.getInfo(user);
        return info == null ? null : NoteUserConfig.cnulls(info.defaultTemplate);
    }

    public static String cnulls(String str) {
        if (str == null || "null".equals(str)) {
            return "";
        }
        return str;
    }

    public void putDefaultTemplateName(String user, String defaultTemplateName) {
        Info info = this.getNotNullInfo(user);
        info.defaultTemplate = defaultTemplateName;
        this.syncExistable(user);
        this._isDirty = true;
    }

    public void removeDefaultTemplateName(String user) {
        Info info = this.getInfo(user);
        if (info != null) {
            info.defaultTemplate = null;
            this.syncExistable(user);
            this._isDirty = true;
        }
    }

    public boolean isOrgFilter(String user) {
        Info info = this.getInfo(user);
        return info == null ? false : info.isOrgFilter;
    }

    public void putOrgFilter(String user, boolean isOrgFilter) {
        Info info = this.getNotNullInfo(user);
        info.isOrgFilter = isOrgFilter;
        this.syncExistable(user);
        this._isDirty = true;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public static NoteUserConfig load(IBizStorage sto, String dirPathText) {
        Element root = null;
        try {
            byte[] bs = BizStorageUtil.readFile((IBizStorage)sto, (String)PathUtil.makeChildPath((String)dirPathText, (String)FILENAME));
            root = XmlUtil.loadXmlBytes((byte[])bs);
        }
        catch (NotFoundException ex1) {
            log.debug((Object)("\u8be5\u8def\u5f84\u4e0b\u7684\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8fd9\u662f\u9884\u671f\u7684\u5f02\u5e38\u3002" + dirPathText));
        }
        catch (Exception ex) {
            log.error((Object)"\u8bfb\u53d6\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)ex);
        }
        return new NoteUserConfig(root, dirPathText);
    }

    public static void save(IBizStorage sto, String dirPathText, NoteUserConfig config) {
        try {
            if (config._mapDefaultTemplate.size() > 0) {
                for (Map.Entry entry : config._mapDefaultTemplate.entrySet()) {
                    String orgUser = (String)entry.getKey();
                    Info info = (Info)entry.getValue();
                    String defaultTemplate = info.defaultTemplate;
                    PrintConfigFacadeFactory.getRemoteInstance().setDefalutTemplate(orgUser, dirPathText, defaultTemplate);
                }
            } else {
                String orgUser = SysContext.getSysContext().getCurrentOrgUnit().getId().toString() + " " + SysContext.getSysContext().getUserName();
                PrintConfigFacadeFactory.getRemoteInstance().deleteDefaultTemplate(orgUser, dirPathText);
            }
            Element root = config.toXml();
            byte[] bs = XmlUtil.saveXmlBytes((Element)root);
            String configPathText = PathUtil.makeChildPath((String)dirPathText, (String)FILENAME);
            if (!sto.isExist(configPathText)) {
                BizStorageUtil.create((IBizStorage)sto, (String)configPathText, (HashMap)BizStorageUtil.SET_FILE_TYPE);
            }
            sto.writeFile(configPathText, -1, bs);
            log.debug((Object)("\u4fdd\u5b58\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u6210\u529f\uff1a\u7f13\u5b58\u8def\u5f84/" + configPathText));
        }
        catch (Exception ex) {
            log.error((Object)"\u4fdd\u5b58\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)ex);
        }
        config._isDirty = false;
    }

    private static class Info {
        private String defaultTemplate;
        private boolean isOrgFilter;

        private Info() {
        }
    }
}

