/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.multilanguage;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class Language {
    private static final Logger log = LogUtil.getPackageLogger(Language.class);
    private String name;
    private String alias;
    public static Language zh_CN;
    public static Language zh_TW;
    public static Language EN;
    public static Language[] SUPPORT_LANGUAGES;
    private static HashMap language;

    public static void initLanguage() {
        zh_CN = new Language("zh_CN", MultiLanguageUtil.getMLS("multilanguage.Language.zh_cn"));
        zh_TW = new Language("zh_TW", MultiLanguageUtil.getMLS("multilanguage.Language.zh_tw"));
        EN = new Language("en", MultiLanguageUtil.getMLS("multilanguage.Language.en"));
        SUPPORT_LANGUAGES = new Language[]{zh_CN, zh_TW, EN};
        language.clear();
        language.put("zh_CN", zh_CN);
        language.put("zh_TW", zh_TW);
        language.put("en", EN);
    }

    public Language(String name, String alias) {
        this.name = name;
        this.alias = alias;
    }

    private static Language getStoreLanguage(String key) {
        if (language.get(key) == null) {
            return null;
        }
        return (Language)language.get(key);
    }

    public String toString() {
        return this.getAlias();
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equal(Object lang) {
        if (!(lang instanceof Language)) {
            return false;
        }
        return this.getName().equalsIgnoreCase(((Language)lang).getName());
    }

    public static Language locale2Language(Locale locale) {
        String l = locale.getLanguage().toLowerCase();
        String c = locale.getCountry().toUpperCase();
        String v = locale.getVariant().toLowerCase();
        if (Language.getStoreLanguage(l + "_" + c + "_" + v) != null) {
            return Language.getStoreLanguage(l + "_" + c + "_" + v);
        }
        if (Language.getStoreLanguage(l + "_" + c) != null) {
            return Language.getStoreLanguage(l + "_" + c);
        }
        if (Language.getStoreLanguage(l) != null) {
            return Language.getStoreLanguage(l);
        }
        log.info((Object)("R1-Print\u4e0d\u652f\u6301\u8bed\u8a00\uff1a" + locale.toString()));
        return null;
    }

    public static Language createLanguage(String language) {
        String[] l = language.split("_");
        Locale locale = l.length == 3 ? new Locale(l[0], l[1], l[2]) : (l.length == 2 ? new Locale(l[0], l[1]) : new Locale(l[0]));
        return Language.locale2Language(locale);
    }

    public static Language readTempLang(String tempName) {
        int index;
        String[] templateName = tempName.split("\\.");
        Language language = zh_CN;
        if (StringUtil.isEmptyString((String)templateName[0])) {
            return language;
        }
        if (']' == templateName[0].charAt(templateName[0].length() - 1) && (index = templateName[0].lastIndexOf("[")) != -1) {
            String locale = templateName[0].substring(index + 1, templateName[0].length() - 1);
            Language fileLang = Language.createLanguage(locale);
            language = fileLang == null ? language : fileLang;
        }
        return language;
    }

    static {
        language = new HashMap();
    }
}

