/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.util;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDistributionUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserRoleOrgManagerFactory;
import com.kingdee.eas.common.client.SysContext;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class NoteUseUtil {
    public static final String USE_ENABLED_USERS = "user_enabled_users";
    public static final String USE_ENABLED_ROLES = "user_enabled_roles";

    private static HashMap getMapAttr(IBizContent bizCtn, String absPathText) throws KDRSException {
        HashMap attrs = bizCtn.getAttributes(absPathText, new String[]{USE_ENABLED_USERS});
        return attrs;
    }

    private static String getStringAttr(HashMap attrs) {
        String strUsers = (String)attrs.get(USE_ENABLED_USERS);
        return strUsers;
    }

    public static void modifyAttr(NoteTreeCtrl noteTreeCtrl, String absPathText, String[] targetUsers, boolean isToAdd) throws KDRSException {
        IBizContent bizCtn = noteTreeCtrl.getBizContent();
        HashMap attrs = NoteUseUtil.getMapAttr(bizCtn, absPathText);
        String strUsers = NoteUseUtil.getStringAttr(attrs);
        HashSet<String> sets = new HashSet<String>();
        if (!CtrlUtil.Str.isEmptyString((String)strUsers)) {
            String[] users = CtrlUtil.Str.splitString((String)strUsers, (String)",");
            for (int i = 0; i < users.length; ++i) {
                sets.add(users[i]);
            }
        }
        for (int i = 0; i < targetUsers.length; ++i) {
            if (isToAdd) {
                if (StringUtil.isEmptyString((String)targetUsers[i])) continue;
                sets.add(targetUsers[i]);
                continue;
            }
            sets.remove(targetUsers[i]);
        }
        Object[] users = new String[sets.size()];
        sets.toArray(users);
        strUsers = CtrlUtil.Array.objectArray2String((Object[])users, (String)",");
        attrs.put(USE_ENABLED_USERS, strUsers);
        bizCtn.setAttributes(absPathText, attrs);
    }

    public static String getStringAttr(IBizContent bizCtn, String absPathText) throws KDRSException {
        HashMap attrs = NoteUseUtil.getMapAttr(bizCtn, absPathText);
        return NoteUseUtil.getStringAttr(attrs);
    }

    public static void removeDistributed(NoteTreeCtrl noteTreeCtrl, String absPathText, String targetUser) throws KDRSException {
        NoteUseUtil.modifyAttr(noteTreeCtrl, absPathText, targetUser, false);
    }

    public static void removeAllDistributed(NoteTreeCtrl noteTreeCtrl, String absPathText) throws KDRSException {
        IBizContent bizCtn = noteTreeCtrl.getBizContent();
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put(USE_ENABLED_USERS, null);
        bizCtn.setAttributes(absPathText, attrs);
    }

    private static void modifyAttr(NoteTreeCtrl noteTreeCtrl, String absPathText, String targetUser, boolean isToAdd) throws KDRSException {
        NoteUseUtil.modifyAttr(noteTreeCtrl, absPathText, new String[]{targetUser}, isToAdd);
    }

    public static boolean isCanUse(IBizContent bizCtn, String absPathText) throws KDRSException {
        Set usersSet;
        HashMap attrs = bizCtn.getAttributes(absPathText, new String[]{USE_ENABLED_USERS, USE_ENABLED_ROLES});
        String currentUser = NoteUtil.getUser();
        String users = (String)attrs.get(USE_ENABLED_USERS);
        String roles = (String)attrs.get(USE_ENABLED_ROLES);
        if (StringUtil.isEmptyString((String)users) && StringUtil.isEmptyString((String)roles)) {
            return true;
        }
        if (!StringUtil.isEmptyString((String)users) && (usersSet = NoteDistributionUtil.usersStr2Set(users)).contains(currentUser)) {
            return true;
        }
        if (!StringUtil.isEmptyString((String)roles)) {
            Set rolesSet = NoteDistributionUtil.usersStr2Set(roles);
            RoleCollection allUserRole = null;
            try {
                BOSUuid userId = SysContext.getSysContext().getCurrentUserInfo().getId();
                allUserRole = UserRoleOrgManagerFactory.getRemoteInstance().getAllUserRole((IObjectPK)new ObjectUuidPK(userId));
            }
            catch (Exception e) {
                throw KDRSException.makeException((String)e.getMessage(), (Throwable)e);
            }
            for (int i = 0; i < allUserRole.size(); ++i) {
                RoleInfo roleInfo = allUserRole.get(i);
                String roleId = roleInfo.getId().toString();
                if (!roles.contains(roleId)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCanPrint(Component parentCtrl, IBizContent bizCtn, String templatePath) throws KDRSException {
        String absDir = PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)templatePath);
        if (!NoteUseUtil.isCanUse(bizCtn, absDir)) {
            HashMap attrs = bizCtn.getAttributes(absDir, new String[]{"alias", "name"});
            String alias = (String)attrs.get("alias");
            String templatName = (String)attrs.get("name");
            if (!StringUtil.isEmptyString((String)alias)) {
                templatName = alias + "\uff08" + templatName + "\uff09";
            }
            WindowUtil.msgboxWarning((Object)(MultiLanguageUtil.getMLS("util.NoteUseUtil.cantPrintInfo1") + templatName + MultiLanguageUtil.getMLS("util.NoteUseUtil.cantPrintInfo2") + StringUtil.RETURN + MultiLanguageUtil.getMLS("util.NoteUseUtil.cantPrintInfo3")), (String)MultiLanguageUtil.getMLS("util.NoteUseUtil.title"), (Component)parentCtrl);
            return false;
        }
        return true;
    }
}

