/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note.dynquery.ui;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.bosmetaselector.BosQuerySelector;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.exception.NoteDynQuery_MainQueryParseException;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryModel;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.ui.EntityTabbedUI;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.ui.FieldTabbedUI;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

class NoteDynQueryEditor {
    private static final Logger log = LogUtil.getPackageLogger(NoteDynQueryEditor.class);
    private KDPanel _panelAll;
    private KDPromptBox _f7MainQueryName;
    private KDTextField _txtMainQueryPK;
    private KDTabbedPane _tabbedPane;
    private EntityTabbedUI _tabbedUIEntity;
    private FieldTabbedUI _tabbedUIField;
    private NoteDynQueryModel _model;

    public NoteDynQueryEditor() {
        this.init();
    }

    private void init() {
        this._panelAll = new KDPanel();
        this._f7MainQueryName = new KDPromptBox();
        this._txtMainQueryPK = new KDTextField();
        this._tabbedPane = new KDTabbedPane();
        this._tabbedUIEntity = new EntityTabbedUI();
        this._tabbedUIField = new FieldTabbedUI();
        this._f7MainQueryName.setEditable(false);
        this._f7MainQueryName.setSelector(new BosQuerySelector().createF7Selector((JComponent)this._panelAll));
        this._txtMainQueryPK.setEnabled(false);
        this._tabbedPane.addTab(MultiLanguageUtil.getMLS("ui.NoteDynQueryEditor.entity"), (Component)this._tabbedUIEntity.getUI());
        this._tabbedPane.addTab(MultiLanguageUtil.getMLS("ui.NoteDynQueryEditor.field"), (Component)this._tabbedUIField.getUI());
        KDLabelContainer lbcMainQueryName = CtrlSwingUtilities.createLabelContainer((JComponent)this._f7MainQueryName, (String)MultiLanguageUtil.getMLS("ui.NoteDynQueryEditor.mainQueryName"), (int)120);
        KDLabelContainer lbcMainQueryPK = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtMainQueryPK, (String)MultiLanguageUtil.getMLS("ui.NoteDynQueryEditor.mainQueryPath"), (int)120);
        this._f7MainQueryName.addDataChangeListener((DataChangeListener)new MainQueryF7Handler());
        this._tabbedUIEntity.setTabbedSynchronizer(new EntityTabbedSynchronizer());
        this._tabbedUIField.setTabbedSynchronizer(new FieldTabbedSynchronizer());
        TableLayout tl = TableLayout.splitRow((int)3);
        tl.rowStyle(0).setHeight(20);
        tl.rowStyle(0).setMarginBottom(3);
        tl.rowStyle(1).setHeight(20);
        tl.rowStyle(1).setMarginBottom(20);
        tl.rowStyle(2).setPriY(1);
        this._panelAll.setLayout((LayoutManager)tl);
        this._panelAll.add((Component)lbcMainQueryName, (Object)tl.cell(0));
        this._panelAll.add((Component)lbcMainQueryPK, (Object)tl.cell(1));
        this._panelAll.add((Component)this._tabbedPane, (Object)tl.cell(2));
    }

    public JComponent getCtrl() {
        return this._panelAll;
    }

    public void setModel(NoteDynQueryModel model) {
        this._model = model;
        this.updateCtrl();
        this._f7MainQueryName.setText(this._model.getMainQuery().getAlias());
    }

    public NoteDynQueryModel getModel() {
        this._tabbedUIField.updateModel_OrderBy(this._model);
        return this._model;
    }

    private void updateCtrl() {
        this._txtMainQueryPK.setText(this._model == null ? null : this._model.getMainQueryPath());
        this._tabbedUIEntity.updateCtrl(this._model);
        this._tabbedUIField.updateCtrl(this._model);
    }

    public boolean verify() {
        return this._model != null;
    }

    private class FieldTabbedSynchronizer
    implements ITabbedSynchronizer {
        private FieldTabbedSynchronizer() {
        }

        @Override
        public void announce(Map params) {
            Object v = params.get("type");
            NoteDynQueryEditor.this._tabbedUIField;
            if (v == FieldTabbedUI.ORDER) {
                NoteDynQueryEditor.this._tabbedUIField.updateModel_OrderBy(NoteDynQueryEditor.this._model);
            }
            Object v2 = params.get("type");
            NoteDynQueryEditor.this._tabbedUIField;
            if (v2 == FieldTabbedUI.RENAME) {
                NoteDynQueryEditor.this._tabbedUIField.updateModel_RenameField(NoteDynQueryEditor.this._model);
            }
        }
    }

    private class EntityTabbedSynchronizer
    implements ITabbedSynchronizer {
        private EntityTabbedSynchronizer() {
        }

        @Override
        public void announce(Map params) {
            NoteDynQueryEditor.this._tabbedUIField.updateCtrl(NoteDynQueryEditor.this._model);
        }
    }

    static interface ITabbedSynchronizer {
        public void announce(Map var1);
    }

    private class MainQueryF7Handler
    implements DataChangeListener {
        private MainQueryF7Handler() {
        }

        public void dataChanged(DataChangeEvent e) {
            if (e.getNewValue() instanceof String) {
                return;
            }
            BosQuerySelector.ReturnValueWrapper info = (BosQuerySelector.ReturnValueWrapper)e.getNewValue();
            if (info != null && info.fullName != null) {
                String mainQueryPath = info.fullName;
                try {
                    NoteDynQueryEditor.this._model = new NoteDynQueryModel(mainQueryPath);
                }
                catch (NoteDynQuery_MainQueryParseException ex) {
                    log.error((Object)"", (Throwable)ex);
                    WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("ui.NoteDynQueryEditor.selectMainQueryError"), (String)MultiLanguageUtil.getMLS("ui.NoteDynQueryEditor.selectMainQuery"), (Component)NoteDynQueryEditor.this._panelAll);
                }
            } else {
                NoteDynQueryEditor.this._model = null;
            }
            NoteDynQueryEditor.this.updateCtrl();
        }
    }
}

