/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note.specialdata.provider;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.IAttachmentManagerFacade;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;

public class AttachmentDataProvider
extends AbstractPrintDataProvider {
    private String billId;
    private final String[] supports = new String[]{"jpg", "jpeg", "bmp", "png", "pdf"};

    public AttachmentDataProvider(String billId) {
        this.billId = billId;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        Object acm = ConfigMDUtil.isClient() ? AttachmentManagerFactory.getClientManager() : AttachmentManagerFactory.getServerManager((Context)ConfigMDUtil.getContext());
        Object[] strsStrings = acm.getAttachmentIDsByBoBOSType(this.billId);
        if (dataSource.getSortFields().length > 0 && strsStrings.length > 0) {
            SorterItemCollection sorts = new SorterItemCollection();
            for (R1PrintDataSortItem sortItem : dataSource.getSortFields()) {
                SorterItemInfo info = new SorterItemInfo(sortItem.getSortField());
                if (sortItem.getSortType() == 1) {
                    info.setSortType(SortType.DESCEND);
                } else {
                    info.setSortType(SortType.ASCEND);
                }
                sorts.add(info);
            }
            IQueryExecutor executor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.base.attachment.app.AttachmentQuery"));
            executor.option().isIgnoreOrder = true;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            ev.setFilter(filter);
            ev.setSorter(sorts);
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(Arrays.asList((Object[])strsStrings)), CompareType.INCLUDE));
            executor.setObjectView(ev);
            IRowSet rowSet = executor.executeQuery();
            ArrayList<String> ids = new ArrayList<String>();
            while (rowSet.next()) {
                ids.add(rowSet.getString("id"));
            }
            strsStrings = ids.toArray(new String[ids.size()]);
        }
        DynamicRowSet drs = this.getDynamicRowSet();
        IAttachmentManagerFacade instance = AttachmentManagerFacadeFactory.getRemoteInstance();
        drs.beforeFirst();
        ComplexAttachmentInfo info = null;
        for (String string : strsStrings) {
            info = acm.getComplexAttachmentInfo(string);
            if (this.isPdf(info.getExtName())) {
                byte[] pdf = instance.downLoad(string);
                List<byte[]> pages = this.splitPdf(pdf);
                for (byte[] page : pages) {
                    drs.moveToInsertRow();
                    this.fillData(drs, info, page);
                    drs.insertRow();
                }
                continue;
            }
            drs.moveToInsertRow();
            this.fillData(drs, info, instance.downLoad(string));
            drs.insertRow();
        }
        drs.beforeFirst();
        return drs;
    }

    private void fillData(DynamicRowSet drs, ComplexAttachmentInfo info, byte[] content) throws SQLException {
        drs.updateBytes("id", content);
        drs.updateString("name", info.getMainName());
        drs.updateString("simpleName", info.getExtName());
        drs.updateString("type", info.getTypeDesc());
        drs.updateInt("isShared", info.getIsShared() ? 1 : 0);
        drs.updateString("description", info.getDescription());
        drs.updateString("size", info.getSizeDesc());
        drs.updateInt("sizeInByte", info.getSizeInByte());
        drs.updateString("lastUpdateUser.name", info.getUpdatorName());
        drs.updateString("createTime", info.getCreateTime());
    }

    private DynamicRowSet getDynamicRowSet() throws SQLException {
        DynamicRowSet drs = new DynamicRowSet(10);
        String[] columnNames = new String[]{"id", "name", "simpleName", "type", "isShared", "description", "size", "sizeInByte", "lastUpdateUser.name", "createTime"};
        for (int i = 0; i < 10; ++i) {
            ColInfo ci = new ColInfo();
            ci.colType = i == 0 ? -2 : (i == 4 || i == 7 ? 4 : 12);
            ci.columnName = columnNames[i];
            ci.nullable = 1;
            drs.setColInfo(i + 1, ci);
        }
        return drs;
    }

    private boolean support(String extName) {
        for (String str : this.supports) {
            if (!str.equalsIgnoreCase(extName)) continue;
            return true;
        }
        return false;
    }

    private boolean isPdf(String extName) {
        return "pdf".equalsIgnoreCase(extName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<byte[]> splitPdf(byte[] pdf) {
        ArrayList<byte[]> newPdfList = new ArrayList<byte[]>();
        ByteArrayInputStream in = new ByteArrayInputStream(pdf);
        PDDocument document = null;
        try {
            document = PDDocument.load((InputStream)in);
            Splitter splitter = new Splitter();
            List pages = splitter.split(document);
            for (PDDocument next : pages) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                next.save((OutputStream)output);
                newPdfList.add(output.toByteArray());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return newPdfList;
    }
}

