/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.base;

import com.kingdee.bos.olap.Cell;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.mdx.MdxAxis;
import com.kingdee.bos.olap.mdx.MdxMember;
import com.kingdee.bos.olap.mdx.MdxPosition;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.MdxResult;
import java.io.PrintWriter;

public abstract class MdxResultBase
implements MdxResult {
    protected final transient MdxQuery query;
    protected final MdxAxis[] axes;
    protected MdxAxis slicerAxis;
    private MdxResult.ResultOverflowInfo overflowInfo;

    protected MdxResultBase(MdxQuery query, MdxAxis[] axes) {
        this.query = query;
        this.axes = axes;
    }

    @Override
    public MdxQuery getQuery() {
        return this.query;
    }

    @Override
    public MdxAxis[] getAxes() {
        return this.axes;
    }

    @Override
    public MdxAxis getSlicerAxis() {
        return this.slicerAxis;
    }

    @Override
    public void close() {
    }

    @Override
    public MdxResult.ResultOverflowInfo getOverflowInfo() {
        if (this.overflowInfo == null) {
            this.overflowInfo = new MdxResult.ResultOverflowInfo();
        }
        return this.overflowInfo;
    }

    public MdxMember getMember(int[] pos, Dimension dimension) {
        for (int i = -1; i < this.axes.length; ++i) {
            MdxAxis axis = this.slicerAxis;
            int index = 0;
            if (i >= 0) {
                axis = this.axes[i];
                index = pos[i];
            }
            MdxPosition position = axis.positions[index];
            MdxMember[] mdxMembers = position.getMdxMembers();
            for (int j = 0; j < mdxMembers.length; ++j) {
                MdxMember member = mdxMembers[j];
                if (!member.getDimUniqueName().equals(dimension.getUniqueName())) continue;
                return member;
            }
        }
        return null;
    }

    public void print(PrintWriter pw) {
        for (int i = -1; i < this.axes.length; ++i) {
            pw.println("Axis #" + (i + 1) + ":");
            this.printAxis(pw, i < 0 ? this.slicerAxis : this.axes[i]);
        }
        int[] pos = new int[this.axes.length];
        this.printRows(pw, this.axes.length - 1, pos);
    }

    private void printRows(PrintWriter pw, int axis, int[] pos) {
        MdxAxis _axis = axis < 0 ? this.slicerAxis : this.axes[axis];
        int count = _axis.positions.length;
        for (int i = 0; i < count; ++i) {
            if (axis < 0) {
                if (i > 0) {
                    pw.print(", ");
                }
                this.printCell(pw, pos);
                continue;
            }
            pos[axis] = i;
            if (axis == 0) {
                int row = axis + 1 < pos.length ? pos[axis + 1] : 0;
                pw.print("Row #" + row + ": ");
            }
            this.printRows(pw, axis - 1, pos);
            if (axis != 0) continue;
            pw.println();
        }
    }

    private void printAxis(PrintWriter pw, MdxAxis axis) {
        MdxPosition[] positions = axis.positions();
        for (int i = 0; i < positions.length; ++i) {
            MdxPosition position = positions[i];
            pw.print("{");
            MdxMember[] members = position.getMdxMembers();
            for (int j = 0; j < members.length; ++j) {
                MdxMember member = members[j];
                if (j > 0) {
                    pw.print(", ");
                }
                pw.print(member.getUniqueName());
            }
            pw.println("}");
        }
    }

    private void printCell(PrintWriter pw, int[] pos) {
        Cell cell = this.getCell(pos);
        pw.print(cell.getFormattedValue());
    }
}

