/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx;

import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.ExpBase;
import com.kingdee.bos.olap.mdx.ExpResolver;
import com.kingdee.bos.olap.mdx.FunTable;
import com.kingdee.bos.olap.mdx.Literal;
import com.kingdee.bos.olap.mdx.SchemaLookup;
import com.kingdee.bos.olap.mdx.type.Type;
import java.io.Serializable;
import java.util.ArrayList;

public class CompoundId
extends ExpBase {
    private static final long serialVersionUID = 1090901463536428209L;
    private ArrayList names = new ArrayList();

    public CompoundId(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
    }

    public CompoundId(String name) {
        this(name, false);
    }

    public void append(String name, boolean isKey) {
        this.names.add(new NamePart(name, isKey));
    }

    public void append(String name) {
        this.names.add(new NamePart(name, false));
    }

    public String[] toStringArray() {
        String[] ret = new String[this.names.size()];
        int i = 0;
        for (NamePart np : this.names) {
            ret[i++] = np.name;
        }
        return ret;
    }

    private CompoundId() {
    }

    @Override
    public Object clone() {
        CompoundId cloned = new CompoundId();
        for (NamePart np : this.names) {
            cloned.append(np.name, np.isKey);
        }
        return cloned;
    }

    @Override
    public int getCategory() {
        return 0;
    }

    @Override
    public Exp resolve(ExpResolver resolver) throws OLAPException {
        String s;
        if (this.names.size() == 1 && FunTable.instance.isReserved(s = ((NamePart)this.names.get(0)).name)) {
            if (s.equalsIgnoreCase("NULL")) {
                return Literal.createNull();
            }
            return Literal.createSymbol(s.toUpperCase());
        }
        OLAPElement e = SchemaLookup.lookup(resolver.getQuery(), this.toStringArray());
        return SchemaLookup.createExpr(e);
    }

    @Override
    public Type getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unparse(StringBuffer sb) {
        boolean isFollow = false;
        for (NamePart np : this.names) {
            if (isFollow) {
                sb.append(".");
            }
            isFollow = true;
            if (np.isKey) {
                sb.append("&");
            }
            sb.append("[").append(np.name).append("]");
        }
    }

    private class NamePart
    implements Serializable {
        private static final long serialVersionUID = -7887871473708983625L;
        private String name;
        private boolean isKey;

        protected NamePart(String name, boolean isKey) {
            name = name.trim();
            if (isKey) {
                name = name.substring(1, name.length());
            }
            if (name.startsWith("[")) {
                name = name.substring(1, name.length() - 1);
            }
            this.name = name;
            this.isKey = isKey;
        }
    }
}

