/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.calc.impl;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.ExpResolver;
import com.kingdee.bos.olap.mdx.calc.BigDecimalCalc;
import com.kingdee.bos.olap.mdx.calc.BooleanCalc;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.DoubleCalc;
import com.kingdee.bos.olap.mdx.calc.IntegerCalc;
import com.kingdee.bos.olap.mdx.calc.NumberCalc;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractBigDecimalCalc;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractDoubleCalc;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractExpCompiler;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractIntegerCalc;
import java.math.BigDecimal;

public class BetterScalarExpCompiler
extends AbstractExpCompiler {
    public BetterScalarExpCompiler(ExpResolver resolver) {
        super(resolver);
    }

    @Override
    public BigDecimalCalc compileBigDecimal(Exp exp) throws OLAPException {
        final Calc calc = this.compileScalar(exp, false);
        if (calc instanceof BigDecimalCalc) {
            return (BigDecimalCalc)calc;
        }
        if (calc instanceof DoubleCalc) {
            final DoubleCalc doubleCalc = (DoubleCalc)calc;
            return new AbstractBigDecimalCalc(exp, new Calc[]{doubleCalc}){

                @Override
                public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OLAPException {
                    double result = doubleCalc.evaluateDouble(evaluator);
                    return new BigDecimal(result);
                }
            };
        }
        if (calc instanceof IntegerCalc) {
            final IntegerCalc integerCalc = (IntegerCalc)calc;
            return new AbstractBigDecimalCalc(exp, new Calc[]{integerCalc}){

                @Override
                public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OLAPException {
                    int result = integerCalc.evaluateInteger(evaluator);
                    return new BigDecimal((double)result);
                }
            };
        }
        return new AbstractBigDecimalCalc(exp, new Calc[]{calc}){

            @Override
            public BigDecimal evaluateBigDecimal(Evaluator evaluator) throws OLAPException {
                Object o = calc.evaluate(evaluator);
                if (o == null) {
                    return null;
                }
                if (o instanceof BigDecimal) {
                    return (BigDecimal)o;
                }
                if (o instanceof Number) {
                    return new BigDecimal(((Number)o).doubleValue());
                }
                throw new OLAPException("cannot cast " + this.exp.toMdx() + " to Number.");
            }
        };
    }

    @Override
    public DoubleCalc compileDouble(Exp exp) throws OLAPException {
        Calc calc = this.compileScalar(exp, false);
        if (calc instanceof DoubleCalc) {
            return (DoubleCalc)calc;
        }
        if (calc instanceof IntegerCalc) {
            final IntegerCalc integerCalc = (IntegerCalc)calc;
            return new AbstractDoubleCalc(exp, new Calc[]{integerCalc}){

                @Override
                public double evaluateDouble(Evaluator evaluator) throws OLAPException {
                    int result = integerCalc.evaluateInteger(evaluator);
                    return result;
                }
            };
        }
        if (calc instanceof NumberCalc) {
            final NumberCalc numberCalc = (NumberCalc)calc;
            return new AbstractDoubleCalc(exp, new Calc[]{numberCalc}){

                @Override
                public double evaluateDouble(Evaluator evaluator) throws OLAPException {
                    Number number = numberCalc.evaluateNumber(evaluator);
                    if (number == null) {
                        return 0.0;
                    }
                    return number.doubleValue();
                }
            };
        }
        throw new OLAPException("cannot cast " + exp + " to Double.");
    }

    @Override
    public IntegerCalc compileInteger(Exp exp) throws OLAPException {
        Calc calc = this.compileScalar(exp, false);
        if (calc instanceof IntegerCalc) {
            return (IntegerCalc)calc;
        }
        if (calc instanceof DoubleCalc) {
            final DoubleCalc doubleCalc = (DoubleCalc)calc;
            return new AbstractIntegerCalc(exp, new Calc[]{doubleCalc}){

                @Override
                public int evaluateInteger(Evaluator evaluator) throws OLAPException {
                    return (int)doubleCalc.evaluateDouble(evaluator);
                }
            };
        }
        if (calc instanceof BigDecimalCalc) {
            final BigDecimalCalc bigDecimalCalc = (BigDecimalCalc)calc;
            return new AbstractIntegerCalc(exp, new Calc[]{bigDecimalCalc}){

                @Override
                public int evaluateInteger(Evaluator evaluator) throws OLAPException {
                    return bigDecimalCalc.evaluateBigDecimal(evaluator).intValue();
                }
            };
        }
        if (calc instanceof NumberCalc) {
            final NumberCalc numberCalc = (NumberCalc)calc;
            return new AbstractIntegerCalc(exp, new Calc[]{numberCalc}){

                @Override
                public int evaluateInteger(Evaluator evaluator) throws OLAPException {
                    Number number = numberCalc.evaluateNumber(evaluator);
                    if (number == null) {
                        return 0;
                    }
                    return number.intValue();
                }
            };
        }
        throw new OLAPException("cannot cast " + exp + " to Integer.");
    }

    @Override
    public BooleanCalc compileBoolean(Exp exp) throws OLAPException {
        return (BooleanCalc)this.compileScalar(exp, false);
    }
}

