/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mdx.func;

import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.ExpResolver;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.FunDefBase;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.ExpCompiler;
import com.kingdee.bos.olap.mdx.calc.MemberCalc;
import com.kingdee.bos.olap.mdx.calc.impl.AbstractLevelCalc;
import com.kingdee.bos.olap.mdx.type.LevelType;
import com.kingdee.bos.olap.mdx.type.Type;

public class MemberLevelFunDef
extends FunDefBase {
    static final MemberLevelFunDef instance = new MemberLevelFunDef();

    private MemberLevelFunDef() {
        super("Level", "<Member>.Level", "Returns a member's level.", "plm");
    }

    @Override
    public Type getResultType(ExpResolver resolver, Exp[] args) {
        Type argType = args[0].getType();
        return LevelType.forType(argType);
    }

    @Override
    public Calc compileCall(FunCall call, ExpCompiler compiler) throws OLAPException {
        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        return new CalcImpl((Exp)call, memberCalc);
    }

    public static class CalcImpl
    extends AbstractLevelCalc {
        private final MemberCalc memberCalc;

        public CalcImpl(Exp exp, MemberCalc memberCalc) {
            super(exp, new Calc[]{memberCalc});
            this.memberCalc = memberCalc;
        }

        @Override
        public Level evaluateLevel(Evaluator evaluator) throws OLAPException {
            Member member = this.memberCalc.evaluateMember(evaluator);
            return member.getLevel();
        }
    }
}

