/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mem.CubeData;
import com.kingdee.bos.olap.mem.Point;
import java.io.IOException;
import java.util.Iterator;

public abstract class Chunk {
    protected ChunkId id;
    protected CubeData cubeData;

    protected Chunk(ChunkId id, CubeData cubeData) {
        this.id = id;
        this.cubeData = cubeData;
    }

    public ChunkId getId() {
        return this.id;
    }

    public CubeData getCubeData() {
        return this.cubeData;
    }

    public abstract void add(Point var1, Object[] var2) throws IOException, OLAPException;

    public abstract Object[] getValue(int var1) throws IOException, OLAPException;

    public abstract Object[][] getValue(int[] var1) throws IOException, OLAPException;

    public abstract Entry getEntry(int var1) throws IOException, OLAPException;

    public abstract void save(boolean var1) throws IOException, OLAPException;

    public abstract int size();

    public abstract Iterator entryIterator();

    public static class Entry {
        public Point point;
        public Object[] values;
        public boolean dirty;

        public Entry(Point point, Object[] values) {
            this.point = point;
            this.values = values;
        }
    }

    public static class ChunkId {
        public int id;

        public ChunkId(int id) {
            this.id = id;
        }

        public boolean equals(Object x) {
            if (x == null) {
                return false;
            }
            if (x == this) {
                return true;
            }
            if (!(x instanceof ChunkId)) {
                return false;
            }
            return ((ChunkId)x).id == this.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

