/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.Persistable;
import com.kingdee.bos.olap.Query;
import com.kingdee.bos.olap.Result;
import com.kingdee.bos.olap.Schema;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mem.CubeData;
import com.kingdee.bos.olap.mem.impl.ResultImpl;
import com.kingdee.bos.olap.mem.impl.SchemaImpl;
import com.kingdee.bos.olap.mem.impl.SchemaReaderImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class OLAPDatabase
implements Persistable,
Serializable {
    private static Logger logger = CommonLogger.getLogger(OLAPDatabase.class);
    public Schema schema;
    protected Hashtable cubeDatas = new Hashtable();
    private transient Map clazzMap;

    public static OLAPDatabase restore(ObjectInputStream in) throws IOException {
        OLAPDatabase db = new OLAPDatabase();
        db.restore(in, null);
        return db;
    }

    private OLAPDatabase() {
    }

    public OLAPDatabase(Schema _schema) {
        this.schema = _schema;
    }

    public SchemaReader getSchemaReader() {
        return new SchemaReaderImpl((SchemaImpl)this.schema);
    }

    public CubeData getCubeData(String name) {
        return (CubeData)this.cubeDatas.get(name);
    }

    public CubeData getCubeData(Cube cube) {
        return this.getCubeData(cube.getName());
    }

    public void setData(String name, CubeData data) {
        this.cubeDatas.put(name, data);
    }

    public Result executeQuery(Query query) throws OLAPException {
        logger.debug((Object)"executing query...");
        ResultImpl r = new ResultImpl(this.getCubeData(query.getCube()), query);
        return r;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.store(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.restore(in, null);
    }

    @Override
    public void store(ObjectOutputStream out) throws IOException {
        logger.debug((Object)"compacting database...");
        Enumeration e = this.cubeDatas.elements();
        while (e.hasMoreElements()) {
            CubeData data = (CubeData)e.nextElement();
            data.compact();
        }
        GZIPOutputStream zout = new GZIPOutputStream(out);
        ObjectOutputStream oout = new ObjectOutputStream(zout);
        logger.debug((Object)"saving schema...");
        oout.writeObject(this.schema);
        logger.debug((Object)"saving cube data...");
        int size = this.cubeDatas.size();
        oout.writeInt(size);
        for (Object key : this.cubeDatas.keySet()) {
            oout.writeObject(key);
            CubeData data = (CubeData)this.cubeDatas.get(key);
            oout.writeObject(data.getClass().getName());
            data.store(oout);
        }
        oout.flush();
        zout.finish();
        out.flush();
        logger.debug((Object)"save finished.");
    }

    @Override
    public void restore(ObjectInputStream in, Object info) throws IOException {
        try {
            logger.debug((Object)"reading schema...");
            GZIPInputStream zin = new GZIPInputStream(in);
            ObjectInputStream oin = new ObjectInputStream(zin);
            this.schema = (Schema)oin.readObject();
            logger.debug((Object)"reading cube data.");
            this.cubeDatas = new Hashtable();
            int size = oin.readInt();
            for (int i = 0; i < size; ++i) {
                Object key = oin.readObject();
                String clazzName = (String)oin.readObject();
                CubeData data = this.getCubeDataInstance(clazzName);
                data.restore(oin, this.schema);
                this.cubeDatas.put(key, data);
            }
            logger.debug((Object)"read finished.");
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
    }

    private CubeData getCubeDataInstance(String clazzName) throws IOException {
        if (this.clazzMap == null) {
            this.clazzMap = new HashMap();
        }
        Class<?> clazz = (Class<?>)this.clazzMap.get(clazzName);
        try {
            Object instance;
            if (clazz == null) {
                clazz = Class.forName(clazzName);
                this.clazzMap.put(clazzName, clazz);
            }
            if (!((instance = clazz.newInstance()) instanceof CubeData)) {
                throw new IOException("class " + clazzName + "is not CubeData");
            }
            return (CubeData)instance;
        }
        catch (Exception ex) {
            throw new IOException("can't restore data:" + ex.getMessage());
        }
    }

    public void release() {
        this.schema = null;
        for (CubeData cd : this.cubeDatas.values()) {
            cd.release();
        }
    }

    public String getDefaultCubeName() {
        Iterator iter = this.cubeDatas.keySet().iterator();
        if (iter.hasNext()) {
            return (String)iter.next();
        }
        return null;
    }
}

