/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Level;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.OLAPElementBase;
import com.kingdee.bos.olap.collection.DefaultListFactory;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.type.MemberType;
import com.kingdee.bos.olap.mdx.type.Type;
import com.kingdee.bos.olap.mem.impl.LevelImpl;
import com.kingdee.bos.olap.util.Util;
import java.util.Iterator;

public class MemberImpl
extends OLAPElementBase
implements Member {
    public static final long serialVersionUID = 41234543357636L;
    byte memberType = 1;
    int ordinal;
    int globalOrder;
    int dataType;
    protected transient String uniqueName;
    LevelImpl level;
    MemberImpl parent;
    MemberImpl[] children;
    boolean hasData;
    private transient Dimension dimension;
    private transient Hierarchy hierarchy;

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public Dimension getDimension() {
        if (this.dimension == null) {
            this.dimension = this.getHierarchy().getDimension();
        }
        return this.dimension;
    }

    @Override
    public Hierarchy getHierarchy() {
        if (this.hierarchy == null) {
            this.hierarchy = this.level.getHierarchy();
        }
        return this.hierarchy;
    }

    @Override
    public Member getParentMember() {
        return this.parent;
    }

    @Override
    public String getParentUniqueName() {
        return this.parent.getUniqueName();
    }

    @Override
    public IMemberList getChildMembers() {
        return DefaultListFactory.instance.createMemberList(this.children);
    }

    @Override
    public IMemberList getAncestorMembers() {
        IMemberList list = DefaultListFactory.instance.createMemberList();
        for (Member parentMember = this.getParentMember(); parentMember != null; parentMember = parentMember.getParentMember()) {
            list.add(parentMember);
        }
        return list;
    }

    @Override
    public Object getKey() {
        return this.getProperty("key");
    }

    void setKey(Object key) {
        this.setProperty("key", key);
    }

    @Override
    public byte getMemberType() {
        return this.memberType;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public int getGlobalOrder() {
        return this.globalOrder;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    public Type getExpType() {
        return new MemberType(this.getHierarchy(), this.getLevel(), null);
    }

    public int getCategory() {
        return 6;
    }

    @Override
    public boolean isNull() {
        return (this.memberType & 0x10) == 16;
    }

    @Override
    public boolean isAll() {
        return (this.memberType & 8) == 8;
    }

    @Override
    public boolean isMeasure() {
        return (this.memberType & 2) == 2;
    }

    @Override
    public boolean isMeasureProperty() {
        return (this.memberType & 0x20) == 32;
    }

    @Override
    public boolean isCalculated() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return this.children == null || this.children.length == 0;
    }

    @Override
    public OLAPElement lookupChild(SchemaReader schemaReader, String name) throws OLAPException {
        return this.lookupMemberChildByName(schemaReader, this, name);
    }

    private Member lookupMemberChildByName(SchemaReader reader, Member member, String memberName) throws OLAPException {
        IMemberList children = reader.getMemberChildren(member);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Member child = (Member)iter.next();
            if (!child.getName().equals(memberName)) continue;
            return child;
        }
        return null;
    }

    @Override
    public Object[] getChildren() {
        return this.children;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        Object key = this.getProperty("key");
        if (key != null) {
            return key.toString();
        }
        if (this.name == null && this.isAll()) {
            return this.getHierarchy().getAllMemberName();
        }
        return this.name;
    }

    @Override
    public String getCaption() {
        if (this.caption == null) {
            if (this.isAll()) {
                this.caption = this.getHierarchy().getAllMemberCaption();
            } else if (!this.isCalculated() && !this.isCalculatedInSchema() && !this.level.isInner() && this.level.getDimension().isTimeDimension()) {
                this.caption = Util.fixTimeMemberCaption(this);
                if (this.level.levelType == 4 || this.level.levelType == 3) {
                    String pname = null;
                    Member p = this;
                    while ((p = this.getParentMember()) != null) {
                        if (p.getLevel().getLevelType() != 2) continue;
                        pname = p.getCaption();
                        break;
                    }
                    if (pname != null) {
                        this.caption = pname + this.caption;
                    }
                }
            } else {
                this.caption = this.getName();
            }
        }
        return this.caption;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = this.parent == null ? Util.makeFqName(this.getHierarchy(), this.getName()) : Util.makeFqName(this.parent, this.getName());
        }
        return this.uniqueName;
    }

    @Override
    public int getDepth() {
        return this.level.getDepth();
    }

    @Override
    public boolean isCalculatedInSchema() {
        return false;
    }

    @Override
    public Exp getExpression() throws OLAPException {
        return null;
    }

    @Override
    public boolean hasData() {
        return this.memberType != 1 || !this.isLeaf() || this.hasData;
    }

    @Override
    public boolean isInner() {
        return false;
    }

    public void setVisible(boolean b) {
        this.setProperty("visible", b);
    }

    @Override
    public boolean isVisible() {
        Object o = this.getProperty("visible");
        if (o != null && "false".equalsIgnoreCase(o.toString())) {
            return false;
        }
        Member parent = this.getParentMember();
        if (parent == null) {
            return true;
        }
        return this.getParentMember().isVisible();
    }
}

