/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.CalculatedMember;
import com.kingdee.bos.olap.Cell;
import com.kingdee.bos.olap.Formatter;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.CellImpl;
import com.kingdee.bos.olap.base.CellKey;
import com.kingdee.bos.olap.base.CellValues;
import com.kingdee.bos.olap.base.EvaluatorImpl;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.exception.MeasuresNotVisibleException;
import com.kingdee.bos.olap.mdx.CellReader;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.ExpResolver;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.MdxResult;
import com.kingdee.bos.olap.mdx.QueryAxis;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mdx.calc.Scope;
import com.kingdee.bos.olap.mdx.calc.impl.func.FactMembersCalc;
import com.kingdee.bos.olap.mdx.func.FuncUtil2;
import com.kingdee.bos.olap.rel.CommonResultImpl;
import com.kingdee.bos.olap.rel.RelCellReaderImpl;
import com.kingdee.bos.olap.rel.RelConnectionImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.util.Util;
import com.kingdee.bos.olap.util.ValueNotReady;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class QueryPlan {
    private static Logger logger = CommonLogger.getLogger(QueryPlan.class);
    private MdxQuery query;
    Calc slicerCalc;
    Calc rowCalc;
    Calc columnCalc;
    QueryAxis rowAxis;
    QueryAxis columnAxis;
    private boolean x = false;
    HashMap formats = null;
    private IList hiddenMeasures = null;

    public QueryPlan(RelConnectionImpl con, MdxQuery query) {
        this.query = query;
    }

    private void analysis() throws OLAPException {
        this.slicerCalc = this.query.getSlicerCalc();
        QueryAxis[] axes = this.query.getAxes();
        Calc[] calcs = this.query.getAxisCalcs();
        if (axes[0].getName().equalsIgnoreCase("rows")) {
            this.rowCalc = calcs[0];
            this.columnCalc = calcs[1];
            this.rowAxis = axes[0];
            this.columnAxis = axes[1];
        } else {
            this.rowCalc = calcs[1];
            this.columnCalc = calcs[0];
            this.rowAxis = axes[1];
            this.columnAxis = axes[0];
        }
        Evaluator evaluator = this.query.createEvalutor(this.query);
        if (this.slicerCalc != null) {
            Scope scope = new Scope(this.slicerCalc, false, Scope.NeedHierarchize.No);
            this.slicerCalc = this.slicerCalc.optimize(scope, evaluator);
        }
        boolean nonEmpty = this.rowAxis.isNonEmpty();
        Scope scope = new Scope(this.rowCalc, nonEmpty, Scope.NeedHierarchize.Unknow);
        this.rowCalc = this.rowCalc.optimize(scope, evaluator);
        nonEmpty = this.columnAxis.isNonEmpty();
        scope = new Scope(this.columnCalc, nonEmpty, Scope.NeedHierarchize.Unknow);
        this.columnCalc = this.columnCalc.optimize(scope, evaluator);
        if (this.query.getAxes()[0].getName().equalsIgnoreCase("rows")) {
            this.query.setAxisCalcs(new Calc[]{this.rowCalc, this.columnCalc});
        } else {
            this.x = true;
            this.query.setAxisCalcs(new Calc[]{this.columnCalc, this.rowCalc});
        }
        this.query.setSlicerCalc(this.slicerCalc);
    }

    public MdxResult execute() throws OLAPException {
        boolean columnHasCalculatedMember;
        this.analysis();
        EvaluatorImpl evaluator = (EvaluatorImpl)this.query.createEvalutor(this.query);
        Object slicerValue = null;
        IList slicerList = null;
        if (this.slicerCalc != null) {
            slicerValue = this.slicerCalc.evaluate(evaluator.push());
        }
        if (slicerValue == null) {
            slicerList = this.query.getListFactory().createArrayList();
            slicerList.add(new Member[0]);
        } else {
            Object o;
            if (slicerValue instanceof Member || slicerValue instanceof Member[]) {
                IList list = this.query.getListFactory().createArrayList();
                list.add(slicerValue);
                slicerValue = list;
            }
            if ((o = (slicerList = (IList)slicerValue).getFirst()) instanceof Member) {
                evaluator.setContext((Member)o);
            } else {
                Member[] ms = (Member[])o;
                evaluator.setContext(ms);
            }
        }
        Member[] rowCalculatedMembers = this.query.getCalculatedMembersInQueryAxis(this.rowAxis);
        Member[] columnCalculatedMembers = this.query.getCalculatedMembersInQueryAxis(this.columnAxis);
        boolean rowHasCalculatedMember = rowCalculatedMembers != null;
        boolean bl = columnHasCalculatedMember = columnCalculatedMembers != null;
        if (this.rowAxis.isNonEmpty() && !columnHasCalculatedMember) {
            this.rowAxis.setNonFactEmpty(true);
        }
        if (this.columnAxis.isNonEmpty() && !rowHasCalculatedMember) {
            this.columnAxis.setNonFactEmpty(true);
        }
        if (this.rowCalc instanceof FactMembersCalc) {
            this.rowAxis.setNonEmpty(false);
            ((FactMembersCalc)this.rowCalc).setLimit(RelUtil.RESULT_MAX_ROWCOUNT);
        }
        if (this.columnCalc instanceof FactMembersCalc) {
            this.columnAxis.setNonEmpty(false);
            ((FactMembersCalc)this.columnCalc).setLimit(RelUtil.RESULT_MAX_COLUMNCOUNT);
        }
        boolean rowNonEmpty = this.rowAxis.isNonEmpty();
        boolean columnNonEmpty = this.columnAxis.isNonEmpty();
        RelCellReaderImpl cellReader = (RelCellReaderImpl)evaluator.getCellReader();
        IList rowList = null;
        IList columnList = null;
        boolean rowNeedCalculate = false;
        boolean columnNeedCalculate = false;
        if (!rowNonEmpty && !columnNonEmpty) {
            logger.debug((Object)"using all no non empty");
            AxisResult rowResult = this.loopExecuteNoNonEmptyAxis(cellReader, evaluator, this.rowAxis, this.rowCalc, RelUtil.RESULT_MAX_ROWCOUNT);
            AxisResult columnResult = this.loopExecuteNoNonEmptyAxis(cellReader, evaluator, this.columnAxis, this.columnCalc, RelUtil.RESULT_MAX_COLUMNCOUNT);
            rowList = rowResult.list;
            rowNeedCalculate = rowResult.needCalculate;
            columnList = columnResult.list;
            columnNeedCalculate = columnResult.needCalculate;
            return this.executeBodyNoNonEmpty((EvaluatorImpl)evaluator.push(), cellReader, slicerList, rowList, columnList);
        }
        if (rowNonEmpty && !columnNonEmpty) {
            logger.debug((Object)"using row non empty");
            AxisResult columnResult = this.loopExecuteNoNonEmptyAxis(cellReader, evaluator, this.columnAxis, this.columnCalc, RelUtil.RESULT_MAX_COLUMNCOUNT);
            columnList = columnResult.list;
            columnNeedCalculate = columnResult.needCalculate;
            AxisResult rowResult = this.loopExecuteNonEmptyAxisDependOn(cellReader, evaluator, this.rowAxis, this.rowCalc, columnList, RelUtil.RESULT_MAX_ROWCOUNT);
            rowList = rowResult.list;
            rowNeedCalculate = rowResult.needCalculate;
            return this.executeBodyNoNonEmpty((EvaluatorImpl)evaluator.push(), cellReader, slicerList, rowList, columnList);
        }
        if (columnNonEmpty && !rowNonEmpty) {
            logger.debug((Object)"using column non empty");
            AxisResult rowResult = this.loopExecuteNoNonEmptyAxis(cellReader, evaluator, this.rowAxis, this.rowCalc, RelUtil.RESULT_MAX_ROWCOUNT);
            rowList = rowResult.list;
            rowNeedCalculate = rowResult.needCalculate;
            AxisResult columnResult = this.loopExecuteNonEmptyAxisDependOn(cellReader, evaluator, this.columnAxis, this.columnCalc, rowList, RelUtil.RESULT_MAX_COLUMNCOUNT);
            columnList = columnResult.list;
            columnNeedCalculate = columnResult.needCalculate;
            return this.executeBodyNoNonEmpty((EvaluatorImpl)evaluator.push(), cellReader, slicerList, rowList, columnList);
        }
        logger.debug((Object)"using all non empty");
        AxisResult columnResult = this.loopExecuteNonEmptyAxisDependOn(cellReader, evaluator, this.columnAxis, this.columnCalc, null, -1);
        columnList = columnResult.list;
        int columnCount = columnList.size();
        columnNeedCalculate = columnResult.needCalculate;
        AxisResult rowResult = this.loopExecuteNonEmptyAxisDependOn(cellReader, evaluator, this.rowAxis, this.rowCalc, columnList, RelUtil.RESULT_MAX_ROWCOUNT);
        rowList = rowResult.list;
        rowNeedCalculate = rowResult.needCalculate;
        columnResult = this.loopExecuteNonEmptyAxisDependOn(cellReader, evaluator, this.columnAxis, this.columnCalc, rowList, RelUtil.RESULT_MAX_COLUMNCOUNT);
        columnList = columnResult.list;
        if (columnList.size() < columnCount) {
            rowResult = this.loopExecuteNonEmptyAxisDependOn(cellReader, evaluator, this.rowAxis, this.rowCalc, columnList, RelUtil.RESULT_MAX_ROWCOUNT);
            rowList = rowResult.list;
        }
        return this.executeBodyNoNonEmpty((EvaluatorImpl)evaluator.push(), cellReader, slicerList, rowList, columnList);
    }

    private AxisResult loopExecuteNoNonEmptyAxis(RelCellReaderImpl cellReader, EvaluatorImpl evaluator, QueryAxis axis, Calc calc, int count) throws OLAPException {
        AxisResult axisResult;
        block1: {
            int attempt = 0;
            axisResult = new AxisResult();
            do {
                axisResult.list = this.executeAxisNoNonEmpty(cellReader, evaluator.push(), axis, calc, count);
                if (cellReader.isBatchEmpty()) break block1;
                evaluator.clearExpResultCache(false);
                cellReader.loadAggregations();
                axisResult.needCalculate = true;
            } while (attempt++ < RelUtil.MAX_AGGREGATION_PASS_COUNT);
            throw new OLAPException("Error when caculate " + axis.getName() + " axis,there's probably a cycle.");
        }
        return axisResult;
    }

    private AxisResult loopExecuteNonEmptyAxisDependOn(RelCellReaderImpl cellReader, EvaluatorImpl evaluator, QueryAxis axis, Calc calc, IList anotherList, int count) throws OLAPException {
        AxisResult axisResult;
        block1: {
            int attempt = 0;
            axisResult = new AxisResult();
            do {
                axisResult.list = this.executeAxisNonEmptyDependOn(cellReader, evaluator.push(), axis, calc, anotherList, count);
                if (cellReader.isBatchEmpty()) break block1;
                evaluator.clearExpResultCache(false);
                cellReader.loadAggregations();
                axisResult.needCalculate = true;
            } while (attempt++ < RelUtil.MAX_AGGREGATION_PASS_COUNT);
            throw new OLAPException("Error when caculate " + axis.getName() + " axis,there's probably a cycle.");
        }
        return axisResult;
    }

    private MdxResult executeBodyNoNonEmpty(EvaluatorImpl evaluator, RelCellReaderImpl cellReader, IList slicerList, IList rowList, IList columnList) throws OLAPException {
        CellValues cellValues;
        block4: {
            cellValues = new CellValues();
            CellKey point = null;
            int attempt = 0;
            do {
                point = new CellKey(new int[]{0, 0});
                cellValues.clear();
                Iterator rowIter = rowList.iterator();
                while (rowIter.hasNext()) {
                    evaluator.setContext(rowIter.next());
                    Iterator columnIter = columnList.iterator();
                    while (columnIter.hasNext()) {
                        evaluator.setContext(columnIter.next());
                        StripeResult stripeResult = this.executeCurrent(evaluator);
                        if (stripeResult.cell != null) {
                            cellValues.put(point.copy(), stripeResult.cell);
                        }
                        int[] nArray = point.ordinals;
                        int n = this.x ? 0 : 1;
                        nArray[n] = nArray[n] + 1;
                    }
                    point.ordinals[this.x ? 0 : 1] = 0;
                    int[] nArray = point.ordinals;
                    int n = this.x ? 1 : 0;
                    nArray[n] = nArray[n] + 1;
                }
                if (cellReader.isBatchEmpty()) break block4;
                evaluator.clearExpResultCache(false);
                cellReader.loadAggregations();
            } while (++attempt < RelUtil.MAX_AGGREGATION_PASS_COUNT);
            throw new OLAPException("Executing data more than " + attempt + " times.There seems a cycle.");
        }
        return new CommonResultImpl(this.query, slicerList, rowList, columnList, this.x, cellValues);
    }

    private StripeResult executeCurrent(EvaluatorImpl evaluator) throws OLAPException {
        Object o;
        Member[] context = null;
        try {
            context = (Member[])evaluator.getCurrentMembers().clone();
            o = evaluator.evaluateCurrent();
        }
        catch (OLAPException e) {
            logger.debug((Object)e);
            o = e;
        }
        if (o == ValueNotReady.instance) {
            return new StripeResult(null, false, true);
        }
        if (o != null && o != Util.nullValue && !(o instanceof Exception)) {
            String fmtStr = null;
            String color = null;
            String bgColor = null;
            String trend = null;
            String status = null;
            CalculatedMember solveMember = (CalculatedMember)evaluator.getMaxSolveMember();
            if (solveMember != null) {
                fmtStr = solveMember.getFormatString();
                color = (String)solveMember.getProperty("color");
                bgColor = (String)solveMember.getProperty("bgColor");
                trend = (String)solveMember.getProperty("trend");
                status = (String)solveMember.getProperty("status");
            }
            Member measure = evaluator.getContext(evaluator.getCube().getMeasureDimension());
            if (fmtStr == null) {
                fmtStr = measure instanceof CalculatedMember ? ((CalculatedMember)measure).getFormatString() : (String)measure.getProperty("formatString");
            }
            if (color == null) {
                color = (String)measure.getProperty("color");
            }
            if (bgColor == null) {
                bgColor = (String)measure.getProperty("bgColor");
            }
            if (status == null) {
                status = (String)measure.getProperty("status");
            }
            if (trend == null) {
                trend = (String)measure.getProperty("trend");
            }
            if (fmtStr != null && !fmtStr.equals("")) {
                fmtStr = this.resolveFomatString(evaluator, fmtStr);
            }
            if (color != null && !color.equals("")) {
                color = this.resolveFomatString(evaluator, color);
            }
            if (bgColor != null && !bgColor.equals("")) {
                bgColor = this.resolveFomatString(evaluator, bgColor);
            }
            if (trend != null && !trend.equals("")) {
                trend = this.resolveFomatString(evaluator, trend);
            }
            if (status != null && !status.equals("")) {
                status = this.resolveFomatString(evaluator, status);
            }
            Formatter fmt = this.getFormatter(fmtStr);
            fmt.setColor(color);
            fmt.setBgColor(bgColor);
            fmt.setStatus(status);
            fmt.setTrend(trend);
            CellImpl cell = new CellImpl(context, o, fmt);
            return new StripeResult(cell, false, false);
        }
        return new StripeResult(null, false, false);
    }

    private Formatter getFormatter(String formatString) {
        return new Formatter(formatString);
    }

    private IList getHiddenMeasures() {
        int i;
        if (this.hiddenMeasures != null) {
            return this.hiddenMeasures;
        }
        Member[] measures = this.query.getCube().getMeasures();
        Member[] calculatedMeasures = this.query.getSchemaReader().getCalculatedMembers(this.query.getCube(), this.query.getCube().getMeasureDimension().getDefaultHierarchy());
        IList jlist = this.query.getListFactory().createArrayList();
        for (i = 0; i < measures.length; ++i) {
            if (measures[i].isVisible()) continue;
            jlist.add(measures[i]);
        }
        if (calculatedMeasures != null) {
            for (i = 0; i < calculatedMeasures.length; ++i) {
                if (calculatedMeasures[i].isVisible()) continue;
                jlist.add(calculatedMeasures[i]);
            }
        }
        return jlist;
    }

    private IList executeAxisNoNonEmpty(CellReader cellReader, Evaluator evaluator, QueryAxis axis, Calc calc, int count) throws OLAPException {
        Object value = calc.evaluate(evaluator);
        IList list = (IList)value;
        if (count < 0 || count > list.size()) {
            count = list.size();
        }
        if (count >= (list = this.filterVisibleMember2(list, 0, count)).size()) {
            return list;
        }
        return list.subList(0, count);
    }

    private IList executeAxisNonEmptyDependOn(CellReader cellReader, Evaluator evaluator, QueryAxis axis, Calc calc, IList anotherList, int count) throws OLAPException {
        boolean nonFactEmpty = axis.isNonFactEmpty();
        evaluator.setNonFactEmpty(nonFactEmpty);
        Object value = calc.evaluate(evaluator);
        IList list = (IList)value;
        if (count < 0 || count > list.size()) {
            count = list.size();
        }
        list = FuncUtil2.nonEmptyList(evaluator, list, anotherList, true, count);
        return list;
    }

    private String resolveFomatString(EvaluatorImpl evaluator, String fmtStr) throws OLAPException {
        if (fmtStr.toLowerCase(Locale.ENGLISH).startsWith("mdx:")) {
            fmtStr = fmtStr.substring(4);
            ExpResolver resolver = evaluator.getQuery().createExpResolver();
            Exp exp = evaluator.getQuery().getConnection().parseExpression(fmtStr);
            exp = resolver.resolve(exp);
            Calc calc = evaluator.getQuery().compileExpression(exp, false);
            Object o = calc.evaluate(evaluator.push());
            if (!(o instanceof String)) {
                throw new OLAPException("formatString expression must return String.");
            }
            String formatExp = (String)o;
            return formatExp;
        }
        return fmtStr;
    }

    private IList filterVisibleMember2(IList list, int from, int count) throws OLAPException {
        int index;
        if (list.isEmpty()) {
            return list;
        }
        IList result = this.query.getListFactory().createArrayList();
        boolean foundHidden = false;
        Iterator iter = list.iterator();
        for (index = 0; index < from && iter.hasNext(); ++index) {
            iter.next();
        }
        for (index = 0; iter.hasNext() && index < count; ++index) {
            Member[] ms = Util.toMemberArray(iter.next());
            if (!Util.isVisible(ms)) {
                int index2;
                if (foundHidden) continue;
                foundHidden = true;
                iter = list.iterator();
                for (index2 = 0; index2 < from; ++index2) {
                    iter.next();
                }
                while (index2 < from + index) {
                    ms = Util.toMemberArray(iter.next());
                    result.add(ms);
                    ++index2;
                }
                iter.next();
                continue;
            }
            if (!foundHidden) continue;
            result.add(ms);
        }
        if (foundHidden) {
            return result;
        }
        return list;
    }

    private IList filterVisibleMember(IList list, int from, int count) throws OLAPException {
        if (list.isEmpty()) {
            return list;
        }
        Member[] members = Util.toMemberArray(list.getFirst());
        IList result = this.query.getListFactory().createArrayList();
        int indexMeasures = -1;
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].isMeasure()) continue;
            indexMeasures = i;
            break;
        }
        if (indexMeasures > -1) {
            int index;
            HashSet<String> notVisibleMeasureCaptions = new HashSet<String>();
            Iterator iter = list.iterator();
            for (index = 0; index < from && iter.hasNext(); ++index) {
                iter.next();
            }
            index = 0;
            while (iter.hasNext() && index < count) {
                Member[] ms = Util.toMemberArray(iter.next());
                if (!ms[indexMeasures].isVisible()) {
                    notVisibleMeasureCaptions.add(ms[indexMeasures].getCaption());
                    continue;
                }
                result.add(ms);
                ++index;
            }
            if (result.isEmpty() && notVisibleMeasureCaptions.size() > 0) {
                String[] measureCaptions = new String[notVisibleMeasureCaptions.size()];
                notVisibleMeasureCaptions.toArray(measureCaptions);
                throw new MeasuresNotVisibleException(measureCaptions);
            }
            return result;
        }
        if (from + count < list.size()) {
            return list.subList(from, from + count);
        }
        return list.subList(from, list.size());
    }

    private class StripeResult {
        Cell cell;
        boolean allNull;
        boolean valueNotReader;

        public StripeResult(Cell cell, boolean allNull, boolean valueNotReader) {
            this.cell = cell;
            this.allNull = allNull;
            this.valueNotReader = valueNotReader;
        }
    }

    private class AxisResult {
        boolean needCalculate = false;
        IList list;

        private AxisResult() {
        }
    }
}

