/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.DimensionUsageInfo;
import com.kingdee.bos.olap.ITempTableManager;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.collection.DefaultListFactory;
import com.kingdee.bos.olap.collection.IListFactory;
import com.kingdee.bos.olap.dbsource.ConnectionHelper;
import com.kingdee.bos.olap.dbsource.JdbcConnectionInfo;
import com.kingdee.bos.olap.dbsource.ResultSetTable;
import com.kingdee.bos.olap.dbsource.Table;
import com.kingdee.bos.olap.dbsource.TableManager;
import com.kingdee.bos.olap.dbsource.TimeRangeTable;
import com.kingdee.bos.olap.def.CubeDimension;
import com.kingdee.bos.olap.def.DimensionUsageDef;
import com.kingdee.bos.olap.def.ParameterDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SharedDimensionDef;
import com.kingdee.bos.olap.def.TableDef;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.MdxResult;
import com.kingdee.bos.olap.mdx.ParserHelp;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mem.impl.BuildContext;
import com.kingdee.bos.olap.mem.impl.OLAPBuilder;
import com.kingdee.bos.olap.mem.impl.SchemaImpl;
import com.kingdee.bos.olap.mem.impl.SchemaReaderImpl;
import com.kingdee.bos.olap.rel.DBType;
import com.kingdee.bos.olap.rel.ProxyConnection;
import com.kingdee.bos.olap.rel.QueryPlan;
import com.kingdee.bos.olap.rel.RelMeasureImpl;
import com.kingdee.bos.olap.rel.RelSchemaImpl;
import com.kingdee.bos.olap.rel.RelSchemaReaderImpl;
import com.kingdee.bos.olap.rel.RelUtil;
import com.kingdee.bos.olap.rel.SimpleTempTableManager;
import com.kingdee.bos.olap.rel.SqlQuery;
import com.kingdee.bos.olap.rel.StarTables;
import com.kingdee.bos.olap.rel.dialect.DatabaseMetaUtil;
import com.kingdee.bos.olap.util.IgnoreCaseString;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class RelConnectionImpl
implements Connection {
    private static Logger logger = CommonLogger.getLogger(RelConnectionImpl.class);
    SchemaDef schemaDef;
    private ProxyConnection proxyConnection;
    private DataSource dataSource;
    RelSchemaImpl schema;
    RelSchemaReaderImpl schemaReader;
    private TableDef[] tableDefs;
    private StarTables starTables;
    DBType dbType;
    String useMode;
    List notVisibleMeasures;
    private boolean useSqlDataReduction;
    private ITempTableManager tempTableManager;
    private ArrayList tempTableNames = new ArrayList();
    private Locale locale;
    private IListFactory listFactory;

    public RelConnectionImpl(SchemaDef schemaDef, Map params) throws OLAPException {
        this.schemaDef = this.processSchemaDef(schemaDef);
        if (schemaDef.connection != null) {
            java.sql.Connection jdbcConnection = ConnectionHelper.makeConnection(schemaDef.connection);
            this.makeProxy(jdbcConnection);
        }
        this.init(params);
    }

    public RelConnectionImpl(SchemaDef schemaDef, Map params, DataSource dataSource) throws OLAPException {
        this.schemaDef = this.processSchemaDef(schemaDef);
        this.dataSource = dataSource;
        this.init(params);
    }

    public RelConnectionImpl(SchemaDef schemaDef, Map params, java.sql.Connection cn) throws OLAPException {
        this.schemaDef = this.processSchemaDef(schemaDef);
        this.makeProxy(cn);
        this.init(params);
    }

    public RelConnectionImpl(SchemaDef schemaDef, Map params, JdbcConnectionInfo cnInfo) throws OLAPException {
        this.schemaDef = this.processSchemaDef(schemaDef);
        java.sql.Connection jdbcConnection = ConnectionHelper.makeConnection(cnInfo);
        this.makeProxy(jdbcConnection);
        this.init(params);
    }

    private SchemaDef processSchemaDef(SchemaDef schemaDef) {
        SharedDimensionDef[] sdds = schemaDef.dimensions;
        CubeDimension[] cds = schemaDef.cubes[0].dimensions;
        ArrayList<SharedDimensionDef> list = new ArrayList<SharedDimensionDef>();
        if (cds.length < sdds.length) {
            for (int i = 0; i < cds.length; ++i) {
                String name = cds[i].name;
                for (int j = 0; j < sdds.length; ++j) {
                    if (!sdds[j].name.equals(name)) continue;
                    list.add(sdds[j]);
                }
            }
            schemaDef.dimensions = new SharedDimensionDef[list.size()];
            list.toArray(schemaDef.dimensions);
        }
        return schemaDef;
    }

    public SchemaDef getSchemaDef() {
        return this.schemaDef;
    }

    private void makeProxy(java.sql.Connection cn) {
        this.proxyConnection = new ProxyConnection(cn, false);
    }

    private void initDbType(Map params) throws OLAPException {
        this.dbType = new DBType();
        SqlQuery sqlQuery = null;
        java.sql.Connection con = null;
        try {
            con = this.getJdbcConnection();
            sqlQuery = new SqlQuery(con.getMetaData());
        }
        catch (SQLException e) {
            throw new OLAPException(e);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        if (sqlQuery.isDB2()) {
            this.dbType.setType("DB2");
        } else if (sqlQuery.isMSSQL()) {
            this.dbType.setType("Sql Server");
        } else if (sqlQuery.isOracle() || sqlQuery.isPostgres()) {
            this.dbType.setType("Oracle");
        } else if (sqlQuery.isSybase()) {
            this.dbType.setType("Sybase");
        } else if (sqlQuery.isDM()) {
            this.dbType.setType("DM");
        } else if (sqlQuery.isKingBase()) {
            this.dbType.setType("King Base");
        } else {
            throw new OLAPException("Unsupport database type.");
        }
        if (params != null) {
            Object o = params.get("OLAP_KEY_KSQL");
            if (o != null && Boolean.TRUE.equals(o)) {
                this.dbType.setKsql(true);
            } else {
                this.dbType.setKsql(false);
            }
        }
    }

    private void initDataSource(Map params) throws OLAPException {
        if (this.proxyConnection == null && params != null) {
            Object o = params.get("JdbcConnection");
            if (o != null) {
                this.makeProxy((java.sql.Connection)o);
            } else {
                o = params.get("JdbcDataSource");
                if (o != null) {
                    this.dataSource = (DataSource)o;
                }
            }
        }
    }

    private HashSet collectTableUsed() {
        HashSet<String> set = new HashSet<String>();
        set.add(this.schemaDef.cubes[0].table);
        for (int i = 0; i < this.schemaDef.dimensions.length; ++i) {
            set.add(this.schemaDef.dimensions[i].table);
        }
        return set;
    }

    private void initTables(Map params) throws OLAPException {
        HashSet tableUsed = this.collectTableUsed();
        ArrayList<TableDef> list = new ArrayList<TableDef>();
        if (this.schemaDef.parameters != null && params != null) {
            for (int i = 0; i < this.schemaDef.parameters.length; ++i) {
                ParameterDef param = this.schemaDef.parameters[i];
                Object x = params.get(param.name);
                if (x == null) {
                    x = params.get(new IgnoreCaseString(param.name));
                }
                if (x == null || !param.type.equalsIgnoreCase("Table") || !tableUsed.contains(param.name)) continue;
                try {
                    TableDef td;
                    if (x instanceof String) {
                        list.add(new TableDef(param.name, (String)x));
                        continue;
                    }
                    if (x instanceof TableDef) {
                        list.add((TableDef)x);
                        continue;
                    }
                    if (x instanceof Table) {
                        td = this.convertTableToSql((Table)x);
                        list.add(td);
                        td.name = param.name;
                        params.put(param.name, td);
                        continue;
                    }
                    if (!(x instanceof ResultSet)) continue;
                    td = this.convertResultSetToSql((ResultSet)x);
                    list.add(td);
                    td.name = param.name;
                    params.put(param.name, td);
                    continue;
                }
                catch (SQLException e) {
                    throw new OLAPException(e);
                }
            }
        }
        this.tableDefs = new TableDef[list.size()];
        list.toArray(this.tableDefs);
    }

    private void initSchema() throws OLAPException {
        this.schema = new RelSchemaImpl(this.schemaDef, this);
        this.schemaReader = new RelSchemaReaderImpl(this.schema);
        this.schemaReader.init();
    }

    private void init(Map params) throws OLAPException {
        long t1 = System.currentTimeMillis();
        this.initDataSource(params);
        this.initDbType(params);
        if (params != null) {
            Locale locale = (Locale)params.get("Locale");
            if (locale != null) {
                this.locale = locale;
            }
            this.notVisibleMeasures = (List)params.get("OLAP_KEY_MEASURE_VISIBLES");
            Object o = params.get("ITempTableManager.ID");
            if (o != null) {
                this.tempTableManager = (ITempTableManager)o;
            }
            if ((o = params.get("OLAP_USEMODE")) != null) {
                this.useMode = (String)o;
            }
            if ((o = params.get("OLAP_KEY_SQLDATAREDUCTION")) != null) {
                this.useSqlDataReduction = (Boolean)o;
            }
        }
        if (this.tempTableManager == null) {
            this.tempTableManager = new SimpleTempTableManager();
        }
        this.initTables(params);
        if (this.useSqlDataReduction) {
            this.starTables = new StarTables(this.schemaDef, this);
        }
        this.initSchema();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("initial ROLAP Connection cost " + (System.currentTimeMillis() - t1) + "ms"));
        }
    }

    @Override
    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    @Override
    public SchemaReader getRemoteSchemaReader() throws OLAPException {
        long t1 = System.currentTimeMillis();
        java.sql.Connection con = null;
        TableManager tableManager = null;
        try {
            tableManager = this.starTables != null ? new TableManager(this.starTables.collectAllTableDef()) : new TableManager(this.schemaDef, this.tableDefs);
            con = this.getJdbcConnection();
            tableManager.setConnection(con);
            BuildContext buildContext = new BuildContext(tableManager);
            SchemaImpl schemaImpl = OLAPBuilder.buildSchema(buildContext, this.schemaDef, this.notVisibleMeasures, false);
            SchemaReaderImpl schemaReaderImpl = new SchemaReaderImpl(schemaImpl);
            return schemaReaderImpl;
        }
        catch (SQLException e) {
            throw new OLAPException(e.getMessage(), e);
        }
        finally {
            if (tableManager != null) {
                tableManager.clear();
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getRemoteSchemaReader cost " + (System.currentTimeMillis() - t1) + "ms"));
            }
        }
    }

    @Override
    public MdxResult executeMdxQuery(MdxQuery query) throws OLAPException {
        query.setConnection(this);
        QueryPlan qp = new QueryPlan(this, query);
        MdxResult result = qp.execute();
        query.release();
        return result;
    }

    @Override
    public MdxResult executeMdxQuery(String mdx) throws OLAPException {
        long t1 = System.currentTimeMillis();
        MdxQuery query = this.parseQuery(mdx);
        MdxResult result = this.executeMdxQuery(query);
        query.release();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("execute mdx cost " + (System.currentTimeMillis() - t1) + "ms."));
        }
        return result;
    }

    @Override
    public Exp parseExpression(String expression) throws OLAPException {
        return ParserHelp.parseExpression(expression);
    }

    @Override
    public MdxQuery parseQuery(String mdx) throws OLAPException {
        return ParserHelp.parseQuery(this, mdx);
    }

    @Override
    public void close() throws OLAPException {
        java.sql.Connection jdbcConnection = this.getJdbcConnection();
        for (int i = 0; i < this.tempTableNames.size(); ++i) {
            try {
                String tableName = (String)this.tempTableNames.get(i);
                this.tempTableManager.releaseTemporaryTableName(jdbcConnection, tableName);
                continue;
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            if (jdbcConnection == this.proxyConnection) {
                this.proxyConnection.realClose();
            } else {
                jdbcConnection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getDefaultCubeName() {
        return this.schema.getCubes()[0].getName();
    }

    @Override
    public boolean isRolap() {
        return true;
    }

    public boolean isVisible(RelMeasureImpl measure) {
        return this.notVisibleMeasures == null || !this.notVisibleMeasures.contains(measure.getName());
    }

    public java.sql.Connection getJdbcConnection() throws OLAPException {
        if (this.proxyConnection != null) {
            return this.proxyConnection;
        }
        if (this.dataSource != null) {
            try {
                return this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new OLAPException("Can't not obtain jdbc Connection.", e);
            }
        }
        throw new OLAPException("Can't not obtain jdbc Connection.");
    }

    public String getFactTableName() {
        return this.schemaDef.cubes[0].table;
    }

    public DimensionUsageInfo[] getDimensionUsageInfos() {
        ArrayList<DimensionUsageInfo> list = new ArrayList<DimensionUsageInfo>();
        SharedDimensionDef[] sdds = this.schemaDef.dimensions;
        HashMap<String, SharedDimensionDef> map = new HashMap<String, SharedDimensionDef>();
        for (int i = 0; i < sdds.length; ++i) {
            map.put(sdds[i].name, sdds[i]);
        }
        CubeDimension[] cds = this.schemaDef.cubes[0].dimensions;
        for (int i = 0; i < cds.length; ++i) {
            DimensionUsageDef dud = (DimensionUsageDef)cds[i];
            DimensionUsageInfo info = new DimensionUsageInfo();
            SharedDimensionDef sdd = (SharedDimensionDef)map.get(dud.name);
            info.dimName = sdd.name;
            info.dimTable = sdd.table;
            info.dimPrimaryKey = sdd.primaryKey;
            info.dimForeignKey = dud.foreignKey;
            list.add(info);
        }
        DimensionUsageInfo[] dui = new DimensionUsageInfo[list.size()];
        list.toArray(dui);
        return dui;
    }

    public TableDef getTableDef(String name) {
        String tableName = null;
        if (this.starTables != null && (tableName = this.starTables.getTableNameByRefName(name)) != null) {
            return new TableDef(tableName);
        }
        for (int i = 0; i < this.tableDefs.length; ++i) {
            if (!this.tableDefs[i].name.equalsIgnoreCase(name)) continue;
            return this.tableDefs[i];
        }
        return this.schemaDef.getTableDef(name);
    }

    public TableDef convertResultSetToSql(ResultSet rs) throws SQLException, OLAPException {
        return this.convertTableToSql(new ResultSetTable(rs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableDef convertTableToSql(Table table) throws OLAPException, SQLException {
        String sql;
        int i;
        if (!(table instanceof ResultSetTable) && !(table instanceof TimeRangeTable)) {
            throw new OLAPException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\u7c7b\u578b:" + table.getClass().getName());
        }
        String tableName = this.getTemporaryTableName("");
        String[] columnNames = table.getColumnNames();
        int[] columnTypes = new int[columnNames.length];
        String[] columnTypeNames = new String[columnNames.length];
        StringBuffer create = new StringBuffer("create table  ").append(tableName).append("(");
        if (table instanceof ResultSetTable) {
            ResultSetMetaData rsmd = ((ResultSetTable)table).getMetaData();
            for (i = 0; i < columnNames.length; ++i) {
                int type = rsmd.getColumnType(i + 1);
                int precision = rsmd.getPrecision(i + 1);
                int scale = rsmd.getScale(i + 1);
                columnTypes[i] = type;
                columnTypeNames[i] = DatabaseMetaUtil.getColumnDefine(this.dbType, type, precision, scale);
                if (i > 0) {
                    create.append(",");
                }
                create.append(columnNames[i]).append(" ").append(columnTypeNames[i]);
            }
            create.append(")");
            sql = create.toString();
        } else {
            String columnName = ((TimeRangeTable)table).getColumnNames()[0];
            columnTypes[0] = 93;
            create.append(columnName).append(" DATETIME");
            create.append(")");
            sql = create.toString();
        }
        logger.debug((Object)("OLAP execute:" + sql));
        this.createTempTable(sql);
        StringBuffer insert = new StringBuffer("insert into ").append(tableName).append(" values(");
        for (i = 0; i < columnTypes.length; ++i) {
            insert.append("?");
            if (i >= columnTypes.length - 1) continue;
            insert.append(",");
        }
        insert.append(")");
        java.sql.Connection jdbcConnection = null;
        Statement ps = null;
        try {
            jdbcConnection = this.getJdbcConnection();
            ps = jdbcConnection.prepareStatement(insert.toString());
            while (table.next()) {
                for (int i2 = 0; i2 < columnTypes.length; ++i2) {
                    RelUtil.setValue(i2 + 1, table.getValue(i2), (PreparedStatement)ps, columnTypes[i2]);
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException i2) {}
            }
            if (jdbcConnection != null) {
                try {
                    jdbcConnection.close();
                }
                catch (SQLException i2) {}
            }
        }
        TableDef tableDef = new TableDef();
        tableDef.name = tableName;
        tableDef.generate = true;
        tableDef.sql = tableName;
        return tableDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTempTable(String sql) throws SQLException, OLAPException {
        java.sql.Connection jdbcConnection = this.getJdbcConnection();
        try {
            this.tempTableManager.createTempTable(jdbcConnection, sql);
        }
        finally {
            if (jdbcConnection != null) {
                try {
                    jdbcConnection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTemporaryTableName(String desc) throws SQLException, OLAPException {
        java.sql.Connection jdbcConnection = this.getJdbcConnection();
        try {
            String tableName = this.tempTableManager.getTemporaryTableName(jdbcConnection, desc);
            this.registerTempTableName(tableName);
            String string = tableName;
            return string;
        }
        finally {
            if (jdbcConnection != null) {
                try {
                    jdbcConnection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public DBType getDBType() {
        return this.dbType;
    }

    private void registerTempTableName(String tableName) {
        this.tempTableNames.add(tableName);
    }

    public IListFactory getListFactory() {
        if (this.listFactory == null) {
            this.listFactory = DefaultListFactory.instance;
        }
        return this.listFactory;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

