/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.def.CalculatedMemberDef;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.def.CubeDimensionDef;
import com.kingdee.bos.olap.def.DimensionUsageDef;
import com.kingdee.bos.olap.def.HierarchyDef;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.def.MeasureDef;
import com.kingdee.bos.olap.def.PropertyDef;
import com.kingdee.bos.olap.def.SchemaDef;
import com.kingdee.bos.olap.def.SharedDimensionDef;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.Formula;
import com.kingdee.bos.olap.mdx.Literal;
import com.kingdee.bos.olap.mdx.MemberProperty;
import com.kingdee.bos.olap.mdx.ParserHelp;
import com.kingdee.bos.olap.mem.impl.PropertyImpl;
import com.kingdee.bos.olap.rel.MeasureMemberReader;
import com.kingdee.bos.olap.rel.RelCalculatedMemberImpl;
import com.kingdee.bos.olap.rel.RelCubeImpl;
import com.kingdee.bos.olap.rel.RelDimensionImpl;
import com.kingdee.bos.olap.rel.RelHierarchyImpl;
import com.kingdee.bos.olap.rel.RelLevelImpl;
import com.kingdee.bos.olap.rel.RelMeasureImpl;
import com.kingdee.bos.olap.rel.RelMeasureProperty;
import com.kingdee.bos.olap.rel.RelSchemaImpl;
import com.kingdee.bos.olap.util.Util;
import java.util.ArrayList;

public class RelSchemaBuilder {
    public static void buildSchema(RelSchemaImpl schema, SchemaDef def) throws OLAPException {
        int i;
        schema.dims = null;
        schema.dims = def.dimensions == null ? new RelDimensionImpl[0] : new RelDimensionImpl[def.dimensions.length];
        for (i = 0; i < schema.dims.length; ++i) {
            schema.dims[i] = RelSchemaBuilder.buildSharedDimension(schema, def.dimensions[i]);
        }
        schema.cubes = new RelCubeImpl[def.cubes.length];
        for (i = 0; i < schema.cubes.length; ++i) {
            schema.cubes[i] = RelSchemaBuilder.buildCube(schema, def.cubes[i]);
        }
    }

    private static RelDimensionImpl buildSharedDimension(RelSchemaImpl schema, SharedDimensionDef x) throws OLAPException {
        RelDimensionImpl dim = new RelDimensionImpl();
        dim.schema = schema;
        dim.setProperty("name", x.name);
        dim.setProperty("caption", x.caption);
        dim.setProperty("description", x.description);
        dim.setProperty("table", x.table);
        dim.setProperty("type", x.type);
        dim.setProperty("primaryKey", x.primaryKey);
        dim.dimensionType = x.type != null && x.type.equalsIgnoreCase("Time") ? (byte)1 : 0;
        dim.hies = new RelHierarchyImpl[x.hierarchies.length];
        for (int i = 0; i < dim.hies.length; ++i) {
            dim.hies[i] = RelSchemaBuilder.buildHierarchy(i, dim, x.hierarchies[i]);
        }
        dim.setProperty("Permission", x.permission);
        return dim;
    }

    private static RelHierarchyImpl buildHierarchy(int ordinal, RelDimensionImpl dim, HierarchyDef x) throws OLAPException {
        int i;
        RelHierarchyImpl hie = new RelHierarchyImpl(dim, x.name, x.caption);
        hie.def = x;
        hie.ordinal = ordinal;
        hie.setProperty("description", x.description);
        hie.setProperty("hasAll", x.hasAll);
        hie.setProperty("allMemberName", x.allMemberName);
        hie.setProperty("allMemberCaption", x.allMemberCaption);
        hie.setProperty("virtualAllMemberCaption", x.v$AllMemberCaption);
        hie.levels = new RelLevelImpl[x.levels.length];
        for (i = 0; i < hie.levels.length; ++i) {
            hie.levels[i] = RelSchemaBuilder.buildLevel(hie, x.levels[i]);
        }
        for (i = 0; i < hie.levels.length; ++i) {
            if (i > 0) {
                hie.levels[i].parent = hie.levels[i - 1];
            }
            if (i < hie.levels.length - 1) {
                hie.levels[i].child = hie.levels[i + 1];
            }
            hie.levels[i].depth = x.hasAll ? (byte)(i + 1) : (byte)i;
        }
        return hie;
    }

    private static RelLevelImpl buildLevel(RelHierarchyImpl hie, LevelDef x) throws OLAPException {
        RelLevelImpl level = new RelLevelImpl(x);
        level.hie = hie;
        level.setProperty("name", x.name);
        level.setProperty("caption", x.caption);
        level.setProperty("description", x.description);
        level.setProperty("type", x.type);
        level.levelType = x.type == null ? (byte)0 : Util.getLevelType(x.type);
        level.setProperty("column", x.column);
        level.setProperty("orderBy", x.orderBy);
        level.setProperty("parentColumn", x.parentColumn);
        level.setProperty("childColumn", x.childColumn);
        level.setProperty("rule", x.rule);
        level.props = new PropertyImpl[x.properties.length];
        for (int i = 0; i < level.props.length; ++i) {
            level.props[i] = RelSchemaBuilder.buildProperty(x.properties[i]);
        }
        return level;
    }

    private static PropertyImpl buildProperty(PropertyDef x) {
        PropertyImpl p = new PropertyImpl();
        p.setProperty("name", x.name);
        p.setProperty("caption", x.caption);
        p.setProperty("description", x.description);
        p.setProperty("column", x.column);
        return p;
    }

    private static RelMeasureProperty buildMeasurePropertyMember(RelCubeImpl cube, PropertyDef x) throws OLAPException {
        RelMeasureProperty p = new RelMeasureProperty(cube, x.column);
        p.setProperty("name", x.name);
        p.setProperty("caption", x.caption);
        p.setProperty("description", x.description);
        p.level = cube.measureLevel;
        p.memberType = (byte)32;
        return p;
    }

    private static RelCubeImpl buildCube(RelSchemaImpl schema, CubeDef x) throws OLAPException {
        int i;
        RelCubeImpl cube = new RelCubeImpl(schema, x);
        cube.initMeasures(x);
        cube.setProperty("name", x.name);
        cube.setProperty("caption", x.caption);
        cube.setProperty("description", x.description);
        cube.setProperty("table", x.table);
        cube.dims = new RelDimensionImpl[x.dimensions.length];
        for (i = 0; i < cube.dims.length; ++i) {
            if (x.dimensions[i] instanceof DimensionUsageDef) {
                RelDimensionImpl dim = (RelDimensionImpl)schema.getDimension(x.dimensions[i].name);
                cube.dims[i] = RelSchemaBuilder.buildDimensionUsage(dim, (DimensionUsageDef)x.dimensions[i]);
            } else {
                cube.dims[i] = RelSchemaBuilder.buildCubeDimension(schema, (CubeDimensionDef)x.dimensions[i]);
                cube.dims[i].setProperty("table", x.table);
            }
            cube.dims[i].cube = cube;
        }
        cube.measures = new RelMeasureImpl[x.measures.length];
        for (i = 0; i < cube.measures.length; ++i) {
            cube.measures[i] = RelSchemaBuilder.buildMeasure(cube, x.measures[i]);
            cube.measures[i].setOrdinal(i);
        }
        cube.measureHierarchy.memberReader = new MeasureMemberReader(cube.measures);
        if (x.properties == null) {
            cube.measurePropertyMembers = new RelMeasureProperty[0];
        } else {
            cube.measurePropertyMembers = new RelMeasureProperty[x.properties.length];
            for (i = 0; i < cube.measurePropertyMembers.length; ++i) {
                cube.measurePropertyMembers[i] = RelSchemaBuilder.buildMeasurePropertyMember(cube, x.properties[i]);
            }
        }
        cube.initStar(schema, x);
        if (x.calculatedMembers == null) {
            cube.calculatedMembers = new RelCalculatedMemberImpl[0];
        } else {
            cube.calculatedMembers = new RelCalculatedMemberImpl[x.calculatedMembers.length];
            for (i = 0; i < x.calculatedMembers.length; ++i) {
                cube.calculatedMembers[i] = RelSchemaBuilder.buildCalculatedMember(cube, x.calculatedMembers[i]);
            }
        }
        return cube;
    }

    private static RelCalculatedMemberImpl buildCalculatedMember(RelCubeImpl cube, CalculatedMemberDef def) throws OLAPException {
        String[] uniqueName = new String[]{def.dimension, def.name};
        Exp exp = ParserHelp.parseExpression(def.formula);
        ArrayList<MemberProperty> jlist = new ArrayList<MemberProperty>();
        if (def.formatString != null) {
            jlist.add(new MemberProperty("formatString", Literal.createString(def.formatString)));
        }
        if (def.color != null) {
            jlist.add(new MemberProperty("color", Literal.createString(def.color)));
        }
        if (def.bgColor != null) {
            jlist.add(new MemberProperty("bgColor", Literal.createString(def.bgColor)));
        }
        if (def.solveOrder != null) {
            jlist.add(new MemberProperty("SOLVE_ORDER", Literal.create(new Integer(def.solveOrder))));
        }
        if (def.caption != null) {
            jlist.add(new MemberProperty("caption", Literal.createString(def.caption)));
        }
        if (!def.visible) {
            jlist.add(new MemberProperty("visible", Literal.createString("false")));
        }
        if (def.properties != null) {
            for (int i = 0; i < def.properties.length; ++i) {
                jlist.add(new MemberProperty(def.properties[i].name, Literal.createString(def.properties[i].value)));
            }
        }
        MemberProperty[] properties = new MemberProperty[jlist.size()];
        jlist.toArray(properties);
        Formula formula = new Formula(uniqueName, exp, properties, null);
        Dimension dim = cube.getDimension(def.dimension);
        RelCalculatedMemberImpl m = (RelCalculatedMemberImpl)dim.getDefaultHierarchy().createMember(def.name, def.caption, formula, true);
        formula.setMember(m);
        return m;
    }

    private static RelDimensionImpl buildDimensionUsage(RelDimensionImpl source, DimensionUsageDef x) throws OLAPException {
        source.setProperty("foreignKey", x.foreignKey);
        return source;
    }

    private static RelDimensionImpl buildCubeDimension(RelSchemaImpl schema, CubeDimensionDef x) throws OLAPException {
        RelDimensionImpl dim = new RelDimensionImpl();
        dim.schema = schema;
        dim.setProperty("name", x.name);
        dim.setProperty("caption", x.caption);
        dim.setProperty("description", x.description);
        dim.setProperty("type", x.type);
        dim.dimensionType = x.type != null && x.type.equalsIgnoreCase("Time") ? (byte)1 : 0;
        dim.hies = new RelHierarchyImpl[x.hierarchies.length];
        for (int i = 0; i < dim.hies.length; ++i) {
            dim.hies[i] = RelSchemaBuilder.buildHierarchy(i, dim, x.hierarchies[i]);
        }
        return dim;
    }

    private static RelMeasureImpl buildMeasure(RelCubeImpl cube, MeasureDef x) throws OLAPException {
        RelMeasureImpl measure = new RelMeasureImpl(cube, x.name, x.caption, x.column, x.aggregator, x.formatString);
        measure.setProperty("color", x.color);
        measure.setProperty("bgColor", x.bgColor);
        if (!x.visible) {
            measure.setVisible(x.visible);
        } else {
            measure.setVisible(cube.schema.conn.isVisible(measure));
        }
        if (x.properties != null) {
            for (int i = 0; i < x.properties.length; ++i) {
                measure.setProperty(x.properties[i].name, x.properties[i].value);
            }
        }
        return measure;
    }
}

