/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColorUtil {
    private static HashMap colorMap = new HashMap();

    public static Color getColor(String color) {
        Color c = (Color)colorMap.get(color);
        if (c != null) {
            return c;
        }
        try {
            c = Color.decode(color);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        color = color.replaceAll("\\s*|\t|\n", "");
        Matcher m = Pattern.compile("rgb\\((\\d+)\\,(\\d+)\\,(\\d+)\\)", 2).matcher(color);
        if (m.find()) {
            String r = m.group(1);
            String g = m.group(2);
            String b = m.group(3);
            return new Color(Integer.parseInt(r), Integer.parseInt(g), Integer.parseInt(b));
        }
        return c;
    }

    static {
        colorMap.put("black", Color.black);
        colorMap.put("blue", Color.blue);
        colorMap.put("cyan", Color.cyan);
        colorMap.put("red", Color.red);
        colorMap.put("gray", Color.gray);
        colorMap.put("dark_gray", Color.DARK_GRAY);
        colorMap.put("light_gray", Color.LIGHT_GRAY);
        colorMap.put("red", Color.red);
        colorMap.put("green", Color.green);
        colorMap.put("magenta", Color.magenta);
        colorMap.put("orange", Color.orange);
        colorMap.put("pink", Color.pink);
        colorMap.put("white", Color.white);
        colorMap.put("yellow", Color.yellow);
    }
}

