/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.ui;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.print.config.attribute.PageRangeInfo;
import com.kingdee.bos.ctrl.print.config.attribute.PageRangeReverse;
import com.kingdee.bos.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.bos.ctrl.print.config.ui.SunPrintConfigDialog;
import com.kingdee.bos.ctrl.print.resource.Resources;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FilePermission;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class GeneralPanel
extends KDPanel {
    private static final long serialVersionUID = 4839284074086465214L;
    private PrintConfigModel model;
    private PrintService psCurrent;
    private PrintService[] services;
    private PrintRequestAttributeSet asCurrent;
    private int defaultServiceIndex;
    SunPrintConfigDialog configDialog;
    private PrintServicePanel pnlPrintService;
    private PrintRangePanel pnlPrintRange;
    private OtherPanel pnlCopies;
    private boolean isFrugalPrint = false;
    private int encodeType = 0;
    private int scale_edition_Type = 0;

    public GeneralPanel(PrintService[] services, PrintRequestAttributeSet attributes, int defaultServiceIndex, PrintConfigModel model) {
        this.setLayout(null);
        this.model = model;
        if (services != null && services.length != 0) {
            this.psCurrent = services[defaultServiceIndex];
        }
        this.services = services;
        this.asCurrent = new HashPrintRequestAttributeSet(attributes);
        this.defaultServiceIndex = defaultServiceIndex;
        this.pnlPrintService = new PrintServicePanel();
        this.pnlPrintRange = new PrintRangePanel();
        this.pnlCopies = new OtherPanel();
        this.add((Component)((Object)this.pnlPrintService));
        this.add((Component)((Object)this.pnlPrintRange));
        this.add((Component)((Object)this.pnlCopies));
        int x = 5;
        int y = 5;
        int h = this.pnlPrintService.getPreferredSize().height;
        int w = 395;
        this.pnlPrintService.setBounds(x, y, w, h);
        y = y + h + 5;
        this.pnlPrintRange.setBounds(x, y, 222, 180);
        this.pnlCopies.setBounds(x + 222 + 5, y, w - 222 - 5, 180);
        h = this.pnlPrintRange.getPreferredSize().height;
        h = y + 180 + 5 + 5;
        this.setPreferredSize(new Dimension(405, h));
        this.updateInfo();
    }

    public void setSunPrintConfig(SunPrintConfigDialog ui) {
        this.configDialog = ui;
    }

    public boolean isFrugalPrint() {
        return this.isFrugalPrint;
    }

    public boolean isPrintToFileSelected() {
        return this.pnlPrintService.isPrintToFileSelected();
    }

    public boolean isPrintDirect() {
        return this.pnlPrintService.isPrintDirect();
    }

    public void updateInfo() {
        this.pnlPrintService.updateInfo();
        this.pnlPrintRange.updateInfo();
        this.pnlCopies.updateInfo();
    }

    private void intiSides() {
        Class<Sides> siCategory = Sides.class;
        if (this.psCurrent != null && this.psCurrent.isAttributeCategorySupported(siCategory)) {
            Sides si = (Sides)this.asCurrent.get(siCategory);
            if (si == null) {
                si = (Sides)this.psCurrent.getDefaultAttributeValue(siCategory);
            }
            this.asCurrent.add(si);
        }
    }

    private static String getMsg(String key) {
        return Resources.getMsg(key);
    }

    public PrintService getPrintService() {
        return this.psCurrent;
    }

    public PrintRequestAttributeSet getAttributes() {
        return this.asCurrent;
    }

    public int getEncode() {
        return this.encodeType;
    }

    public int getScaleType() {
        return this.scale_edition_Type;
    }

    private class OtherPanel
    extends KDPanel
    implements ActionListener,
    ChangeListener {
        private static final long serialVersionUID = 5174448381385703636L;
        private final String strTitle = GeneralPanel.access$000("border.other");
        private SpinnerNumberModel snModel;
        private KDSpinner spinCopies;
        private JLabel lblCopies;
        private KDCheckBox cbCollate;
        private KDCheckBox cbFrugal;
        private KDComboBox cbEncode;
        private KDComboBox cbEdition;
        private boolean scSupported;

        public OtherPanel() {
            this.setOpaque(false);
            this.setLayout(SunPrintConfigDialog.LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            this.snModel = new SpinnerNumberModel(1, 1, 10000, 1);
            this.spinCopies = new KDSpinner((SpinnerModel)this.snModel);
            ((JSpinner.NumberEditor)this.spinCopies.getEditor()).getTextField().setColumns(3);
            this.spinCopies.addChangeListener((ChangeListener)this);
            String str = GeneralPanel.getMsg("label.numcopies");
            SunPrintConfigDialog.LinedLabel ll = SunPrintConfigDialog.L(str, (JComponent)this.spinCopies);
            this.lblCopies = ll.getBoundLabel();
            this.add((Component)((Object)ll));
            this.cbCollate = SunPrintConfigDialog.createCheckBox("checkbox.collate", this);
            this.cbCollate.setEnabled(false);
            this.add((Component)this.cbCollate);
            Object[] cbEncodeNames = new String[]{GeneralPanel.getMsg("comobox.encode_default"), GeneralPanel.getMsg("comobox.encode_GBK"), GeneralPanel.getMsg("comobox.encode_big5")};
            this.cbEncode = new KDComboBox(cbEncodeNames);
            this.cbEncode.addActionListener((ActionListener)this);
            str = GeneralPanel.getMsg("combox.encode_label");
            SunPrintConfigDialog.LinedLabel ll2 = SunPrintConfigDialog.L(str, (JComponent)this.cbEncode);
            this.add((Component)((Object)ll2));
            String ban = GeneralPanel.getMsg("label.ban");
            Object[] cbEditionNames = new String[]{"1 " + ban, "2 " + ban, "4 " + ban, "6 " + ban, "8 " + ban, "16 " + ban};
            this.cbEdition = new KDComboBox(cbEditionNames);
            this.cbEdition.addActionListener((ActionListener)this);
            str = GeneralPanel.getMsg("combox.edition_label");
            SunPrintConfigDialog.LinedLabel ll3 = SunPrintConfigDialog.L(str, (JComponent)this.cbEdition);
            this.add((Component)((Object)ll3));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cbCollate) {
                if (this.cbCollate.isSelected()) {
                    GeneralPanel.this.asCurrent.add(SheetCollate.COLLATED);
                } else {
                    GeneralPanel.this.asCurrent.add(SheetCollate.UNCOLLATED);
                }
            } else if (e.getSource() == this.cbFrugal) {
                if (this.cbFrugal.isSelected()) {
                    GeneralPanel.this.isFrugalPrint = true;
                } else {
                    GeneralPanel.this.isFrugalPrint = false;
                }
            } else if (e.getSource() == this.cbEncode) {
                GeneralPanel.this.encodeType = this.cbEncode.getSelectedIndex();
            } else if (e.getSource() == this.cbEdition) {
                int index = this.cbEdition.getSelectedIndex();
                switch (index) {
                    case 0: {
                        GeneralPanel.this.scale_edition_Type = 1;
                        break;
                    }
                    case 1: {
                        GeneralPanel.this.scale_edition_Type = 2;
                        break;
                    }
                    case 2: {
                        GeneralPanel.this.scale_edition_Type = 4;
                        break;
                    }
                    case 3: {
                        GeneralPanel.this.scale_edition_Type = 6;
                        break;
                    }
                    case 4: {
                        GeneralPanel.this.scale_edition_Type = 8;
                        break;
                    }
                    case 5: {
                        GeneralPanel.this.scale_edition_Type = 16;
                    }
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateCollateCB();
            GeneralPanel.this.asCurrent.add(new Copies(this.snModel.getNumber().intValue()));
        }

        private void updateCollateCB() {
            int num = this.snModel.getNumber().intValue();
            this.cbCollate.setEnabled(num > 1 && this.scSupported);
        }

        public void updateInfo() {
            SheetCollate sc;
            int max;
            int min;
            Copies cp;
            Class<Copies> cpCategory = Copies.class;
            Class<CopiesSupported> csCategory = CopiesSupported.class;
            Class<SheetCollate> scCategory = SheetCollate.class;
            boolean cpSupported = true;
            this.scSupported = true;
            if (GeneralPanel.this.psCurrent != null && !GeneralPanel.this.psCurrent.isAttributeCategorySupported(cpCategory)) {
                cpSupported = false;
            }
            CopiesSupported cs = null;
            if (GeneralPanel.this.psCurrent != null) {
                cs = (CopiesSupported)GeneralPanel.this.psCurrent.getDefaultAttributeValue(csCategory);
            }
            if (cs == null) {
                cs = new CopiesSupported(1, 10000);
            }
            if ((cp = (Copies)GeneralPanel.this.asCurrent.get(cpCategory)) == null) {
                if (GeneralPanel.this.psCurrent != null) {
                    cp = (Copies)GeneralPanel.this.psCurrent.getDefaultAttributeValue(cpCategory);
                }
                if (cp == null) {
                    cp = new Copies(1);
                }
            }
            this.spinCopies.setEnabled(cpSupported);
            this.lblCopies.setEnabled(cpSupported);
            int[][] members = cs.getMembers();
            if (members.length > 0 && members[0].length > 0) {
                min = members[0][0];
                max = members[0][1];
            } else {
                min = 1;
                max = Integer.MAX_VALUE;
            }
            int maxCopies = GeneralPanel.this.model.getMaxCopies();
            max = maxCopies < max ? maxCopies : max;
            this.snModel.setMinimum(new Integer(min));
            this.snModel.setMaximum(new Integer(max));
            int value = cp.getValue();
            if (value < min || value > max) {
                value = min;
            }
            this.snModel.setValue(new Integer(value));
            if (GeneralPanel.this.psCurrent != null && !GeneralPanel.this.psCurrent.isAttributeCategorySupported(scCategory)) {
                this.scSupported = false;
            }
            if ((sc = (SheetCollate)GeneralPanel.this.asCurrent.get(scCategory)) == null) {
                if (GeneralPanel.this.psCurrent != null) {
                    sc = (SheetCollate)GeneralPanel.this.psCurrent.getDefaultAttributeValue(scCategory);
                }
                if (sc == null) {
                    sc = SheetCollate.UNCOLLATED;
                }
            }
            this.cbCollate.setSelected(sc == SheetCollate.COLLATED);
            this.updateCollateCB();
            GeneralPanel.this.encodeType = GeneralPanel.this.model.getEncode();
            this.cbEncode.setSelectedIndex(GeneralPanel.this.encodeType);
            GeneralPanel.this.scale_edition_Type = GeneralPanel.this.model.getScaleType();
            int index = 0;
            switch (GeneralPanel.this.scale_edition_Type) {
                case 1: {
                    index = 0;
                    break;
                }
                case 2: {
                    index = 1;
                    break;
                }
                case 4: {
                    index = 2;
                    break;
                }
                case 6: {
                    index = 3;
                    break;
                }
                case 8: {
                    index = 4;
                    break;
                }
                case 16: {
                    index = 5;
                }
            }
            this.cbEdition.setSelectedIndex(index);
        }
    }

    private class PrintRangePanel
    extends KDPanel
    implements ActionListener,
    FocusListener,
    ItemListener {
        private static final long serialVersionUID = -7487778757673811495L;
        private final String strTitle = GeneralPanel.access$000("border.printrange");
        private final PageRanges prAll = new PageRanges(1, Integer.MAX_VALUE);
        private KDRadioButton rbAll;
        private KDRadioButton rbPages;
        private KDCheckBox oddEven;
        private KDCheckBox reverse;
        private KDComboBox cbOddEven;
        private KDCheckBox sidePrint;
        private KDComboBox cbSidePrint;
        private KDTextField range;
        private boolean prSupported;
        private JTextArea lblRangeTo;
        long lostTime = 0L;

        public PrintRangePanel() {
            this.setOpaque(false);
            this.setLayout(SunPrintConfigDialog.LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            ButtonGroup bg = new ButtonGroup();
            SunPrintConfigDialog.FixedPanel pnlTop = new SunPrintConfigDialog.FixedPanel();
            this.rbAll = SunPrintConfigDialog.createRadioButton("radiobutton.rangeall", this);
            this.rbAll.setSelected(true);
            bg.add((AbstractButton)this.rbAll);
            pnlTop.add((Component)this.rbAll);
            this.add((Component)((Object)pnlTop));
            SunPrintConfigDialog.FixedPanel pnlBottom = new SunPrintConfigDialog.FixedPanel();
            this.rbPages = SunPrintConfigDialog.createRadioButton("radiobutton.rangepages", this);
            bg.add((AbstractButton)this.rbPages);
            pnlBottom.add((Component)this.rbPages);
            this.range = new KDTextField(10);
            this.range.setEnabled(false);
            this.range.addActionListener((ActionListener)this);
            this.range.addFocusListener((FocusListener)this);
            pnlBottom.add((Component)this.range);
            this.add((Component)((Object)pnlBottom));
            SunPrintConfigDialog.FixedPanel pnl = new SunPrintConfigDialog.FixedPanel();
            this.lblRangeTo = new JTextArea(2, 17);
            this.lblRangeTo.setEditable(false);
            this.lblRangeTo.setText(GeneralPanel.getMsg("label.pageRangePrompt"));
            this.lblRangeTo.setOpaque(false);
            this.lblRangeTo.setLineWrap(true);
            this.lblRangeTo.setBorder(null);
            pnl.add(this.lblRangeTo);
            this.add((Component)((Object)pnl));
            TableLayout2 layout = new TableLayout2(1, 4);
            layout.setFixedWidth(0, 4);
            layout.setFixedWidth(1, 100);
            layout.setRatableWidth(2, 1);
            layout.setFixedWidth(3, 4);
            layout.setFixedHeight(0, 20);
            SunPrintConfigDialog.FixedPanel oddPanel = new SunPrintConfigDialog.FixedPanel();
            oddPanel.setLayout((LayoutManager)layout);
            this.oddEven = SunPrintConfigDialog.createCheckBox("radiobutton.oddevenpage", this);
            oddPanel.add((Component)this.oddEven, TableLayout2.param((int)0, (int)1));
            Object[] oddEvenNames = new String[]{GeneralPanel.getMsg("radiobutton.odd"), GeneralPanel.getMsg("radiobutton.even")};
            this.cbOddEven = new KDComboBox(oddEvenNames);
            this.cbOddEven.addActionListener((ActionListener)this);
            this.cbOddEven.setEnabled(false);
            oddPanel.add((Component)this.cbOddEven, TableLayout2.param((int)0, (int)2));
            this.add((Component)((Object)oddPanel));
            SunPrintConfigDialog.FixedPanel reversePanel = new SunPrintConfigDialog.FixedPanel();
            this.reverse = SunPrintConfigDialog.createCheckBox("checkbox.reversepage", this);
            reversePanel.add((Component)this.reverse);
            this.add((Component)((Object)reversePanel));
            SunPrintConfigDialog.FixedPanel sidePrintPanel = new SunPrintConfigDialog.FixedPanel();
            sidePrintPanel.setLayout((LayoutManager)layout);
            this.sidePrint = SunPrintConfigDialog.createCheckBox("checkbox.sidePrint", this);
            sidePrintPanel.add((Component)this.sidePrint, TableLayout2.param((int)0, (int)1));
            Object[] SideNames = new String[]{GeneralPanel.getMsg("combobox.left"), GeneralPanel.getMsg("combobox.up")};
            this.cbSidePrint = new KDComboBox(SideNames);
            this.cbSidePrint.addItemListener((ItemListener)this);
            this.cbSidePrint.setEnabled(false);
            sidePrintPanel.add((Component)this.cbSidePrint, TableLayout2.param((int)0, (int)2));
            this.add((Component)((Object)sidePrintPanel));
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source == this.cbSidePrint) {
                this.refreshSidePrint();
            }
        }

        private void refreshSidePrint() {
            if (this.cbSidePrint.getSelectedItem() == GeneralPanel.getMsg("combobox.up")) {
                GeneralPanel.this.asCurrent.add(Sides.TUMBLE);
            } else {
                GeneralPanel.this.asCurrent.add(Sides.DUPLEX);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            this.setupRangeWidgets();
            if (source == this.rbAll) {
                GeneralPanel.this.asCurrent.add(this.prAll);
            } else if (source == this.rbPages || source == this.range) {
                this.updateRangeAttribute();
            } else if (source == this.oddEven || source == this.cbOddEven) {
                if (this.oddEven.isSelected()) {
                    this.cbOddEven.setEnabled(true);
                    int index = this.cbOddEven.getSelectedIndex();
                    PageRangeInfo pageRangeInfo = new PageRangeInfo(2);
                    if (index == 0) {
                        pageRangeInfo.setParsingRangInfo("6");
                    } else {
                        pageRangeInfo.setParsingRangInfo("7");
                    }
                    GeneralPanel.this.asCurrent.add(pageRangeInfo);
                } else {
                    this.cbOddEven.setEnabled(false);
                    GeneralPanel.this.asCurrent.remove(PageRangeInfo.class);
                }
            } else if (source == this.reverse) {
                if (this.reverse.isSelected()) {
                    PageRangeReverse pageRangeReverse = new PageRangeReverse();
                    pageRangeReverse.setReverse(true);
                    GeneralPanel.this.asCurrent.add(pageRangeReverse);
                } else {
                    GeneralPanel.this.asCurrent.remove(PageRangeReverse.class);
                }
            } else if (source == this.sidePrint) {
                if (this.sidePrint.isSelected()) {
                    this.refreshSidePrint();
                } else {
                    GeneralPanel.this.asCurrent.remove(Sides.class);
                }
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source == this.range) {
                this.updateRangeAttribute();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        private void setupRangeWidgets() {
            boolean cbSidePrintEnabled;
            boolean rangeEnabled = this.rbPages.isSelected() && this.prSupported;
            this.range.setEnabled(rangeEnabled);
            boolean oddEvenEnabled = this.oddEven.isSelected() && this.prSupported;
            this.cbOddEven.setEnabled(oddEvenEnabled);
            boolean sidePrintEnabled = GeneralPanel.this.psCurrent.isAttributeCategorySupported(Sides.class) && this.prSupported;
            this.sidePrint.setEnabled(sidePrintEnabled);
            if (!sidePrintEnabled) {
                this.sidePrint.setSelected(false);
            }
            boolean bl = cbSidePrintEnabled = sidePrintEnabled && this.sidePrint.isSelected();
            if (cbSidePrintEnabled) {
                this.refreshSidePrint();
            }
            this.cbSidePrint.setEnabled(cbSidePrintEnabled);
        }

        private void updateRangeAttribute() {
            String rangeStr = this.range.getText();
            if (!"".equals(rangeStr)) {
                try {
                    PageRanges pr = new PageRanges(rangeStr);
                    GeneralPanel.this.asCurrent.add(pr);
                }
                catch (IllegalArgumentException e) {
                    long diff = System.currentTimeMillis() - this.lostTime;
                    if (diff > 300L) {
                        KDOptionPane.showMessageDialog((Component)((Object)this), (Object)GeneralPanel.getMsg("label.pageRangeWarning"), (String)GeneralPanel.getMsg("dialog.waring"), (int)2);
                        this.lostTime = System.currentTimeMillis();
                    }
                    this.range.grabFocus();
                    this.range.selectAll();
                }
            } else {
                GeneralPanel.this.asCurrent.remove(PageRanges.class);
            }
        }

        public void updateInfo() {
            Class<PageRanges> prCategory = PageRanges.class;
            Class<PageRangeInfo> priCategory = PageRangeInfo.class;
            this.prSupported = true;
            if (GeneralPanel.this.psCurrent != null && !GeneralPanel.this.psCurrent.isAttributeCategorySupported(prCategory)) {
                this.prSupported = false;
            }
            PageRanges pr = (PageRanges)GeneralPanel.this.asCurrent.get(prCategory);
            PageRangeInfo pri = (PageRangeInfo)GeneralPanel.this.asCurrent.get(priCategory);
            if (pr != null) {
                if (pr.equals(this.prAll)) {
                    this.rbAll.setSelected(true);
                } else {
                    this.rbPages.setSelected(true);
                    this.range.setText(pr.toString());
                }
            } else if (pri != null) {
                this.oddEven.setSelected(true);
                int irange = Integer.parseInt((String)pri.getRageRanges());
                if (irange == 6) {
                    this.cbOddEven.setSelectedIndex(0);
                } else {
                    this.cbOddEven.setSelectedIndex(1);
                }
            } else {
                this.rbAll.setSelected(true);
                this.range.setText("");
            }
            this.rbAll.setEnabled(this.prSupported);
            this.rbPages.setEnabled(this.prSupported);
            this.oddEven.setEnabled(this.prSupported);
            this.setupRangeWidgets();
        }
    }

    public class PrintServicePanel
    extends KDPanel
    implements ActionListener,
    ItemListener,
    PopupMenuListener {
        private static final long serialVersionUID = -6930652844850698265L;
        private final String strTitle = GeneralPanel.access$000("border.printservice");
        private FilePermission printToFilePermission;
        private KDButton btnProperties;
        private KDCheckBox cbPrintToFile;
        private KDComboBox cbName;
        private KDLabel lblStatus;
        private ServiceUIFactory uiFactory;
        private boolean changedService = false;
        private KDCheckBox printDirect;

        public PrintServicePanel() {
            if (GeneralPanel.this.psCurrent != null) {
                this.uiFactory = GeneralPanel.this.psCurrent.getServiceUIFactory();
            }
            this.setOpaque(false);
            this.setLayout(SunPrintConfigDialog.LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            Object[] psnames = new String[GeneralPanel.this.services.length];
            for (int i = 0; i < psnames.length; ++i) {
                psnames[i] = GeneralPanel.this.services[i].getName();
            }
            this.cbName = new KDComboBox(psnames);
            if (GeneralPanel.this.psCurrent != null) {
                this.cbName.setSelectedIndex(GeneralPanel.this.defaultServiceIndex);
                this.cbName.addItemListener((ItemListener)this);
                this.cbName.addPopupMenuListener((PopupMenuListener)this);
            }
            String str = GeneralPanel.getMsg("label.psname");
            this.add((Component)((Object)SunPrintConfigDialog.L(str, (JComponent)this.cbName)));
            this.btnProperties = SunPrintConfigDialog.createButton("button.properties", this);
            str = GeneralPanel.getMsg("label.status");
            this.lblStatus = new KDLabel();
            this.add((Component)((Object)SunPrintConfigDialog.L(str, (JComponent)this.lblStatus)));
            this.cbPrintToFile = SunPrintConfigDialog.createCheckBox("checkbox.printtofile", this);
            this.printDirect = new KDCheckBox(GeneralPanel.getMsg("checkbox.directPrint"));
            this.printDirect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    GeneralPanel.this.model.setPrintDirect(PrintServicePanel.this.printDirect.isSelected());
                }
            });
            this.printDirect.setSelected(GeneralPanel.this.model.getPrintDirect());
            this.printDirect.setBounds(0, 0, 30, 15);
            this.add((Component)this.printDirect);
        }

        public boolean isPrintToFileSelected() {
            return this.cbPrintToFile.isSelected();
        }

        public boolean isPrintDirect() {
            return this.printDirect.isSelected();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.btnProperties && this.uiFactory != null) {
                JDialog dialog = (JDialog)this.uiFactory.getUI(3, "javax.swing.JDialog");
                if (dialog != null) {
                    dialog.setVisible(true);
                } else {
                    this.btnProperties.setEnabled(false);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            int index;
            if (e.getStateChange() == 1 && (index = this.cbName.getSelectedIndex()) >= 0 && index < GeneralPanel.this.services.length && !GeneralPanel.this.services[index].equals(GeneralPanel.this.psCurrent)) {
                GeneralPanel.this.psCurrent = GeneralPanel.this.services[index];
                if (GeneralPanel.this.configDialog != null) {
                    GeneralPanel.this.configDialog.setPrintService(GeneralPanel.this.psCurrent);
                }
                this.uiFactory = GeneralPanel.this.psCurrent.getServiceUIFactory();
                this.changedService = true;
                PrinterIsAcceptingJobs status = GeneralPanel.this.psCurrent.getAttribute(PrinterIsAcceptingJobs.class);
                if (status != null) {
                    this.lblStatus.setText(GeneralPanel.getMsg(((Object)status).toString()));
                    GeneralPanel.this.pnlPrintRange.setupRangeWidgets();
                }
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.changedService = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (this.changedService) {
                this.changedService = false;
                if (GeneralPanel.this.configDialog != null) {
                    GeneralPanel.this.configDialog.updatePanels();
                }
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        private boolean allowedToPrintToFile() {
            try {
                this.throwPrintToFile();
                return true;
            }
            catch (SecurityException e) {
                return false;
            }
        }

        private void throwPrintToFile() {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                if (this.printToFilePermission == null) {
                    this.printToFilePermission = new FilePermission("<<ALL FILES>>", "read,write");
                }
                security.checkPermission(this.printToFilePermission);
            }
        }

        public void updateInfo() {
            Destination dst;
            if (GeneralPanel.this.psCurrent == null) {
                return;
            }
            Class<Destination> dstCategory = Destination.class;
            boolean dstSupported = false;
            boolean dstSelected = false;
            boolean dstAllowed = this.allowedToPrintToFile();
            if (GeneralPanel.this.psCurrent.isAttributeCategorySupported(dstCategory)) {
                dstSupported = true;
            }
            if ((dst = (Destination)GeneralPanel.this.asCurrent.get(dstCategory)) != null) {
                dstSelected = true;
            }
            this.cbPrintToFile.setEnabled(dstSupported && dstAllowed);
            this.cbPrintToFile.setSelected(dstSelected && dstAllowed);
            PrinterIsAcceptingJobs status = GeneralPanel.this.psCurrent.getAttribute(PrinterIsAcceptingJobs.class);
            if (status != null) {
                this.lblStatus.setText(GeneralPanel.getMsg(((Object)status).toString()));
            }
            this.btnProperties.setEnabled(this.uiFactory != null);
        }
    }
}

