/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.xml;

import com.kingdee.bos.ctrl.common.util.EASEditionUtil;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.bos.ctrl.print.config.xml.AbstractPrintAttributeTranslate;
import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.component.MixVariantLabelCell;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Color;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;
import org.jdom2.Content;
import org.jdom2.Element;

public class PageSetupTranslate
extends AbstractPrintAttributeTranslate {
    public static String NAME = "general";

    public PageSetupTranslate(IConfigModel model) {
        super(model);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object fromXmlElement(Element element) {
        super.fromXmlElement(element);
        if (element == null) {
            return null;
        }
        if (!element.getName().equals(NAME)) {
            return null;
        }
        this.fromPrintAttributes(PageSetupTranslate.getChild(element, "attributeSet"));
        this.fromFrugal(PageSetupTranslate.getChild(element, "frugal"));
        this.fromWaterMark(PageSetupTranslate.getChild(element, "watermark"));
        this.fromBackGroundColor(PageSetupTranslate.getChild(element, "backgroundcolor"));
        this.fromBackGroundInfo(PageSetupTranslate.getChild(element, "backgroundinfo"));
        this.fromCenterAlign(PageSetupTranslate.getChild(element, "center_align"));
        this.fromFootAlign(PageSetupTranslate.getChild(element, "foot_align"));
        this.fromHeadAlign(PageSetupTranslate.getChild(element, "head_align"));
        return this;
    }

    private void fromCenterAlign(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        int model = PageSetupModel.CENTERALIGN_DEFAULT;
        if (child != null) {
            model = Integer.parseInt(child.getText());
        }
        configModel.setCenterAlign(model);
    }

    private void fromFootAlign(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        int model = 0;
        if (child != null) {
            model = Integer.parseInt(child.getText());
        }
        configModel.setFooterAlign(model);
    }

    private void fromHeadAlign(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        int model = 0;
        if (child != null) {
            model = Integer.parseInt(child.getText());
        }
        configModel.setHeaderAlign(model);
    }

    private void fromFrugal(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        if (child == null) {
            configModel.setFrugalPrint(false);
        } else {
            String text = child.getText();
            if (text.equals("true")) {
                configModel.setFrugalPrint(true);
            } else {
                configModel.setFrugalPrint(false);
            }
        }
    }

    private void fromPrintAttributes(Element child) {
        List children = child.getChildren();
        PageSetupModel configModel = (PageSetupModel)this.model;
        PrintRequestAttributeSet set = configModel.getPrintRequestAttributeSet();
        int length = children.size();
        for (int i = 0; i < length; ++i) {
            Element childElement = (Element)children.get(i);
            Attribute attri = PageSetupTranslate.fromPrintAttribute(childElement);
            if (attri == null) continue;
            set.add(attri);
        }
    }

    private void fromWaterMark(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        if (child == null) {
            configModel.getWaterMark().setText(null);
            configModel.getWaterMark().setStyle(PageSetupModel.WATERMARK_DEFAULTSTYLE);
            configModel.setWaterMark_onlyFirstPage(false);
        } else {
            MixVariantLabelCell waterMark = configModel.getWaterMark();
            ((LabelCell)waterMark).setText(child.getAttributeValue("text"));
            String isFirstPage = child.getAttributeValue("firstPage");
            configModel.setWaterMark_onlyFirstPage(isFirstPage.equals("true"));
            Element style = child.getChild("Style");
            if (style != null) {
                StyleAttributes style1 = StyleParser.parseSA((Element)style);
                waterMark.setStyle(Styles.getStyle((ShareStyleAttributes)style1));
            } else {
                waterMark.setStyle(PageSetupModel.WATERMARK_DEFAULTSTYLE);
            }
        }
    }

    private void fromBackGroundColor(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        if (child == null) {
            configModel.setBackGroundColor(null);
        } else {
            configModel.setBackGroundColor(KDPrinterUtils.hexToColor(child.getText()));
        }
    }

    private void fromBackGroundInfo(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        if (child == null) {
            configModel.setBackGround(null);
        } else {
            configModel.setImagePath(child.getAttributeValue("path"));
            configModel.setBackGroundFillMode(Byte.parseByte(child.getAttributeValue("fillmode")));
        }
    }

    @Override
    public Element toXmlElement() {
        PageSetupModel configModel = (PageSetupModel)this.model;
        this.toPrintAttributes(configModel.getPrintRequestAttributeSet());
        this.toFrugal(configModel.isFrugalPrint());
        try {
            if (EASEditionUtil.getEditionType() == 0) {
                this.toWaterMark(configModel);
            }
        }
        catch (Exception ex) {
            this.toWaterMark(configModel);
        }
        this.toBackGroundColor(configModel.getBackGroundColor());
        this.toBackGroundInfo(configModel.getImagePath(), configModel.getBackGroundFillMode());
        this.toCenterAlign(configModel.getCenterAlign());
        this.toFooterAlign(configModel.getFooterAlign());
        this.toHeaderAlign(configModel.getHeaderAlign());
        return this.rootElement;
    }

    private void toWaterMark(PageSetupModel configModel) {
        MixVariantLabelCell waterMark = configModel.getWaterMark();
        boolean isFirstPage = configModel.isWaterMark_onlyFirstPage();
        if (waterMark != null && waterMark.getText() != null && !waterMark.getText().equals("")) {
            Element e = PageSetupTranslate.createElement("watermark");
            e.setAttribute("text", waterMark.getText());
            e.setAttribute("firstPage", isFirstPage ? "true" : "false");
            if (waterMark.getStyle() != PageSetupModel.WATERMARK_DEFAULTSTYLE) {
                Element eleStyle = StyleParser.getStyleElement((ShareStyleAttributes)waterMark.getStyle(), (String)"", null);
                e.addContent((Content)eleStyle);
            }
            this.rootElement.addContent((Content)e);
        }
    }

    private void toBackGroundColor(Color backGroundColor) {
        if (backGroundColor != null) {
            Element e = PageSetupTranslate.createElement("backgroundcolor");
            e.setText(KDPrinterUtils.colorToHex(backGroundColor));
            this.rootElement.addContent((Content)e);
        }
    }

    private void toBackGroundInfo(String imagePath, byte backGroundFillMode) {
        if (imagePath != null) {
            Element e = PageSetupTranslate.createElement("backgroundinfo");
            e.setAttribute("path", imagePath);
            if (backGroundFillMode == 0) {
                e.setAttribute("fillmode", String.valueOf(0));
            } else if (backGroundFillMode == 1) {
                e.setAttribute("fillmode", String.valueOf(1));
            } else {
                e.setAttribute("fillmode", String.valueOf(2));
            }
            this.rootElement.addContent((Content)e);
        }
    }

    private void toFrugal(boolean isFrugal) {
        if (isFrugal) {
            Element e = PageSetupTranslate.createElement("frugal");
            e.setText("true");
            this.rootElement.addContent((Content)e);
        }
    }

    private void toCenterAlign(int centerAlign) {
        if (centerAlign != PageSetupModel.CENTERALIGN_DEFAULT) {
            Element e = PageSetupTranslate.createElement("center_align");
            e.setText(String.valueOf(centerAlign));
            this.rootElement.addContent((Content)e);
        }
    }

    private void toFooterAlign(int footerAlign) {
        if (footerAlign != 0) {
            Element e = PageSetupTranslate.createElement("foot_align");
            e.setText(String.valueOf(footerAlign));
            this.rootElement.addContent((Content)e);
        }
    }

    private void toHeaderAlign(int headerAlign) {
        if (headerAlign != 0) {
            Element e = PageSetupTranslate.createElement("head_align");
            e.setText(String.valueOf(headerAlign));
            this.rootElement.addContent((Content)e);
        }
    }
}

