/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.font.CIDFontMapping;
import org.apache.pdfbox.pdmodel.font.FontMapper;
import org.apache.pdfbox.pdmodel.font.FontMapping;
import org.apache.pdfbox.pdmodel.font.PDCIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;

public class KDPDFBoxFontMapper
implements FontMapper {
    private FontMapper fontMapper;

    public KDPDFBoxFontMapper(FontMapper fontMapper) {
        this.fontMapper = fontMapper;
    }

    public FontMapping<TrueTypeFont> getTrueTypeFont(String s, PDFontDescriptor pdFontDescriptor) {
        return this.fontMapper.getTrueTypeFont(s, pdFontDescriptor);
    }

    public FontMapping<FontBoxFont> getFontBoxFont(String s, PDFontDescriptor pdFontDescriptor) {
        return this.fontMapper.getFontBoxFont(s, pdFontDescriptor);
    }

    public CIDFontMapping getCIDFont(String s, PDFontDescriptor pdFontDescriptor, PDCIDSystemInfo pdcidSystemInfo) {
        String name = this.validFontName(s);
        if (name.equalsIgnoreCase("\u5b8b\u4f53")) {
            name = "SimSun";
        } else if (s.equalsIgnoreCase("\u5b8b\u4f53,Bold")) {
            name = "SimSunBold";
        } else if (s.equalsIgnoreCase("FZSongTi")) {
            name = "SimSun";
        } else if (name.equalsIgnoreCase("\u65b0\u5b8b\u4f53")) {
            name = "NSimSun";
        } else if (name.equalsIgnoreCase("\u65b0\u5b8b\u4f53,Bold")) {
            name = "NSimSun";
        }
        return this.fontMapper.getCIDFont(name, pdFontDescriptor, pdcidSystemInfo);
    }

    private String validFontName(String fontName) {
        byte[] src = fontName.getBytes(Charset.forName("Windows-1252"));
        boolean window1252 = false;
        try {
            window1252 = fontName.equals(new String(src, "Windows-1252"));
            if (window1252 && this.isValidGBK(src)) {
                return new String(src, "GBK");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return fontName;
    }

    private boolean isValidGBK(byte[] input) {
        try {
            Charset.forName("GBK").newDecoder().decode(ByteBuffer.wrap(input));
            return true;
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }
}

