/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import com.kingdee.bos.ctrl.swing.dial.DialBawPaint;
import com.kingdee.bos.ctrl.swing.dial.KpiDial;
import com.kingdee.bos.ctrl.swing.dial.KpiNeedle;
import com.kingdee.bos.ctrl.swing.dial.KpiPan;
import com.kingdee.bos.ctrl.swing.dial.KpiScale;
import com.kingdee.bos.ctrl.swing.dial.KpiTitle;
import com.kingdee.bos.ctrl.swing.dial.resource.DialResourceManager;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;

public class KpiDialHelper {
    protected static final List parts = new ArrayList();
    public static final PartKey PAN = new PartKey("PAN");
    public static final PartKey PAN_BORDER = new PartKey("PAN_BORDER");
    public static final PartKey NEEDLE = new PartKey("NEEDLE");
    public static final PartKey NEEDLE_BORDER = new PartKey("NEEDLE_BORDER");
    public static final PartKey SCALE = new PartKey("SCALE");
    public static final PartKey SCALE_NORMAL = new PartKey("SCALE_NORMAL");
    public static final PartKey SCALE_WARNING = new PartKey("SCALE_WARNING");
    public static final PartKey SCALE_CRITICAL = new PartKey("SCALE_CRITICAL");
    public static final PartKey SCALE_TICK = new PartKey("SCALE_TICK");
    public static final PartKey SCALE_LABEL = new PartKey("SCALE_LABEL");
    public static final PartKey SCALE_LABELSHADOW = new PartKey("SCALE_LABELSHADOW");
    public static final PartKey TITLE_BORDER = new PartKey("TITLE_BORDER");

    public static PartKey[] getParts() {
        int size = parts.size();
        PartKey[] keys = null;
        if (size > 0) {
            keys = new PartKey[size];
            for (int i = 0; i < size; ++i) {
                keys[i] = (PartKey)parts.get(i);
            }
        }
        return keys;
    }

    public static void setPaint(KpiDial dial, Paint paint, PartKey key) {
        if (dial == null || paint == null) {
            return;
        }
        if (key == PAN) {
            dial.getKpiPan().setFillPaint(paint);
        } else if (key == PAN_BORDER) {
            dial.getKpiPan().setBorderPaint(paint);
        } else if (key == NEEDLE) {
            dial.getNeedle().setFillPaint(paint);
        } else if (key == NEEDLE_BORDER) {
            dial.getNeedle().setBorderPaint(paint);
        } else if (key == SCALE) {
            dial.getScale().setDefaultPaint(paint);
        } else if (key == SCALE_NORMAL) {
            dial.getScale().setNormalPaint(paint);
        } else if (key == SCALE_WARNING) {
            dial.getScale().setWarningPaint(paint);
        } else if (key == SCALE_CRITICAL) {
            dial.getScale().setCriticalPaint(paint);
        } else if (key == SCALE_TICK) {
            dial.getScale().setTicksPaint(paint);
        } else if (key == SCALE_LABEL) {
            dial.getScale().setTickLabelPaint(paint);
        } else if (key == SCALE_LABELSHADOW) {
            dial.getScale().setLabelShadowPaint(paint);
        } else if (key == TITLE_BORDER) {
            dial.getKpiTitle().setOutlinePaint(paint);
        }
    }

    public static Paint getPaint(KpiDial dial, PartKey key) {
        if (dial == null) {
            return null;
        }
        Paint paint = null;
        if (key == PAN) {
            paint = dial.getKpiPan().getFillPaint();
        } else if (key == PAN_BORDER) {
            paint = dial.getKpiPan().getBorderPaint();
        } else if (key == NEEDLE) {
            paint = dial.getNeedle().getFillPaint();
        } else if (key == NEEDLE_BORDER) {
            paint = dial.getNeedle().getBorderPaint();
        } else if (key == SCALE) {
            paint = dial.getScale().getDefaultPaint();
        } else if (key == SCALE_NORMAL) {
            paint = dial.getScale().getNormalPaint();
        } else if (key == SCALE_WARNING) {
            paint = dial.getScale().getWarningPaint();
        } else if (key == SCALE_CRITICAL) {
            paint = dial.getScale().getCriticalPaint();
        } else if (key == SCALE_TICK) {
            paint = dial.getScale().getTicksPaint();
        } else if (key == SCALE_LABEL) {
            paint = dial.getScale().getTickLabelPaint();
        } else if (key == SCALE_LABELSHADOW) {
            paint = dial.getScale().getLabelShadowPaint();
        } else if (key == TITLE_BORDER) {
            paint = dial.getKpiTitle().getOutlinePaint();
        }
        return paint;
    }

    public static void setDefaultBawPaint(KpiDial dial) {
        if (dial == null) {
            return;
        }
        dial.getKpiPan().setFillPaint(DialBawPaint.createPaint(6));
        dial.getKpiPan().setBorderPaint(Color.BLACK);
        dial.getNeedle().setFillPaint(Color.WHITE);
        dial.getNeedle().setBorderPaint(Color.BLACK);
        dial.getScale().setDefaultPaint(Color.BLACK);
        dial.getScale().setNormalPaint(DialBawPaint.createPaint(10));
        dial.getScale().setWarningPaint(DialBawPaint.createPaint(8));
        dial.getScale().setCriticalPaint(DialBawPaint.createPaint(1));
        dial.getScale().setTicksPaint(Color.BLACK);
        dial.getScale().setTickLabelPaint(Color.WHITE);
        dial.getScale().setLabelShadowPaint(Color.BLACK);
        dial.getKpiTitle().setOutlinePaint(Color.BLACK);
    }

    public static void setDefaultPaint(KpiDial dial) {
        if (dial == null) {
            return;
        }
        dial.getKpiPan().setFillPaint(KpiPan.FILLCOLOR);
        dial.getKpiPan().setBorderPaint(KpiPan.BORDERCOLOR);
        dial.getNeedle().setFillPaint(KpiNeedle.NEEDLE_FORE);
        dial.getNeedle().setBorderPaint(KpiNeedle.NEEDLE_BACK);
        dial.getScale().setDefaultPaint(KpiScale.DEFAULTPAINT);
        dial.getScale().setNormalPaint(DialResourceManager.getKpiScaleNormalColor(""));
        dial.getScale().setWarningPaint(DialResourceManager.getKpiScaleWarningColor(""));
        dial.getScale().setCriticalPaint(DialResourceManager.getKpiScaleCriticalColor(""));
        dial.getScale().setTicksPaint(Color.GRAY);
        dial.getScale().setTickLabelPaint(Color.WHITE);
        dial.getScale().setLabelShadowPaint(KpiScale.DEFAULTPAINT);
        dial.getKpiTitle().setOutlinePaint(KpiTitle.TITLE_BORDER_COLOR);
    }

    public static class PartKey {
        private String name = "";

        public PartKey(String name) {
            this.name = name;
            parts.add(this);
        }

        public String toString() {
            return this.name;
        }
    }
}

