/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.event;

import java.awt.Font;
import java.util.EventObject;

public class FontChangeEvent
extends EventObject {
    public static int Name_Changed = 1;
    public static int Size_Changed = 2;
    public static int Style_Changed = 4;
    private static final long serialVersionUID = 5325326802884823483L;
    private Font oldFont;
    private Font newFont;
    private int changeBit = 0;

    public FontChangeEvent(Object source, Font oldFont, Font newFont) {
        this(source, oldFont, newFont, -1);
    }

    public FontChangeEvent(Object source, Font oldFont, Font newFont, int changeBit) {
        super(source);
        this.oldFont = oldFont;
        this.newFont = newFont;
        this.changeBit = changeBit;
    }

    public boolean isFamilyChanged() {
        return !this.getNewFamily().equals(this.getOldFamily());
    }

    public boolean isSizeChanged() {
        return this.getNewSize() != this.getOldSize();
    }

    public boolean isStyleChanged() {
        return this.getNewStyle() != this.getOldStyle();
    }

    public String getOldFamily() {
        return this.oldFont.getFamily();
    }

    public int getOldSize() {
        return this.oldFont.getSize();
    }

    public int getOldStyle() {
        return this.oldFont.getStyle();
    }

    public Font getOldFont() {
        return this.oldFont;
    }

    public String getNewFamily() {
        return this.newFont.getFamily();
    }

    public int getNewSize() {
        return this.newFont.getSize();
    }

    public int getNewStyle() {
        return this.newFont.getStyle();
    }

    public Font getNewFont() {
        return this.newFont;
    }

    public boolean isChange(int changeBit) {
        return (this.changeBit & changeBit) != 0;
    }
}

