/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.plaf.ImageArrowButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class KingdeeContainerUI
extends ComponentUI {
    protected static final int TITLEHEIGHT = 19;
    protected static final int TITLE_PANE_INSETS = 0;
    protected static final int TITLE_BUTTON_INSETS = 3;
    protected static final int TITLE_LABEL_INSETS = 2;
    private static final int TitleMinWidth = 156;
    private static final int TitleBottomInterval = 1;
    private static final int ChildBuHgap = 2;
    private static final int BoundsInterva = 8;
    private Color contentBackground;
    private Color labelBackColor;
    private Color outerTopColor;
    private Color outerBottomColor;
    private Color innerTopColor;
    private Color innerBottomColor;
    protected JPanel titlePane;
    protected BigArrowButton titleButton;
    protected JLabel titleLabel;
    protected JLabel msgLabel;
    protected KDContainer comp;
    protected ContainerLayout containerLayout;
    protected TitleLayout titleLayout;
    protected TitleButtonHandler titleButtonHandler;
    protected PropertyChangeListener propertyHandler;
    private boolean isDrawArrowBu = true;
    private boolean isDrawBorder = true;
    private boolean reseted = false;
    private int spreadHeight = 19;

    public static ComponentUI createUI(JComponent c) {
        return new KingdeeContainerUI(c);
    }

    public KingdeeContainerUI(JComponent c) {
    }

    @Override
    public void installUI(JComponent c) {
        this.comp = (KDContainer)c;
        this.installDefaults(this.comp);
        this.installComponents(this.comp);
        this.installListeners(this.comp);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults(this.comp);
        this.unInstallListeners(this.comp);
    }

    protected void installDefaults(KDContainer c) {
        if (c.getTitleStyle() == 2) {
            this.isDrawBorder = false;
        }
        this.labelBackColor = UIManager.getColor("KDContainer.labelBackColor");
        this.outerTopColor = UIManager.getColor("KDContainer.outerTopColor");
        this.outerBottomColor = UIManager.getColor("KDContainer.outerBottomColor");
        this.innerTopColor = UIManager.getColor("KDContainer.innerTopColor");
        this.innerBottomColor = UIManager.getColor("KDContainer.innerBottomColor");
        this.contentBackground = UIManager.getColor("KDContainer.contentBackground");
        if (!this.isDrawBorder) {
            this.comp.setBorder(BorderFactory.createLineBorder(this.comp.getParent().getBackground()));
        } else {
            this.comp.setBorder(BorderFactory.createLineBorder(UIManager.getColor("KDContainer.borderColor")));
        }
    }

    protected void installComponents(KDContainer c) {
        this.titleButton = new BigArrowButton(c, 5);
        this.titleButton.setPreferredSize(new Dimension(19, 19));
        this.titleButton.setMinimumSize(new Dimension(19, 19));
        this.titleButton.setMaximumSize(new Dimension(19, 19));
        this.titleLabel = new TitleLabel(c, c.getTitle());
        this.titleLabel.setHorizontalAlignment(2);
        this.titlePane = new JPanel();
        this.titleLayout = new TitleLayout();
        this.titlePane.setLayout(this.titleLayout);
        this.titlePane.add(this.titleButton);
        this.titlePane.add(this.titleLabel);
        this.titlePane.setOpaque(false);
        JPanel cp = c.getContentPane();
        ((Component)cp).setBackground(this.contentBackground);
        c.setContentPane(cp);
        this.containerLayout = new ContainerLayout();
        c.setLayout(this.containerLayout);
        c.add(this.titlePane);
        c.setBackground(this.contentBackground);
        c.add(cp);
    }

    protected void installListeners(KDContainer c) {
        this.titleButtonHandler = new TitleButtonHandler();
        this.titleButton.addActionListener(this.titleButtonHandler);
        this.propertyHandler = new PropertyChangeHandler();
        c.addPropertyChangeListener(this.propertyHandler);
    }

    protected void unInstallListeners(KDContainer c) {
        if (this.titleButtonHandler != null) {
            this.titleButton.removeActionListener(this.titleButtonHandler);
            this.titleButtonHandler = null;
        }
        if (this.propertyHandler != null) {
            c.removePropertyChangeListener(this.propertyHandler);
            this.propertyHandler = null;
        }
    }

    protected void uninstallDefaults(KDContainer c) {
        c.setLayout(null);
        c.removeAll();
        this.titlePane.setLayout(null);
        this.titlePane.removeAll();
    }

    protected void setSpreadHeight(int h) {
        this.reseted = true;
        this.spreadHeight = h < 19 ? 19 : h;
    }

    protected int getSpreadHeight() {
        return this.spreadHeight;
    }

    public Color getInnerBottomColor() {
        return this.innerBottomColor;
    }

    public Color getInnerTopColor() {
        return this.innerTopColor;
    }

    public Color getLabelBackColor() {
        return this.labelBackColor;
    }

    public Color getOuterBottomColor() {
        return this.outerBottomColor;
    }

    public Color getOuterTopColor() {
        return this.outerTopColor;
    }

    public class BigArrowButton
    extends ImageArrowButton {
        private static final long serialVersionUID = -1660576065057393827L;
        KDContainer container;

        public BigArrowButton(KDContainer c, int direction) {
            super(direction);
            this.container = c;
        }

        @Override
        protected Dimension getIconSize() {
            return new Dimension(11, 11);
        }

        @Override
        public void paint(Graphics g) {
            int style = this.container.getTitleStyle();
            if (style == 1 || style == 2) {
                int w = this.getSize().width;
                int h = this.getSize().height;
                boolean isPressed = this.getModel().isPressed();
                Color origColor = g.getColor();
                if (style == 2) {
                    if (this.container.isOpaque()) {
                        g.setColor(this.container.getBackground());
                    } else {
                        g.setColor(this.container.getParent().getBackground());
                    }
                } else {
                    g.setColor(KingdeeContainerUI.this.getLabelBackColor());
                }
                g.fillRect(0, 0, w, h);
                if (style == 1) {
                    int x1 = 0;
                    int y1 = 0;
                    int x2 = x1 + w - 1;
                    int y2 = y1 + h - 1;
                    g.setColor(KingdeeContainerUI.this.getOuterTopColor());
                    g.drawLine(x1, y1, x2, y1);
                    g.drawLine(x1, y2, x1, y1 + 1);
                    g.setColor(KingdeeContainerUI.this.getInnerTopColor());
                    g.drawLine(x1 + 1, y1 + 1, x2, y1 + 1);
                    g.drawLine(x1 + 1, y2 - 1, x1 + 1, y1 + 2);
                    g.setColor(KingdeeContainerUI.this.getOuterBottomColor());
                    g.drawLine(x1, y2, x2, y2);
                    g.setColor(KingdeeContainerUI.this.getInnerBottomColor());
                    g.drawLine(x1 + 1, y2 - 1, x2, y2 - 1);
                }
                if (isPressed) {
                    g.translate(1, 1);
                }
                if (KingdeeContainerUI.this.isDrawArrowBu) {
                    this.paintTriangle(g, (w - this.iconSize.width + 2) / 2, (h - this.iconSize.height + 2) / 2, true);
                }
                if (isPressed) {
                    g.translate(-1, -1);
                }
                g.setColor(origColor);
            } else {
                super.paint(g);
            }
        }

        @Override
        public void paintTriangle(Graphics g, int x, int y, boolean isEnabled) {
            Icon triangle = UIManager.getIcon("KDContainer.forbitIcon");
            if (this.container.getTitleStyle() == 0 || this.container.isEnableActive()) {
                switch (this.direction) {
                    case 1: {
                        triangle = UIManager.getIcon("KDContainer.upOpenIcon");
                        break;
                    }
                    case 5: {
                        triangle = UIManager.getIcon("KDContainer.openIcon");
                        break;
                    }
                    case 7: {
                        triangle = UIManager.getIcon("KDContainer.closeIcon");
                    }
                }
            }
            x = (this.getWidth() - triangle.getIconWidth()) / 2;
            y = (this.getHeight() - triangle.getIconHeight()) / 2;
            triangle.paintIcon(this, g, x, y);
        }
    }

    public class TitleLabel
    extends JLabel {
        private static final long serialVersionUID = -5352906349336457870L;
        protected KDContainer container;

        public TitleLabel(KDContainer c, String text) {
            super(text);
            this.container = c;
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 19));
        }

        @Override
        protected void paintComponent(Graphics g) {
            int style = this.container.getTitleStyle();
            if (style == 1) {
                Color origColor = g.getColor();
                int w = this.getSize().width;
                int h = this.getSize().height;
                int x1 = 0;
                int y1 = 0;
                int x2 = x1 + w - 1;
                int y2 = y1 + h - 1;
                int[] xs = new int[]{x1, x2, x2 - h + 1, x1};
                int[] ys = new int[]{y1, y1, y2, y2};
                g.setColor(UIManager.getColor("KDContainer.labelBackColor"));
                g.fillPolygon(xs, ys, xs.length);
                g.setColor(KingdeeContainerUI.this.getInnerTopColor());
                g.drawLine(xs[0], ys[0] + 1, xs[1] - 1, ys[1] + 1);
                g.setColor(KingdeeContainerUI.this.getInnerBottomColor());
                g.drawLine(xs[3], ys[3] - 1, xs[2], ys[2] - 1);
                g.setColor(KingdeeContainerUI.this.getOuterTopColor());
                g.drawLine(xs[0], ys[0], xs[1], ys[1]);
                g.drawLine(xs[2] + 1, ys[2] - 2, xs[1] - 2, ys[1] + 1);
                g.setColor(KingdeeContainerUI.this.getOuterBottomColor());
                g.drawLine(xs[3], ys[3], xs[2], ys[2]);
                g.drawLine(xs[2], ys[2], xs[1], ys[1]);
                g.setColor(origColor);
            }
            super.paintComponent(g);
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            this.setToolTipText(text);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("Title")) {
                KingdeeContainerUI.this.titleLabel.setText(evt.getNewValue().toString());
            } else if (propertyName.equals("State")) {
                if (KingdeeContainerUI.this.comp.isEnableActive()) {
                    this.resetContainerSize(evt.getNewValue());
                }
            } else if (propertyName.equals("Style")) {
                if (KingdeeContainerUI.this.comp.getTitleStyle() == 2) {
                    if (KingdeeContainerUI.this.comp.isOpaque()) {
                        // empty if block
                    }
                } else if (!KingdeeContainerUI.this.comp.isOpaque()) {
                    KingdeeContainerUI.this.comp.setOpaque(true);
                }
            } else if (propertyName.equals("Actions")) {
                JButton newb = (JButton)evt.getNewValue();
                JButton oldb = (JButton)evt.getOldValue();
                if (newb != null) {
                    KingdeeContainerUI.this.titlePane.add(newb);
                }
                if (oldb != null) {
                    KingdeeContainerUI.this.titlePane.remove(oldb);
                }
                KingdeeContainerUI.this.titlePane.validate();
                KingdeeContainerUI.this.titlePane.repaint();
            } else if (propertyName.equals("Active")) {
                KingdeeContainerUI.this.titleButton.setEnabled((Boolean)evt.getNewValue());
            } else if ("expandButtonVisible".equals(propertyName)) {
                KingdeeContainerUI.this.isDrawArrowBu = (Boolean)evt.getNewValue();
            } else if (propertyName.equals("MsgLabel")) {
                JLabel oldLbl;
                JLabel newLbl = (JLabel)evt.getNewValue();
                if (newLbl != (oldLbl = (JLabel)evt.getOldValue())) {
                    if (oldLbl != null) {
                        KingdeeContainerUI.this.titlePane.remove(oldLbl);
                    }
                    if (newLbl != null) {
                        KingdeeContainerUI.this.titlePane.add(newLbl);
                    }
                    KingdeeContainerUI.this.msgLabel = newLbl;
                }
                KingdeeContainerUI.this.titlePane.validate();
                KingdeeContainerUI.this.titlePane.repaint();
            }
        }

        protected void resetContainerSize(Object newValue) {
            int newState = (Integer)newValue;
            if (newState == 0) {
                Dimension size = KingdeeContainerUI.this.comp.getSize();
                KingdeeContainerUI.this.setSpreadHeight(size.height);
                Insets ins = KingdeeContainerUI.this.comp.getInsets();
                KingdeeContainerUI.this.comp.setSize(size.width, 19 + ins.top + ins.bottom);
                KingdeeContainerUI.this.titleButton.setDirection(7);
                this.setActionsVisible(false);
                KingdeeContainerUI.this.comp.invalidate();
                KingdeeContainerUI.this.comp.repaint();
            } else {
                KingdeeContainerUI.this.comp.setSize(KingdeeContainerUI.this.comp.getWidth(), KingdeeContainerUI.this.getSpreadHeight());
                KingdeeContainerUI.this.titleButton.setDirection(5);
                this.setActionsVisible(true);
                KingdeeContainerUI.this.comp.invalidate();
                KingdeeContainerUI.this.comp.repaint();
            }
        }

        private void setActionsVisible(boolean show) {
            Object[] bs = KingdeeContainerUI.this.comp.getButtons();
            for (int i = 0; i < bs.length; ++i) {
                ((JButton)bs[i]).setVisible(show);
            }
        }
    }

    private class TitleButtonHandler
    extends AbstractAction {
        private static final long serialVersionUID = -5634906382404824054L;

        private TitleButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int state = KingdeeContainerUI.this.comp.getState();
            state = state == 1 ? 0 : 1;
            KingdeeContainerUI.this.comp.setState(state);
        }
    }

    private class TitleLayout
    implements LayoutManager {
        private TitleLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container c) {
            int w = c.getWidth();
            int h = c.getHeight();
            int x = w;
            int y = 1;
            Object[] buttons = KingdeeContainerUI.this.comp.getButtons();
            int childBuCount = buttons.length;
            JButton btn = null;
            Dimension preDim = null;
            int bW = 0;
            int bH = h - 1;
            if (childBuCount > 0) {
                btn = (JButton)buttons[childBuCount - 1];
                preDim = btn.getPreferredSize();
                x = x - 8 - preDim.width;
                bW = preDim.width;
                btn.setBounds(x, y, bW, bH);
            }
            for (int i = childBuCount - 1; i > 0; --i) {
                btn = (JButton)buttons[i - 1];
                preDim = btn.getPreferredSize();
                bW = preDim.width;
                x = x - bW - 2;
                btn.setBounds(x, y, bW, bH);
            }
            int tempX1 = x;
            preDim = KingdeeContainerUI.this.titleButton.getPreferredSize();
            int buX = preDim.width;
            if (KingdeeContainerUI.this.titleButton.isVisible()) {
                KingdeeContainerUI.this.titleButton.setBounds(0, 0, preDim.width, h);
            }
            preDim = KingdeeContainerUI.this.titleLabel.getPreferredSize();
            int fewW = (x -= preDim.width) - 2;
            if (fewW <= preDim.width) {
                bW = fewW;
            } else if (fewW > preDim.width) {
                bW = KingdeeContainerUI.this.comp.getState() == 2 && preDim.width <= 156 ? 156 : preDim.width;
            }
            KingdeeContainerUI.this.titleLabel.setBounds(buX, 0, bW, h);
            int tempX2 = buX + bW;
            if (KingdeeContainerUI.this.msgLabel != null) {
                KingdeeContainerUI.this.msgLabel.setBounds(tempX2, 0, tempX1 - tempX2, 19);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(96, 19);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension titBuDim = KingdeeContainerUI.this.titleButton.getPreferredSize();
            Dimension titLabDim = KingdeeContainerUI.this.titleLabel.getPreferredSize();
            int width = 0;
            Object[] buttons = KingdeeContainerUI.this.comp.getButtons();
            int buCount = buttons.length;
            JButton btn = null;
            Dimension preDim = null;
            if (buCount > 0) {
                btn = (JButton)buttons[buCount - 1];
                preDim = btn.getPreferredSize();
                width += preDim.width + 8;
            }
            for (int i = buCount - 1; i > 0; --i) {
                btn = (JButton)buttons[i - 1];
                preDim = btn.getPreferredSize();
                width += preDim.width + 2;
            }
            width += 2;
            width += titLabDim.width > 156 ? titLabDim.width : 156;
            width += titBuDim.width;
            Insets insets = KingdeeContainerUI.this.titleButton.getInsets();
            width += insets.left + insets.right;
            insets = KingdeeContainerUI.this.titleLabel.getInsets();
            return new Dimension(width += insets.left + insets.right, 19);
        }
    }

    protected class ContainerLayout
    implements LayoutManager {
        protected ContainerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Dimension pDim = parent.getSize();
            int x = insets.left;
            int y = insets.top;
            int parentW = pDim.width - insets.left - insets.right;
            int parentH = pDim.height - insets.top - insets.bottom;
            Dimension titPaneDim = KingdeeContainerUI.this.titlePane.getPreferredSize();
            KingdeeContainerUI.this.titlePane.setBounds(x, y, parentW, titPaneDim.height);
            int conW = parentW;
            int conH = parentH - titPaneDim.height - 8 - 1;
            KingdeeContainerUI.this.comp.getContentPane().setBounds(x, y += titPaneDim.height + 1, conW, conH);
            if (KingdeeContainerUI.this.reseted) {
                int newState = KingdeeContainerUI.this.comp.getState();
                if (newState == 0) {
                    Insets ins = KingdeeContainerUI.this.comp.getInsets();
                    Dimension size = KingdeeContainerUI.this.comp.getSize();
                    KingdeeContainerUI.this.comp.setSize(size.width, 19 + ins.top + ins.bottom);
                    KingdeeContainerUI.this.titleButton.setDirection(7);
                    Object[] bs = KingdeeContainerUI.this.comp.getButtons();
                    for (int i = 0; i < bs.length; ++i) {
                        ((JButton)bs[i]).setVisible(false);
                    }
                    KingdeeContainerUI.this.comp.invalidate();
                    KingdeeContainerUI.this.comp.repaint();
                } else {
                    KingdeeContainerUI.this.comp.setSize(KingdeeContainerUI.this.comp.getWidth(), KingdeeContainerUI.this.getSpreadHeight());
                    KingdeeContainerUI.this.titleButton.setDirection(5);
                    Object[] bs = KingdeeContainerUI.this.comp.getButtons();
                    for (int i = 0; i < bs.length; ++i) {
                        ((JButton)bs[i]).setVisible(true);
                    }
                    KingdeeContainerUI.this.comp.invalidate();
                    KingdeeContainerUI.this.comp.repaint();
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(96, 19);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            Dimension result = new Dimension(0, 0);
            Dimension conDim = KingdeeContainerUI.this.comp.getContentPane().getPreferredSize();
            Dimension titDim = KingdeeContainerUI.this.titlePane.getPreferredSize();
            result.width = conDim.width > titDim.width ? conDim.width : titDim.width;
            result.width += insets.left + insets.right;
            result.height = conDim.height + titDim.height + insets.top + insets.bottom;
            return result;
        }
    }
}

