/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.util.SwingLogUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class KingdeeTextAreaUI
extends BasicTextAreaUI {
    protected transient JTextArea taEditor;
    protected TextAreaListener listener;
    protected TextAreaPropertyChangeListener proListener;
    protected boolean required = false;

    public static ComponentUI createUI(JComponent ta) {
        return new KingdeeTextAreaUI(ta);
    }

    public KingdeeTextAreaUI(JComponent t) {
        this.taEditor = (JTextArea)t;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.taEditor = (JTextArea)c;
        this.taEditor.setDisabledTextColor(UIManager.getColor("TextField.disableForeground"));
        InputMap inputMap = c.getInputMap();
        ActionMap actionMap = c.getActionMap();
        if (inputMap == null || actionMap == null) {
            return;
        }
        KeyStroke newKeyStroke = KeyStroke.getKeyStroke(9, 0, false);
        String newActionName = "tab-forward";
        inputMap.put(newKeyStroke, newActionName);
        newKeyStroke = KeyStroke.getKeyStroke(9, 1, false);
        inputMap.put(newKeyStroke, newActionName);
        newKeyStroke = KeyStroke.getKeyStroke(90, 2, false);
        inputMap.put(newKeyStroke, "undo-forward");
        newKeyStroke = KeyStroke.getKeyStroke(89, 2, false);
        inputMap.put(newKeyStroke, "redo-forward");
        actionMap.put(newActionName, new TabAction());
        actionMap.put("undo-forward", new UndoAction());
        actionMap.put("redo-forward", new RedoAction());
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        InputMap inputMap = this.taEditor.getInputMap();
        ActionMap actionMap = this.taEditor.getActionMap();
        inputMap.remove(KeyStroke.getKeyStroke(90, 2, false));
        inputMap.remove(KeyStroke.getKeyStroke(89, 2, false));
        actionMap.remove("undo-forward");
        actionMap.remove("redo-forward");
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (this.listener == null) {
            this.listener = new TextAreaListener();
        }
        if (this.proListener == null) {
            this.proListener = new TextAreaPropertyChangeListener();
        }
        this.taEditor.addFocusListener(this.listener);
        this.taEditor.addPropertyChangeListener(this.proListener);
    }

    @Override
    public void uninstallListeners() {
        this.taEditor.removePropertyChangeListener(this.proListener);
        this.taEditor.removeFocusListener(this.listener);
        super.uninstallListeners();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.taEditor.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
        this.taEditor.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
        this.taEditor.setDisabledTextColor(UIManager.getColor("TextField.disableForeground"));
    }

    @Override
    protected void paintBackground(Graphics g) {
        Color customForegroundColor = null;
        Color customBackgroundColor = null;
        if (this.taEditor instanceof KDTextArea) {
            customForegroundColor = ((KDTextArea)this.taEditor).getCustomForegroundColor();
            customBackgroundColor = ((KDTextArea)this.taEditor).getCustomBackgroundColor();
        }
        if (this.taEditor instanceof KDTextArea && ((KDTextArea)this.taEditor).getAccessAuthority() == 1) {
            if (this.taEditor instanceof KDTextArea) {
                if (customForegroundColor != null) {
                    this.taEditor.setForeground(customForegroundColor);
                } else {
                    this.taEditor.setForeground(UIManager.getColor("TextField.readonlyForeground"));
                }
            }
            if (customBackgroundColor != null) {
                g.setColor(customBackgroundColor);
            } else {
                g.setColor(UIManager.getColor("TextField.readonlyBackground"));
            }
        } else if (this.taEditor.isEnabled()) {
            super.paintBackground(g);
            if (this.taEditor.isEditable()) {
                if (this.required) {
                    if (this.taEditor instanceof KDTextArea) {
                        if (customForegroundColor != null) {
                            this.taEditor.setForeground(customForegroundColor);
                        } else {
                            this.taEditor.setForeground(UIManager.getColor("TextField.requiredForeground"));
                        }
                    }
                    if (customBackgroundColor != null) {
                        g.setColor(customBackgroundColor);
                    } else {
                        g.setColor(UIManager.getColor("TextField.requiredBackground"));
                    }
                } else {
                    if (this.taEditor instanceof KDTextArea) {
                        if (customForegroundColor != null) {
                            this.taEditor.setForeground(customForegroundColor);
                        } else {
                            this.taEditor.setForeground(UIManager.getColor("TextField.foreground"));
                        }
                    }
                    if (customBackgroundColor != null) {
                        g.setColor(customBackgroundColor);
                    } else {
                        g.setColor(UIManager.getColor("TextField.background"));
                    }
                }
            } else if (this.required) {
                if (this.taEditor.getClientProperty("promptbox") != null) {
                    if (this.taEditor instanceof KDTextArea) {
                        if (customForegroundColor != null) {
                            this.taEditor.setForeground(customForegroundColor);
                        } else {
                            this.taEditor.setForeground(UIManager.getColor("TextField.requiredForeground"));
                        }
                    }
                    if (customBackgroundColor != null) {
                        g.setColor(customBackgroundColor);
                    } else {
                        g.setColor(UIManager.getColor("TextField.requiredBackground"));
                    }
                } else {
                    if (this.taEditor instanceof KDTextArea) {
                        if (customForegroundColor != null) {
                            this.taEditor.setForeground(customForegroundColor);
                        } else {
                            this.taEditor.setForeground(UIManager.getColor("TextField.disableForeground"));
                        }
                    }
                    if (customBackgroundColor != null) {
                        g.setColor(customBackgroundColor);
                    } else {
                        g.setColor(UIManager.getColor("TextField.disableBackground"));
                    }
                }
            } else if (this.taEditor.getClientProperty("promptbox") != null) {
                if (this.taEditor instanceof KDTextArea) {
                    if (customForegroundColor != null) {
                        this.taEditor.setForeground(customForegroundColor);
                    } else {
                        this.taEditor.setForeground(UIManager.getColor("TextField.foreground"));
                    }
                }
                if (customBackgroundColor != null) {
                    g.setColor(customBackgroundColor);
                } else {
                    g.setColor(UIManager.getColor("TextField.background"));
                }
            } else {
                if (this.taEditor instanceof KDTextArea) {
                    if (customForegroundColor != null) {
                        this.taEditor.setForeground(customForegroundColor);
                    } else {
                        this.taEditor.setForeground(UIManager.getColor("TextField.disableForeground"));
                    }
                }
                if (customBackgroundColor != null) {
                    g.setColor(customBackgroundColor);
                } else {
                    g.setColor(UIManager.getColor("TextField.disableBackground"));
                }
            }
        } else {
            if (this.taEditor instanceof KDTextArea) {
                if (customForegroundColor != null) {
                    this.taEditor.setDisabledTextColor(customForegroundColor);
                } else {
                    this.taEditor.setDisabledTextColor(UIManager.getColor("TextField.disableForeground"));
                }
            }
            if (customBackgroundColor != null) {
                g.setColor(customBackgroundColor);
            } else {
                g.setColor(UIManager.getColor("TextField.disableBackground"));
            }
        }
        g.fillRect(0, 0, this.taEditor.getWidth(), this.taEditor.getHeight());
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Rectangle rect = super.getVisibleEditorRect();
        if (rect != null) {
            rect.x = 3;
        }
        return rect;
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        try {
            return super.getNextVisualPositionFrom(t, pos, b, direction, biasRet);
        }
        catch (Exception ex) {
            SwingLogUtil.info((String)"Bad location for KDTextArea...");
            return 0;
        }
    }

    protected class TextAreaPropertyChangeListener
    implements PropertyChangeListener {
        protected TextAreaPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "required") {
                if (evt.getNewValue() != evt.getOldValue()) {
                    KingdeeTextAreaUI.this.required = (Boolean)evt.getNewValue();
                    Component c = (Component)evt.getSource();
                    c.repaint();
                }
            } else if (evt.getPropertyName().equals("customForegroundColorChanged")) {
                ((Component)evt.getSource()).repaint();
            } else if (evt.getPropertyName().equals("customBackgroundColorChanged")) {
                ((Component)evt.getSource()).repaint();
            }
        }
    }

    protected static class TextAreaListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            Component c = (Component)e.getSource();
            c.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            Component c = (Component)e.getSource();
            c.repaint();
        }
    }

    public class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -2557451669062656586L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (((KDTextArea)KingdeeTextAreaUI.this.taEditor).manager.canRedo()) {
                    ((KDTextArea)KingdeeTextAreaUI.this.taEditor).manager.redo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -439791976714178835L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                if (((KDTextArea)KingdeeTextAreaUI.this.taEditor).manager.canUndo()) {
                    ((KDTextArea)KingdeeTextAreaUI.this.taEditor).manager.undo();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class TabAction
    extends AbstractAction {
        private static final long serialVersionUID = -1113805366077811630L;

        @Override
        public void actionPerformed(ActionEvent evt) {
            KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (fm != null) {
                if (evt.getModifiers() == 1) {
                    fm.focusPreviousComponent();
                } else {
                    fm.focusNextComponent();
                }
            }
        }
    }
}

