/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.workbench.ui;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.workbench.logic.TrimWidgetManager;
import com.kingdee.bos.ctrl.workbench.persist.IIOProvider;
import com.kingdee.bos.ctrl.workbench.persist.TrimDatabase;
import com.kingdee.bos.ctrl.workbench.splash.NotifyObject;
import com.kingdee.bos.ctrl.workbench.ui.IDockable;
import com.kingdee.bos.ctrl.workbench.ui.ITrimWidget;
import com.kingdee.bos.ctrl.workbench.ui.TrimWidgetPlaceholder;
import com.kingdee.bos.util.backport.LinkedList;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.apache.commons.io.FilenameUtils;

public class Perspective
extends JPanel
implements IDockable {
    public static final String KEY_MSG = "msg";
    public static final String KEY_TITLE = "title";
    public static final String KEY_MSG1 = "msg1";
    public static final String KEY_MSG2 = "msg2";
    private static final boolean DEBUG = true;
    private Rectangle dockRect;
    private TrimWidgetManager trimWidgetManager;
    private ITrimWidget exclusiveTrim;
    private String perspectiveName;
    private IIOProvider ioProvider;
    private boolean autoInstantiated = false;
    private String version;
    private String ioCache;
    private HashMap trimInstances = new HashMap();
    private NotifyObject notice = NotifyObject.getCurrentInstance();
    private String[] messages = new String[]{"\u89e3\u6790\u6a21\u677f\u6587\u4ef6", "\u89e3\u6790\u6a21\u677f\u6587\u4ef6\u5b8c\u6bd5", "\u52a0\u8f7d\u62d6\u62fd\u5e03\u5c40\u7ba1\u7406\u5668", "\u52a0\u8f7d\u5c5e\u6027\u8868"};
    private int progress = 0;

    public static String getLocalText(String key, String defaultStr) {
        return LanguageManager.getLangMessage((String)key, Perspective.class, (String)defaultStr);
    }

    public Perspective(String perspectiveName, String version) {
        if (perspectiveName == null || version == null) {
            throw new NullPointerException(Perspective.getLocalText(KEY_MSG, "\u900f\u89c6\u56fe\u540d\u79f0\u548c\u7248\u672c\u53f7\u5747\u4e0d\u53ef\u4e3a\u7a7a"));
        }
        this.perspectiveName = perspectiveName;
        this.version = version;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.autoInstantiated = this.instantiate();
    }

    public Perspective(String perspectiveName, String version, IIOProvider ioProvider) {
        if (perspectiveName == null || version == null) {
            throw new NullPointerException(Perspective.getLocalText(KEY_MSG, "\u900f\u89c6\u56fe\u540d\u79f0\u548c\u7248\u672c\u53f7\u5747\u4e0d\u53ef\u4e3a\u7a7a"));
        }
        this.ioProvider = ioProvider;
        this.perspectiveName = perspectiveName;
        this.version = version;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.autoInstantiated = this.instantiate();
    }

    public String getIOCache() {
        return this.ioCache;
    }

    public IIOProvider getIOProvider() {
        return this.ioProvider;
    }

    public boolean isAutoInstantiated() {
        return this.autoInstantiated;
    }

    public TrimWidgetManager getTrimWidgetManager() {
        if (this.trimWidgetManager == null) {
            this.trimWidgetManager = new TrimWidgetManager(this);
        }
        return this.trimWidgetManager;
    }

    public Component getPerspectiveRootElement() {
        return this.getComponentCount() == 0 ? null : this.getComponent(0);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.dockRect != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.blue.brighter());
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.drawRect(this.dockRect.x, this.dockRect.y, this.dockRect.width, this.dockRect.height);
        }
    }

    @Override
    public void dockingTo(int areaId) {
        int w = this.getWidth();
        int h = this.getHeight();
        int dockx = (int)((double)w * 0.2);
        int docky = (int)((double)h * 0.2);
        switch (areaId) {
            case 3: {
                this.dockRect = new Rectangle(1, 1, dockx - 3, h - 3);
                this.repaint();
                break;
            }
            case 4: {
                this.dockRect = new Rectangle(w - dockx + 1, 1, dockx - 3, h - 3);
                this.repaint();
                break;
            }
            case 1: {
                this.dockRect = new Rectangle(1, 1, w - 3, docky - 3);
                this.repaint();
                break;
            }
            case 2: {
                this.dockRect = new Rectangle(1, h - docky + 1, w - 3, docky - 3);
                this.repaint();
                break;
            }
            default: {
                this.dockRect = null;
                this.repaint();
            }
        }
    }

    public void setExclusiveTrim(ITrimWidget exclusiveTrim) {
        if (exclusiveTrim.getPerspective() == null) {
            return;
        }
        this.persistToCache();
        this.dissociateDescendantTrims();
        this.removeAll();
        exclusiveTrim.setPerspective(this);
        this.exclusiveTrim = exclusiveTrim;
        exclusiveTrim.exclusiveNotify(true);
        this.add((Component)((Object)exclusiveTrim));
        this.revalidate();
        this.repaint();
    }

    private void dissociateDescendantTrims() {
        Component c = this.getPerspectiveRootElement();
        if (c == null) {
            return;
        }
        if (c instanceof TrimWidgetPlaceholder) {
            this.dissociateDescendantTrims((TrimWidgetPlaceholder)c);
        } else {
            ((ITrimWidget)((Object)c)).setPerspective(null);
        }
    }

    private void dissociateDescendantTrims(TrimWidgetPlaceholder pher) {
        Component left = pher.getLeftComponent();
        if (left instanceof TrimWidgetPlaceholder) {
            this.dissociateDescendantTrims((TrimWidgetPlaceholder)left);
        } else {
            ((ITrimWidget)((Object)left)).setPerspective(null);
        }
        Component right = pher.getRightComponent();
        if (right instanceof TrimWidgetPlaceholder) {
            this.dissociateDescendantTrims((TrimWidgetPlaceholder)right);
        } else {
            ((ITrimWidget)((Object)right)).setPerspective(null);
        }
    }

    public void showAllInclusions() {
        if (!this.isExclusiveView()) {
            return;
        }
        this.exclusiveTrim.setPerspective(null);
        this.exclusiveTrim.exclusiveNotify(false);
        this.exclusiveTrim = null;
        this.removeAll();
        this.instantiate(true);
        this.revalidate();
        this.repaint();
    }

    public boolean isExclusiveView() {
        return this.exclusiveTrim != null;
    }

    public ITrimWidget getExclusiveView() {
        return this.exclusiveTrim;
    }

    public String getPerspectiveName() {
        return this.perspectiveName;
    }

    public String getVersion() {
        return this.version;
    }

    public ITrimWidget getTrimWidget(String trimId) {
        Object trim = this.trimInstances.get(trimId);
        if (trim != null) {
            return (ITrimWidget)trim;
        }
        this.nextStage();
        trim = TrimDatabase.createTrimWidget(trimId);
        this.trimInstances.put(trimId, trim);
        return (ITrimWidget)trim;
    }

    public HashMap getTrims() {
        return this.trimInstances;
    }

    private void nextStage() {
        if (this.progress < this.messages.length - 1) {
            ++this.progress;
        }
        this.notice.notice(0, this.messages[this.progress]);
    }

    public void registerTrimWidget(String trimId, ITrimWidget trim) {
        this.trimInstances.put(trimId, trim);
    }

    public boolean instantiate() {
        return this.instantiate(false);
    }

    /*
     * Exception decompiling
     */
    public boolean instantiate(boolean ignoreExclusive) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() {
        this.persistToCache();
        if (this.ioCache != null) {
            OutputStream os = null;
            PrintStream ps = null;
            try {
                IIOProvider ioProvider = this.getIOProvider();
                os = ioProvider != null ? ioProvider.getPersistenceOutputStream() : new FileOutputStream(new File(FilenameUtils.normalize((String)(TrimDatabase.CONFIG_DIR + File.separator + this.getPerspectiveName() + ".conf"))));
                ps = new PrintStream(os);
                ps.print(this.ioCache);
                ps.flush();
            }
            catch (Exception exception) {
                CloseUtil.close((Closeable[])new Closeable[]{ps, os});
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{ps, os});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{ps, os});
        }
    }

    public void persistToCache() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ITrimWidget exclusiveTrim = this.getExclusiveView();
        this.showAllInclusions();
        long t1 = System.currentTimeMillis();
        PrintStream ps = new PrintStream(bos);
        ps.println(this.getVersion());
        Object node = this.getPerspectiveRootElement();
        if (node == null) {
            ps.print("");
            ps.flush();
            ps.close();
            this.ioCache = new String(bos.toByteArray());
            return;
        }
        if (node instanceof ITrimWidget) {
            if (exclusiveTrim == null) {
                ps.println(((ITrimWidget)node).getId());
            } else {
                ps.println(((ITrimWidget)node).getId() + this.getGap() + exclusiveTrim.getId());
            }
            long t2 = System.currentTimeMillis();
            System.out.println("perspective(" + this.getPerspectiveName() + ") persisted to the config cache. time elapsed " + (t2 - t1));
            ps.flush();
            ps.close();
            this.ioCache = new String(bos.toByteArray());
            return;
        }
        LinkedList queue = new LinkedList();
        queue.offer(node);
        Component firstTw = node;
        while (!(firstTw instanceof ITrimWidget)) {
            firstTw = ((TrimWidgetPlaceholder)firstTw).getLeftComponent();
        }
        if (exclusiveTrim == null) {
            ps.println(((ITrimWidget)((Object)firstTw)).getId());
        } else {
            ps.println(((ITrimWidget)((Object)firstTw)).getId() + this.getGap() + exclusiveTrim.getId());
        }
        while (!queue.isEmpty()) {
            node = queue.poll();
            if (!(node instanceof TrimWidgetPlaceholder)) continue;
            TrimWidgetPlaceholder twp = (TrimWidgetPlaceholder)node;
            this.buildInformation4Composite(twp, ps);
            queue.offer((Object)twp.getLeftComponent());
            queue.offer((Object)twp.getRightComponent());
        }
        long t2 = System.currentTimeMillis();
        System.out.println("perspective(" + this.getPerspectiveName() + ") persisted to the config cache. time elapsed " + (t2 - t1));
        ps.flush();
        ps.close();
        this.ioCache = new String(bos.toByteArray());
    }

    public List getToolBars() {
        return null;
    }

    public KDMenuBar getMenuBar() {
        return null;
    }

    private void buildInformation4Composite(TrimWidgetPlaceholder twp, PrintStream ps) {
        Component llEst = twp.getLeftComponent();
        Component rlEst = twp.getRightComponent();
        while (!(llEst instanceof ITrimWidget)) {
            llEst = ((TrimWidgetPlaceholder)llEst).getLeftComponent();
        }
        while (!(rlEst instanceof ITrimWidget)) {
            rlEst = ((TrimWidgetPlaceholder)rlEst).getLeftComponent();
        }
        ps.print(((ITrimWidget)((Object)llEst)).getId());
        ps.print(this.getGap());
        ps.print(((ITrimWidget)((Object)rlEst)).getId());
        ps.print(this.getGap());
        ps.print(this.getOrientation(twp));
        ps.print(this.getGap());
        BigDecimal bd = new BigDecimal(1.0 - twp.getDividerLocation());
        bd = bd.setScale(4, 4);
        ps.println(bd);
    }

    private String getGap() {
        return "  ";
    }

    private String getOrientation(TrimWidgetPlaceholder twp) {
        return twp.getOrientation() == 0 ? "VERTICAL_SPLIT" : "HORIZONTAL_SPLIT";
    }
}

