/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app;

import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app.DBConnectionInfo;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClearConnThread
extends Thread {
    public boolean isRunning;
    private Map session;
    private int time;

    public ClearConnThread(Map map, int time) {
        this.session = map;
        this.isRunning = true;
        this.time = time;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        super.run();
        while (this.isRunning) {
            try {
                Thread.sleep(60000 * this.time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.session.size() == 0) continue;
            for (Object key : this.session.keySet()) {
                List list = (List)this.session.get(key);
                try {
                    this.clear(list);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (list.size() != 0) continue;
                this.session.remove(key);
            }
        }
    }

    private void clear(List list) throws SQLException {
        Iterator iter = list.iterator();
        long now = System.currentTimeMillis();
        while (iter.hasNext()) {
            DBConnectionInfo info = (DBConnectionInfo)iter.next();
            long l = now - info.lastAccseeTime;
            if (l <= 1800000L) continue;
            info.close();
            iter.remove();
        }
    }

    public void stopRunning() throws SQLException {
        this.isRunning = false;
        this.closeAllClientConnection();
        this.session.clear();
    }

    private void closeAllClientConnection() throws SQLException {
        for (Object key : this.session.keySet()) {
            List list = (List)this.session.get(key);
            this.close(list);
            this.session.remove(key);
        }
    }

    private void close(List list) throws SQLException {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            DBConnectionInfo info = (DBConnectionInfo)iter.next();
            info.close();
            iter.remove();
        }
    }
}

