/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app;

import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.ProxyResultSet;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app.ClearConnThread;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app.DBConnectionInfo;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.app.StatementInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NIOSessionManage {
    private Map cache;
    private ClearConnThread clearor;
    private static final int MINIT = 30;
    private static NIOSessionManage instance;

    private void init() {
        this.cache = new Hashtable();
        this.clearor = new ClearConnThread(this.cache, 30);
        this.clearor.start();
    }

    private List getClientConns(String clientID) {
        if (this.cache.containsKey(clientID)) {
            return (List)this.cache.get(clientID);
        }
        LinkedList list = new LinkedList();
        this.cache.put(clientID, list);
        return list;
    }

    public DBConnectionInfo getClientConn(String clientID, String connectionID) {
        List conns = this.getClientConns(clientID);
        if (conns.size() == 0) {
            this.cache.remove(clientID);
            return null;
        }
        for (int i = 0; i < conns.size(); ++i) {
            DBConnectionInfo info = (DBConnectionInfo)conns.get(i);
            if (!connectionID.equals(info.connectionID)) continue;
            info.reSetLastAccseeTime();
            return info;
        }
        return null;
    }

    public StatementInfo getStatementInfo(String clientID, String connectionID, String statementID) {
        DBConnectionInfo info = this.getClientConn(clientID, connectionID);
        if (info == null) {
            return null;
        }
        return info.getStatementInfo(statementID);
    }

    public void close(String clientID) {
        if (!this.cache.containsKey(clientID)) {
            return;
        }
        List list = (List)this.cache.get(clientID);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            DBConnectionInfo info = (DBConnectionInfo)iter.next();
            info.close();
            iter.remove();
        }
        this.cache.remove(clientID);
    }

    public void close(String clientID, String connectionID) {
        DBConnectionInfo connInfo = this.getClientConn(clientID, connectionID);
        List clientConns = this.getClientConns(clientID);
        if (connInfo != null) {
            connInfo.close();
            clientConns.remove(connInfo);
        }
        if (clientConns.size() == 0) {
            this.cache.remove(clientID);
        }
    }

    public void close(String clientID, String connectionID, String statmentID) {
        DBConnectionInfo connInfo = this.getClientConn(clientID, connectionID);
        StatementInfo statementInfo = connInfo.getStatementInfo(statmentID);
        if (statementInfo != null) {
            statementInfo.close();
        }
        connInfo.statMents.remove(statmentID);
    }

    public void close(String clientID, String connectionID, String statmentID, String rsID) {
        DBConnectionInfo connInfo = this.getClientConn(clientID, connectionID);
        ProxyResultSet resultset = connInfo.getResultSet(statmentID, rsID);
        if (resultset != null) {
            try {
                resultset.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connInfo.resultSets.containsKey(rsID)) {
            connInfo.resultSets.remove(rsID);
        } else {
            StatementInfo statementInfo = connInfo.getStatementInfo(statmentID);
            if (statementInfo != null) {
                statementInfo.res.remove(rsID);
            }
        }
    }

    public void registerConnection(String clientID, String connectionID, Connection conn) {
        DBConnectionInfo connInfo = new DBConnectionInfo(connectionID, conn);
        this.getClientConns(clientID).add(connInfo);
    }

    public void registerStatement(String clientID, String connectionID, String statementID, StatementInfo statementInfo) {
        DBConnectionInfo clientConn = this.getClientConn(clientID, connectionID);
        if (clientConn == null) {
            return;
        }
        clientConn.putStatement(statementID, statementInfo);
    }

    public void registerResultID(String clientID, String connectionID, String statementID, String rsID, ResultSet rsInfo) {
        DBConnectionInfo clientConn = this.getClientConn(clientID, connectionID);
        if (clientConn == null) {
            return;
        }
        clientConn.putResultSet(statementID, rsID, rsInfo);
    }

    public void registerObj(String clientID, String connectionID, String objID, Object obj) {
        DBConnectionInfo connInfo = this.getClientConn(clientID, connectionID);
        if (connInfo != null) {
            connInfo.putObj(objID, obj);
        }
    }

    public Object getObj(String clientID, String connectionID, String objID) {
        DBConnectionInfo connInfo = this.getClientConn(clientID, connectionID);
        if (connInfo != null) {
            return connInfo.getObj(objID);
        }
        return null;
    }

    public static synchronized NIOSessionManage getInstance() {
        if (instance == null) {
            instance = new NIOSessionManage();
            instance.init();
        }
        return instance;
    }

    private NIOSessionManage() {
    }
}

