/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.transport;

import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.MsgHandle;
import com.kingdee.eas.framework.bireport.bimanager.etl.proxyDB.transport.TransportObj;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.ConnectFuture;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoAcceptor;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoHandlerAdapter;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.IoSession;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.common.support.BaseIoServiceConfig;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.filter.codec.ProtocolCodecFilter;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.filter.codec.serialization.ObjectSerializationCodecFactory;
import com.kingdee.eas.framework.bireport.bimanager.org.apache.mina.util.AvailablePortFinder;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.IOException;
import java.net.InetSocketAddress;

public abstract class AbstractAcceptor {
    private MsgHandle msgHandle;
    private ExecutorService msgHandleService;
    private IoAcceptor acceptor;
    private static final int defalutMsgHandleCount = 25;
    private int port;
    private boolean isRunning;
    private ConnectFuture future;
    private AtomicInteger sessionSize = new AtomicInteger();

    protected abstract IoAcceptor createAcceptor();

    protected abstract BaseIoServiceConfig getConfig();

    public AbstractAcceptor(MsgHandle msgHandle) {
        this.init();
        this.msgHandle = msgHandle;
    }

    protected void init() {
        this.initProt();
        this.msgHandleService = Executors.newFixedThreadPool((int)25);
        this.acceptor = this.createAcceptor();
        while (true) {
            try {
                BaseIoServiceConfig cfg = this.getConfig();
                cfg.getFilterChain().addLast("codec", new ProtocolCodecFilter(new ObjectSerializationCodecFactory()));
                this.acceptor.bind(new InetSocketAddress(this.port), new ServerHandle(), cfg);
            }
            catch (IOException e) {
                this.initProt();
                continue;
            }
            break;
        }
        this.isRunning = true;
    }

    public ExecutorService getExecutor() {
        return this.msgHandleService;
    }

    public int getPort() {
        return this.port;
    }

    protected void initProt() {
        this.port = AvailablePortFinder.getNextAvailable(1025);
    }

    public void restart() {
        this.stop();
        this.init();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
        try {
            if (this.future.getSession() != null && this.future.getSession().isConnected()) {
                this.future.getSession().close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.acceptor.unbindAll();
        this.msgHandleService.shutdown();
    }

    public int connectionSize() {
        return this.sessionSize.get();
    }

    class ServerHandle
    extends IoHandlerAdapter {
        ServerHandle() {
        }

        @Override
        public void sessionOpened(IoSession session) throws Exception {
            AbstractAcceptor.this.sessionSize.incrementAndGet();
        }

        @Override
        public void sessionClosed(IoSession session) throws Exception {
            AbstractAcceptor.this.sessionSize.decrementAndGet();
        }

        @Override
        public void messageReceived(IoSession session, Object message) throws Exception {
            if (message instanceof TransportObj) {
                AbstractAcceptor.this.msgHandleService.submit((Runnable)new HandleMsgListener(session, (TransportObj)message));
            }
        }
    }

    class HandleMsgListener
    implements Runnable {
        private IoSession session;
        private TransportObj to;

        public HandleMsgListener(IoSession session, TransportObj to) {
            this.session = session;
            this.to = to;
        }

        @Override
        public void run() {
            try {
                Object result = AbstractAcceptor.this.msgHandle.handle(this.to.command);
                this.to.setResult(result);
                this.session.write(this.to);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

